/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.cache.impl;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.cache.impl.ConcurrentLruCache;
import com.github.dandelion.core.asset.cache.spi.AbstractAssetCache;
import java.util.Map;
import java.util.Set;

public class MemoryAssetCache
extends AbstractAssetCache {
    private Map<String, String> mapAssetContent;
    private Map<String, Set<Asset>> mapRequestAssets;

    @Override
    public void initCache(Context context) {
        super.initCache(context);
        this.mapAssetContent = new ConcurrentLruCache<String, String>(context.getConfiguration().getCacheAssetMaxSize());
        this.mapRequestAssets = new ConcurrentLruCache<String, Set<Asset>>(context.getConfiguration().getCacheRequestMaxSize());
    }

    @Override
    public String getCacheName() {
        return "default";
    }

    @Override
    public String getAssetContent(String cacheKey) {
        return this.mapAssetContent.get(cacheKey);
    }

    @Override
    public Set<Asset> getRequestAssets(String cacheKey) {
        return this.mapRequestAssets.get(cacheKey);
    }

    @Override
    public void storeAssetContent(String cacheKey, String cacheContent) {
        this.mapAssetContent.put(cacheKey, cacheContent);
    }

    @Override
    public void storeRequestAssets(String cacheKey, Set<Asset> a) {
        this.mapRequestAssets.put(cacheKey, a);
    }

    @Override
    public void remove(String cacheKey) {
        this.mapAssetContent.remove(cacheKey);
    }

    public Map<String, String> getCache() {
        return this.mapAssetContent;
    }

    @Override
    public void clearAll() {
        this.mapAssetContent.clear();
        this.mapRequestAssets.clear();
    }
}

