/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.cache.impl;

import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.locks.ReadWriteLock;
import java.util.concurrent.locks.ReentrantReadWriteLock;

public class ConcurrentLruCache<K, V>
extends LinkedHashMap<K, V> {
    private static final long serialVersionUID = 4555114766903087183L;
    private int maxEntries;
    private ReadWriteLock lock = new ReentrantReadWriteLock();

    public ConcurrentLruCache(int maxEntries) {
        super(maxEntries + 1);
        this.maxEntries = maxEntries;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, V> eldest) {
        return super.size() > this.maxEntries && this.isRemovable(eldest);
    }

    protected boolean isRemovable(Map.Entry<K, V> eldest) {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V get(Object key) {
        try {
            this.lock.readLock().lock();
            Object v = super.get(key);
            return v;
        }
        finally {
            this.lock.readLock().unlock();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public V put(K key, V value) {
        try {
            this.lock.writeLock().lock();
            V v = super.put(key, value);
            return v;
        }
        finally {
            this.lock.writeLock().unlock();
        }
    }
}

