/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset.cache;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.utils.Sha1Utils;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetCacheManager {
    private static final Logger LOG = LoggerFactory.getLogger(AssetCacheManager.class);
    private Context context;

    public AssetCacheManager(Context context) {
        this.context = context;
    }

    public String generateCacheKey(String context, Asset asset) {
        StringBuilder key = new StringBuilder(Sha1Utils.generateSha1(context, true));
        key.append("/");
        key.append(asset.getName());
        key.append("-");
        key.append(asset.getVersion());
        key.append(".");
        key.append(asset.getType().name());
        return key.toString();
    }

    public String generateCacheKeyMin(String context, Asset asset) {
        StringBuilder key = new StringBuilder(Sha1Utils.generateSha1(context, true));
        key.append("/");
        key.append(asset.getName());
        key.append("-");
        key.append(asset.getVersion());
        key.append(".min.");
        key.append(asset.getType().name());
        return key.toString();
    }

    public String getCacheKeyFromRequest(HttpServletRequest request) {
        String cacheKey = request.getRequestURL().substring(request.getRequestURL().indexOf("/dandelion-assets/") + "/dandelion-assets/".length());
        return cacheKey;
    }

    public String getContent(String cacheKey) {
        LOG.debug("Retrieving asset with the key {}", (Object)cacheKey);
        return this.context.getAssetCache().getAssetContent(cacheKey);
    }

    public Set<Asset> getAssets(String cacheKey) {
        return this.context.getAssetCache().getRequestAssets(cacheKey);
    }

    public String storeContent(String key, String content) {
        LOG.debug("Storing asset under the key {}", (Object)key);
        this.context.getAssetCache().storeAssetContent(key, content);
        return content;
    }

    public Set<Asset> storeAssets(String key, Set<Asset> a) {
        this.context.getAssetCache().storeRequestAssets(key, a);
        return a;
    }

    public void remove(String key) {
        LOG.debug("Removing asset under the key {}", (Object)key);
        this.context.getAssetCache().remove(key);
    }

    public String getCacheName() {
        return this.context.getAssetCache().getCacheName();
    }

    public void clearCache() {
        this.context.getAssetCache();
    }
}

