/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset;

import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetDomPosition;
import com.github.dandelion.core.asset.AssetType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;

public final class AssetUtils {
    public static Set<Asset> filtersByType(Set<Asset> assets, AssetType ... filters) {
        LinkedHashSet<Asset> retval = new LinkedHashSet<Asset>();
        ArrayList<AssetType> types = new ArrayList<AssetType>(Arrays.asList(filters));
        for (Asset asset : assets) {
            if (!types.contains((Object)asset.getType())) continue;
            retval.add(asset);
        }
        return retval;
    }

    public static Set<Asset> filtersByName(Set<Asset> assets, String[] excludedAssetNames) {
        List<String> excludedAssetNameList = Arrays.asList(excludedAssetNames);
        LinkedHashSet<Asset> filteredAsus = new LinkedHashSet<Asset>();
        for (Asset asset : assets) {
            if (excludedAssetNameList.contains(asset.getName().trim().toLowerCase())) continue;
            filteredAsus.add(asset);
        }
        return filteredAsus;
    }

    public static Set<Asset> filtersByNameAndType(Set<Asset> assets, String[] excludedAssetNames, AssetType type) {
        List<String> excludedAssetNameList = Arrays.asList(excludedAssetNames);
        LinkedHashSet<Asset> filteredAsus = new LinkedHashSet<Asset>();
        for (Asset asset : assets) {
            if (asset.getType().equals((Object)type) && excludedAssetNameList.contains(asset.getName().trim().toLowerCase())) continue;
            filteredAsus.add(asset);
        }
        return filteredAsus;
    }

    public static Set<Asset> filtersByDomPosition(Set<Asset> assets, AssetDomPosition desiredPosition) {
        LinkedHashSet<Asset> filteredAsus = new LinkedHashSet<Asset>();
        LinkedHashSet<Asset> filteredJsAsus = new LinkedHashSet<Asset>();
        for (Asset asset : assets) {
            AssetDomPosition assetPosition;
            AssetDomPosition assetDomPosition = assetPosition = asset.getDom() == null ? asset.getType().getDefaultDom() : asset.getDom();
            if (assetPosition.equals((Object)desiredPosition) && asset.getType().equals((Object)AssetType.js)) {
                filteredJsAsus.add(asset);
                continue;
            }
            if (!assetPosition.equals((Object)desiredPosition) || asset.getType().equals((Object)AssetType.js)) continue;
            filteredAsus.add(asset);
        }
        filteredAsus.addAll(filteredJsAsus);
        return filteredAsus;
    }

    private AssetUtils() {
    }
}

