/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset;

import com.github.dandelion.core.asset.AssetDomPosition;

public enum AssetType {
    css("text/css", AssetDomPosition.head),
    js("application/javascript", AssetDomPosition.body);

    private String contentType;
    private AssetDomPosition defaultDom;

    private AssetType(String contentType, AssetDomPosition defaultDom) {
        this.contentType = contentType;
        this.defaultDom = defaultDom;
    }

    public String getContentType() {
        return this.contentType;
    }

    public AssetDomPosition getDefaultDom() {
        return this.defaultDom;
    }

    public static AssetType typeOfAsset(String resource) {
        for (AssetType type : AssetType.values()) {
            if (!resource.endsWith(type.name())) continue;
            return type;
        }
        return null;
    }
}

