/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.AssetDomPosition;
import com.github.dandelion.core.asset.AssetMapper;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.asset.AssetUtils;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.core.storage.BundleStorageUnit;
import com.github.dandelion.core.utils.UrlUtils;
import com.github.dandelion.core.web.AssetRequestContext;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.servlet.ServletRequest;
import javax.servlet.http.HttpServletRequest;

public class AssetQuery {
    private Set<Asset> requestedAssets;
    private Context context;
    private HttpServletRequest request;

    public AssetQuery(HttpServletRequest request, Context context) {
        String[] excludedCssNames;
        String[] excludedJsNames;
        this.request = request;
        this.context = context;
        String key = UrlUtils.getCurrentUri(request).toString();
        this.requestedAssets = context.getCacheManager().getAssets(key);
        if (this.requestedAssets == null || context.isDevModeEnabled()) {
            LinkedHashSet<AssetStorageUnit> assetStorageUnits = new LinkedHashSet<AssetStorageUnit>();
            String[] bundleNames = AssetRequestContext.get((ServletRequest)request).getBundles(true);
            for (BundleStorageUnit bsu : context.getBundleStorage().bundlesFor(bundleNames)) {
                assetStorageUnits.addAll(bsu.getAssetStorageUnits());
            }
            AssetMapper assetMapper = new AssetMapper(request, context);
            Set<Asset> mappedAssets = assetMapper.mapToAssets(assetStorageUnits);
            mappedAssets = context.getProcessorManager().process(mappedAssets, request);
            this.requestedAssets = context.getCacheManager().storeAssets(key, mappedAssets);
        }
        if ((excludedJsNames = this.collectJsToExclude()).length > 0) {
            this.excludeJs(excludedJsNames);
        }
        if ((excludedCssNames = this.collectCssToExclude()).length > 0) {
            this.excludeCss(excludedCssNames);
        }
    }

    public AssetQuery withPosition(AssetDomPosition desiredPosition) {
        this.requestedAssets = AssetUtils.filtersByDomPosition(this.requestedAssets, desiredPosition);
        return this;
    }

    public AssetQuery excludeJs(String[] excludedJsNames) {
        this.requestedAssets = AssetUtils.filtersByNameAndType(this.requestedAssets, excludedJsNames, AssetType.js);
        return this;
    }

    public AssetQuery excludeCss(String[] excludedCssNames) {
        this.requestedAssets = AssetUtils.filtersByNameAndType(this.requestedAssets, excludedCssNames, AssetType.css);
        return this;
    }

    public Set<Asset> perform() {
        return this.requestedAssets;
    }

    private String[] collectJsToExclude() {
        HashSet<String> excludedJs = new HashSet<String>();
        for (String bundleToExclude : AssetRequestContext.get((ServletRequest)this.request).getExcludedBundles()) {
            Set<BundleStorageUnit> bsus = this.context.getBundleStorage().bundlesFor(bundleToExclude);
            for (BundleStorageUnit bsu : bsus) {
                excludedJs.addAll(bsu.getJsAssetStorageUnitNames());
            }
        }
        for (String assetToExclude : AssetRequestContext.get((ServletRequest)this.request).getExcludedJs()) {
            excludedJs.add(assetToExclude);
        }
        return excludedJs.toArray(new String[excludedJs.size()]);
    }

    private String[] collectCssToExclude() {
        HashSet<String> excludedCss = new HashSet<String>();
        for (String bundleToExclude : AssetRequestContext.get((ServletRequest)this.request).getExcludedBundles()) {
            Set<BundleStorageUnit> bsus = this.context.getBundleStorage().bundlesFor(bundleToExclude);
            for (BundleStorageUnit bsu : bsus) {
                excludedCss.addAll(bsu.getCssAssetStorageUnitNames());
            }
        }
        for (String assetToExclude : AssetRequestContext.get((ServletRequest)this.request).getExcludedCss()) {
            excludedCss.add(assetToExclude);
        }
        return excludedCss.toArray(new String[excludedCss.size()]);
    }
}

