/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset;

import com.github.dandelion.core.Context;
import com.github.dandelion.core.DandelionException;
import com.github.dandelion.core.asset.Asset;
import com.github.dandelion.core.asset.locator.spi.AssetLocator;
import com.github.dandelion.core.storage.AssetStorageUnit;
import com.github.dandelion.core.utils.UrlUtils;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AssetMapper {
    private static final Logger LOG = LoggerFactory.getLogger(AssetMapper.class);
    private HttpServletRequest request;
    private Context context;

    public AssetMapper(HttpServletRequest request, Context context) {
        this.request = request;
        this.context = context;
    }

    public Set<Asset> mapToAssets(Set<AssetStorageUnit> asus) {
        LinkedHashSet<Asset> retval = new LinkedHashSet<Asset>();
        for (AssetStorageUnit asu : asus) {
            retval.add(this.mapToAsset(asu));
        }
        return retval;
    }

    public Asset mapToAsset(AssetStorageUnit asu) {
        Asset asset = new Asset(asu);
        LOG.trace("Resolving location for the asset {}", (Object)asset.toLog());
        if (asu.getLocations() == null || asu.getLocations().isEmpty()) {
            StringBuilder msg = new StringBuilder("No location is configured for the asset ");
            msg.append(asu.toLog());
            msg.append(". Please add at least one location in the corresponding JSON file.");
            throw new DandelionException(msg.toString());
        }
        String locationKey = null;
        if (asu.getLocations().size() == 1) {
            locationKey = asu.getLocations().entrySet().iterator().next().getKey();
        } else {
            for (String searchedLocationKey : this.context.getConfiguration().getAssetLocationsResolutionStrategy()) {
                String location;
                if (!asu.getLocations().containsKey(searchedLocationKey) || (location = asu.getLocations().get(searchedLocationKey)) == null || location.isEmpty()) continue;
                locationKey = searchedLocationKey;
                break;
            }
        }
        LOG.trace("Location key '{}' selected for the asset {}", (Object)locationKey, (Object)asu.toString());
        Map<String, AssetLocator> locators = this.context.getAssetLocatorsMap();
        if (!locators.containsKey(locationKey)) {
            StringBuilder msg = new StringBuilder("The location key '");
            msg.append(locationKey);
            msg.append("' is not valid. Please choose a valid one among ");
            msg.append(locators.keySet());
            msg.append(".");
            throw new DandelionException(msg.toString());
        }
        String location = null;
        AssetLocator locator = locators.get(locationKey);
        if (locators.containsKey(locationKey) && locators.get(locationKey).isActive()) {
            LOG.trace("Locator '{}' will be applied on the asset {}.", (Object)locator.getClass().getSimpleName(), (Object)asu.toLog());
            location = locators.get(locationKey).getLocation(asu, this.request);
        }
        asset.setConfigLocationKey(locationKey);
        asset.setConfigLocation(asu.getLocations().get(locationKey));
        if (locator.isCachingForced() || this.context.getConfiguration().isMinificationEnabled()) {
            Map<String, AssetLocator> assetLocatorsMap;
            String context = UrlUtils.getCurrentUrl(this.request, true).toString();
            context = context.replaceAll("\\?", "_").replaceAll("&", "_");
            String cacheKey = this.context.getCacheManager().generateCacheKey(context, asset);
            asu.setCacheKey(cacheKey);
            asset.setCacheKey(cacheKey);
            asset.setFinalLocation(UrlUtils.getProcessedUrl("/dandelion-assets/" + cacheKey, this.request, null));
            String content = this.context.getCacheManager().getContent(asset.getCacheKey());
            if ((content == null || this.context.isDevModeEnabled()) && (assetLocatorsMap = this.context.getAssetLocatorsMap()).containsKey(asset.getConfigLocationKey()) && assetLocatorsMap.get(asset.getConfigLocationKey()).isActive()) {
                content = assetLocatorsMap.get(asset.getConfigLocationKey()).getContent(asu, this.request);
                this.context.getCacheManager().storeContent(asset.getCacheKey(), content);
            }
        } else {
            asset.setFinalLocation(location);
        }
        return asset;
    }
}

