/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core.asset;

import com.github.dandelion.core.asset.AssetDomPosition;
import com.github.dandelion.core.asset.AssetType;
import com.github.dandelion.core.storage.AssetStorageUnit;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Map;

public class Asset {
    private String name;
    private String version;
    private AssetType type;
    private AssetDomPosition dom;
    private String configLocationKey;
    private String configLocation;
    private String finalLocation;
    private Map<String, String> attributes;
    private String[] attributesOnlyName;
    private String cacheKey;

    public Asset() {
    }

    public Asset(String name, String version, AssetType type, Map<String, String> locations) {
        this.name = name;
        this.version = version;
        this.type = type;
    }

    public Asset(String name, String version, AssetType type, String location) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.finalLocation = location;
    }

    protected Asset(String name, String version, AssetType type, AssetDomPosition dom, String location) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.dom = dom;
        this.finalLocation = location;
    }

    public Asset(String name, String version, AssetType type) {
        this.name = name;
        this.version = version;
        this.type = type;
    }

    public Asset(AssetStorageUnit asu) {
        this.name = asu.getName();
        this.type = asu.getType();
        this.version = asu.getVersion();
        this.dom = asu.getDom();
        this.attributes = asu.getAttributes();
        this.attributesOnlyName = asu.getAttributesOnlyName();
    }

    public Asset(String name, String version, AssetType type, AssetDomPosition position) {
        this.name = name;
        this.version = version;
        this.type = type;
        this.dom = position;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getVersion() {
        return this.version;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public AssetType getType() {
        return this.type;
    }

    public void setType(AssetType type) {
        this.type = type;
    }

    public String getConfigLocation() {
        return this.configLocation;
    }

    public void setConfigLocation(String configLocation) {
        this.configLocation = configLocation;
    }

    public String getConfigLocationKey() {
        return this.configLocationKey;
    }

    public void setConfigLocationKey(String configLocationKey) {
        this.configLocationKey = configLocationKey;
    }

    public String getFinalLocation() {
        return this.finalLocation;
    }

    public void setFinalLocation(String finalLocation) {
        this.finalLocation = finalLocation;
    }

    public AssetDomPosition getDom() {
        return this.dom;
    }

    public void setDom(AssetDomPosition dom) {
        this.dom = dom;
    }

    public Map<String, String> getAttributes() {
        return this.attributes;
    }

    public void setAttributes(Map<String, String> attributes) {
        this.attributes = attributes;
    }

    public String[] getAttributesOnlyName() {
        if (this.attributesOnlyName == null) {
            return new String[0];
        }
        return this.attributesOnlyName;
    }

    public void setAttributesOnlyName(String[] attributesOnlyName) {
        this.attributesOnlyName = attributesOnlyName;
    }

    public boolean isValid() {
        return this.name != null && this.version != null && this.type != null && this.finalLocation != null;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        result = 31 * result + (this.type == null ? 0 : this.type.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Asset other = (Asset)obj;
        if (this.name == null ? other.name != null : !this.name.equals(other.name)) {
            return false;
        }
        return this.type == other.type;
    }

    public String getAssetKey() {
        return this.name + "." + (Object)((Object)this.type);
    }

    public Asset clone() {
        return new Asset(this.name, this.version, this.type, this.dom, this.finalLocation);
    }

    public void addAttribute(String attributeName, String attributeValue) {
        if (this.attributes == null) {
            this.attributes = new HashMap<String, String>();
        }
        this.attributes.put(attributeName, attributeValue);
    }

    public void addAttribute(String attributeName) {
        if (this.attributesOnlyName == null) {
            this.attributesOnlyName = new String[]{attributeName};
        } else {
            Arrays.copyOf(this.attributesOnlyName, this.attributesOnlyName.length + 1);
            this.attributesOnlyName[this.attributesOnlyName.length] = attributeName;
        }
    }

    public String getCacheKey() {
        return this.cacheKey;
    }

    public void setCacheKey(String cacheKey) {
        this.cacheKey = cacheKey;
    }

    public String toString() {
        return "Asset [name=" + this.name + ", version=" + this.version + ", type=" + (Object)((Object)this.type) + ", dom=" + (Object)((Object)this.dom) + ", configLocation=" + this.configLocation + ", configLocationKey=" + this.configLocationKey + ", finalLocation=" + this.finalLocation + ", attributes=" + this.attributes + ", attributesOnlyName=" + Arrays.toString(this.attributesOnlyName) + "]";
    }

    public String toLog() {
        return this.name + " (" + (Object)((Object)this.type) + ", v" + this.version + ")";
    }
}

