/*
 * Decompiled with CFR 0.152.
 */
package com.github.dandelion.core;

import com.github.dandelion.core.asset.cache.AssetCacheManager;
import com.github.dandelion.core.asset.cache.impl.MemoryAssetCache;
import com.github.dandelion.core.asset.cache.spi.AssetCache;
import com.github.dandelion.core.asset.locator.Servlet2Compatible;
import com.github.dandelion.core.asset.locator.Servlet3Compatible;
import com.github.dandelion.core.asset.locator.spi.AssetLocator;
import com.github.dandelion.core.asset.processor.AssetProcessorManager;
import com.github.dandelion.core.asset.processor.spi.AssetProcessor;
import com.github.dandelion.core.bundle.loader.impl.DandelionBundleLoader;
import com.github.dandelion.core.bundle.loader.impl.VendorBundleLoader;
import com.github.dandelion.core.bundle.loader.spi.BundleLoader;
import com.github.dandelion.core.config.Configuration;
import com.github.dandelion.core.config.ConfigurationLoader;
import com.github.dandelion.core.config.StandardConfigurationLoader;
import com.github.dandelion.core.jmx.DandelionRuntime;
import com.github.dandelion.core.storage.BundleStorage;
import com.github.dandelion.core.utils.ClassUtils;
import com.github.dandelion.core.utils.StringUtils;
import java.lang.management.ManagementFactory;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.management.JMException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.servlet.FilterConfig;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Context {
    private static Logger LOG = LoggerFactory.getLogger(Context.class);
    private AssetCache assetCache;
    private Map<String, AssetProcessor> processorsMap;
    private List<AssetProcessor> activeProcessors;
    private List<BundleLoader> bundleLoaders;
    private AssetProcessorManager assetProcessorManager;
    private AssetCacheManager assetCacheManager;
    private Map<String, AssetLocator> assetLocatorsMap;
    private BundleStorage bundleStorage;
    private Configuration configuration;

    public Context(FilterConfig filterConfig) {
        this.init(filterConfig);
    }

    public void init(FilterConfig filterConfig) {
        this.initConfiguration(filterConfig);
        this.initBundleLoaders();
        this.initAssetLocators();
        this.initAssetCache();
        this.initAssetProcessors();
        this.assetProcessorManager = new AssetProcessorManager(this);
        this.assetCacheManager = new AssetCacheManager(this);
        this.initBundleStorage();
        this.initMBean(filterConfig);
    }

    public void initConfiguration(FilterConfig filterConfig) {
        ConfigurationLoader configurationLoader = null;
        LOG.debug("Initializing the configuration loader...");
        if (StringUtils.isNotBlank(System.getProperty("dandelion.confloader.class"))) {
            try {
                Class<?> clazz = ClassUtils.getClass(System.getProperty("dandelion.confloader.class"));
                configurationLoader = (ConfigurationLoader)ClassUtils.getNewInstance(clazz);
            }
            catch (Exception e) {
                LOG.warn("Unable to instantiate the configured {} due to a {} exception. Falling back to the default one.", new Object[]{"dandelion.confloader.class", e.getClass().getName(), e});
            }
        }
        if (configurationLoader == null) {
            configurationLoader = new StandardConfigurationLoader();
        }
        Properties userProperties = new Properties();
        userProperties.putAll((Map<?, ?>)configurationLoader.loadUserConfiguration());
        this.configuration = new Configuration(filterConfig, userProperties);
    }

    public void initBundleLoaders() {
        ServiceLoader<BundleLoader> blServiceLoader = ServiceLoader.load(BundleLoader.class);
        VendorBundleLoader vendorLoader = new VendorBundleLoader();
        vendorLoader.initLoader(this);
        DandelionBundleLoader dandelionLoader = new DandelionBundleLoader();
        dandelionLoader.initLoader(this);
        this.bundleLoaders = new ArrayList<BundleLoader>();
        this.bundleLoaders.add(vendorLoader);
        for (BundleLoader bl : blServiceLoader) {
            bl.initLoader(this);
            this.bundleLoaders.add(bl);
            LOG.info("Active bundle loader found: {}", (Object)bl.getClass().getSimpleName());
        }
        this.bundleLoaders.add(dandelionLoader);
    }

    public void initAssetCache() {
        ServiceLoader<AssetCache> assetCacheServiceLoader = ServiceLoader.load(AssetCache.class);
        HashMap<String, AssetCache> caches = new HashMap<String, AssetCache>();
        for (AssetCache ac : assetCacheServiceLoader) {
            caches.put(ac.getCacheName().toLowerCase().trim(), ac);
            LOG.info("Asset caching system found: {}", (Object)ac.getClass().getSimpleName());
        }
        String desiredCacheName = this.configuration.getCacheName();
        if (StringUtils.isNotBlank(desiredCacheName)) {
            if (caches.containsKey(desiredCacheName)) {
                this.assetCache = (AssetCache)caches.get(desiredCacheName);
            } else {
                LOG.warn("The desired caching system ({}) hasn't been found in the classpath. Did you forget to add a dependency? The default one will be used.", (Object)desiredCacheName);
            }
        }
        if (this.assetCache == null) {
            this.assetCache = new MemoryAssetCache();
        }
        this.assetCache.initCache(this);
        LOG.info("Selected asset cache system: {} (based on {})", (Object)this.assetCache.getCacheName(), (Object)this.assetCache.getClass().getSimpleName());
    }

    public void initAssetLocators() {
        ServiceLoader<AssetLocator> alServiceLoader = ServiceLoader.load(AssetLocator.class);
        this.assetLocatorsMap = new HashMap<String, AssetLocator>();
        for (AssetLocator al : alServiceLoader) {
            if (this.getConfiguration().isServlet3Enabled()) {
                if (!Servlet3Compatible.class.isAssignableFrom(al.getClass())) continue;
                al.initLocator(this);
                this.assetLocatorsMap.put(al.getLocationKey(), al);
                LOG.info("Asset locator found: {} ({})", (Object)al.getLocationKey(), (Object)al.getClass().getSimpleName());
                continue;
            }
            if (!Servlet2Compatible.class.isAssignableFrom(al.getClass())) continue;
            al.initLocator(this);
            this.assetLocatorsMap.put(al.getLocationKey(), al);
            LOG.info("Asset locator found: {} ({})", (Object)al.getLocationKey(), (Object)al.getClass().getSimpleName());
        }
    }

    public void initAssetProcessors() {
        ServiceLoader<AssetProcessor> apServiceLoader = ServiceLoader.load(AssetProcessor.class);
        this.processorsMap = new HashMap<String, AssetProcessor>();
        this.activeProcessors = new ArrayList<AssetProcessor>();
        for (AssetProcessor ape : apServiceLoader) {
            this.processorsMap.put(ape.getProcessorKey().toLowerCase(), ape);
            LOG.info("Asset processor found: {}", (Object)ape.getClass().getSimpleName());
        }
        if (this.configuration.isMinificationEnabled()) {
            LOG.info("Asset processors enabled.");
            for (String assetProcessorKey : this.configuration.getAssetProcessors()) {
                if (!this.processorsMap.containsKey(assetProcessorKey)) continue;
                this.activeProcessors.add(this.processorsMap.get(assetProcessorKey));
                LOG.info("Processor enabled: {}", (Object)this.processorsMap.get(assetProcessorKey).getProcessorKey());
            }
        } else {
            LOG.info("Asset processors disabled. All assets will be left untouched.");
        }
    }

    public void initBundleStorage() {
        this.bundleStorage = new BundleStorage();
        for (BundleLoader bundleLoader : this.getBundleLoaders()) {
            this.bundleStorage.storeBundles(bundleLoader.loadBundles());
        }
        this.bundleStorage.checkBundleDag();
    }

    public void initMBean(FilterConfig filterConfig) {
        if (this.configuration.isJmxEnabled()) {
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("com.github.dandelion", "type", DandelionRuntime.class.getSimpleName());
                if (!mbeanServer.isRegistered(name)) {
                    mbeanServer.registerMBean(new DandelionRuntime(this, filterConfig), name);
                }
            }
            catch (JMException e) {
                LOG.error("An exception occured while registering the DandelionRuntimeMBean", (Throwable)e);
            }
        }
    }

    public void destroy() {
        if (this.configuration.isJmxEnabled()) {
            try {
                MBeanServer mbeanServer = ManagementFactory.getPlatformMBeanServer();
                ObjectName name = new ObjectName("com.github.dandelion", "type", DandelionRuntime.class.getSimpleName());
                if (mbeanServer.isRegistered(name)) {
                    mbeanServer.unregisterMBean(name);
                }
            }
            catch (JMException e) {
                LOG.error("An exception occured while unregistering the DandelionRuntimeMBean", (Throwable)e);
            }
        }
    }

    public AssetCache getAssetCache() {
        return this.assetCache;
    }

    public Map<String, AssetProcessor> getProcessorsMap() {
        return this.processorsMap;
    }

    public List<BundleLoader> getBundleLoaders() {
        return this.bundleLoaders;
    }

    public Map<String, AssetLocator> getAssetLocatorsMap() {
        return this.assetLocatorsMap;
    }

    public List<AssetProcessor> getActiveProcessors() {
        return this.activeProcessors;
    }

    public BundleStorage getBundleStorage() {
        return this.bundleStorage;
    }

    public AssetProcessorManager getProcessorManager() {
        return this.assetProcessorManager;
    }

    public AssetCacheManager getCacheManager() {
        return this.assetCacheManager;
    }

    public Configuration getConfiguration() {
        return this.configuration;
    }

    public boolean isDevModeEnabled() {
        return "development".equalsIgnoreCase(this.configuration.getDandelionMode().toString());
    }
}

