/*
 * Decompiled with CFR 0.152.
 */
package com.dant.centersnapreyclerview;

import android.content.Context;
import android.content.res.TypedArray;
import android.support.annotation.Nullable;
import android.support.v7.widget.LinearLayoutManager;
import android.support.v7.widget.RecyclerView;
import android.util.AttributeSet;
import android.view.View;
import com.dant.centersnapreyclerview.CenterLayoutManager;
import com.dant.centersnapreyclerview.R;
import java.lang.annotation.Retention;
import java.lang.annotation.RetentionPolicy;
import java.lang.ref.WeakReference;

public class SnappingRecyclerView
extends RecyclerView {
    public static final int VERTICAL = 0;
    public static final int HORIZONTAL = 1;
    public static final int CENTER = 0;
    public static final int START = 1;
    public static final int END = 2;
    private static final int DEFAULT_FLING_THRESHOLD = 1000;
    private WeakReference<SnappingRecyclerViewListener> listener;
    private int orientation;
    private int anchor;
    private float scrollSpeed;
    private int flingThreshold;
    private CenterLayoutManager layoutManager;

    public SnappingRecyclerView(Context context) {
        super(context);
        this.initialise(context, null);
    }

    public SnappingRecyclerView(Context context, @Nullable AttributeSet attrs) {
        super(context, attrs);
        this.initialise(context, attrs);
    }

    public SnappingRecyclerView(Context context, @Nullable AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.initialise(context, attrs);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initialise(Context context, @Nullable AttributeSet attrs) {
        TypedArray a = context.getTheme().obtainStyledAttributes(attrs, R.styleable.SnappingRecyclerView, 0, 0);
        try {
            this.orientation = a.getInt(R.styleable.SnappingRecyclerView_orientation, 0);
            this.anchor = a.getInt(R.styleable.SnappingRecyclerView_anchor, 0);
            this.scrollSpeed = a.getFloat(R.styleable.SnappingRecyclerView_scrollSpeed, -1.0f);
            this.flingThreshold = a.getInt(R.styleable.SnappingRecyclerView_flingThreshold, 1000);
        }
        finally {
            a.recycle();
        }
        this.layoutManager = new CenterLayoutManager(this.getContext());
        this.layoutManager.setOrientation(this.orientation == 0 ? 1 : 0);
        this.layoutManager.setAnchor(this.anchor);
        this.layoutManager.setScrollSpeed(this.scrollSpeed);
        this.setLayoutManager((RecyclerView.LayoutManager)this.layoutManager);
    }

    public SnappingRecyclerViewListener getListener() {
        return this.listener != null ? (SnappingRecyclerViewListener)this.listener.get() : null;
    }

    public void setListener(SnappingRecyclerViewListener listener) {
        this.listener = new WeakReference<SnappingRecyclerViewListener>(listener);
    }

    public void setOrientation(int orientation) {
        if (this.orientation != orientation) {
            this.orientation = orientation;
            this.layoutManager.setOrientation(orientation == 0 ? 1 : 0);
            this.requestLayout();
        }
    }

    public int getOrientation() {
        return this.orientation;
    }

    public void setAnchor(int anchor) {
        if (this.anchor != anchor) {
            this.anchor = anchor;
            this.layoutManager.setAnchor(anchor);
            this.requestLayout();
        }
    }

    public int getAnchor() {
        return this.anchor;
    }

    public void onScrolled(int dx, int dy) {
        super.onScrolled(dx, dy);
        if (this.getListener() != null) {
            this.getListener().onScroll(dx, dy);
        }
    }

    public void scrollToPosition(final int position) {
        super.scrollToPosition(position);
        this.post(new Runnable(){

            @Override
            public void run() {
                SnappingRecyclerView.this.smoothScrollToPosition(position);
            }
        });
    }

    public boolean fling(int velocityX, int velocityY) {
        if (Math.abs(this.orientation == 0 ? velocityY : velocityX) < this.flingThreshold) {
            int centerViewPosition = this.calculateSnapViewPosition();
            this.smoothScrollToPosition(centerViewPosition);
            if (this.getListener() != null) {
                this.getListener().onPositionChange(centerViewPosition);
            }
            return true;
        }
        return super.fling(velocityX, velocityY);
    }

    public void onScrollStateChanged(int state) {
        super.onScrollStateChanged(state);
        if (state == 0) {
            int centerViewPosition = this.calculateSnapViewPosition();
            this.smoothScrollToPosition(centerViewPosition);
            if (this.getListener() != null) {
                this.getListener().onPositionChange(centerViewPosition);
            }
        }
    }

    private int getParentAnchor(int orientation, int anchor) {
        switch (anchor) {
            case 1: {
                return 0;
            }
            case 2: {
                return orientation == 0 ? this.getHeight() : this.getWidth();
            }
        }
        return (orientation == 0 ? this.getHeight() : this.getWidth()) / 2;
    }

    private int getViewAnchor(View view, int orientation, int anchor) {
        switch (anchor) {
            case 1: {
                return orientation == 0 ? view.getTop() : view.getLeft();
            }
            case 2: {
                return orientation == 0 ? view.getBottom() : view.getRight();
            }
        }
        return orientation == 0 ? view.getTop() + view.getHeight() / 2 : view.getLeft() + view.getWidth() / 2;
    }

    private int calculateSnapDistance() {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)this.getLayoutManager();
        int parentAnchor = this.getParentAnchor(this.orientation, this.anchor);
        int lastVisibleItemPosition = linearLayoutManager.findLastVisibleItemPosition();
        int firstVisibleItemPosition = linearLayoutManager.findFirstVisibleItemPosition();
        View currentViewClosestToAnchor = linearLayoutManager.findViewByPosition(firstVisibleItemPosition);
        int currentViewClosestToAnchorDistance = parentAnchor - this.getViewAnchor(currentViewClosestToAnchor, this.orientation, this.anchor);
        for (int i = firstVisibleItemPosition + 1; i <= lastVisibleItemPosition; ++i) {
            View view = linearLayoutManager.findViewByPosition(i);
            int distanceToAnchor = parentAnchor - this.getViewAnchor(view, this.orientation, this.anchor);
            if (Math.abs(distanceToAnchor) >= Math.abs(currentViewClosestToAnchorDistance)) continue;
            currentViewClosestToAnchorDistance = distanceToAnchor;
        }
        return currentViewClosestToAnchorDistance;
    }

    private int calculateSnapViewPosition() {
        LinearLayoutManager linearLayoutManager = (LinearLayoutManager)this.getLayoutManager();
        int parentAnchor = this.getParentAnchor(this.orientation, this.anchor);
        int lastVisibleItemPosition = linearLayoutManager.findLastVisibleItemPosition();
        int firstVisibleItemPosition = linearLayoutManager.findFirstVisibleItemPosition();
        View currentViewClosestToAnchor = linearLayoutManager.findViewByPosition(firstVisibleItemPosition);
        int currentViewClosestToAnchorDistance = parentAnchor - this.getViewAnchor(currentViewClosestToAnchor, this.orientation, this.anchor);
        int currentViewClosestToAnchorPosition = firstVisibleItemPosition;
        for (int i = firstVisibleItemPosition + 1; i <= lastVisibleItemPosition; ++i) {
            View view = linearLayoutManager.findViewByPosition(i);
            int distanceToCenter = parentAnchor - this.getViewAnchor(view, this.orientation, this.anchor);
            if (Math.abs(distanceToCenter) >= Math.abs(currentViewClosestToAnchorDistance)) continue;
            currentViewClosestToAnchorPosition = i;
            currentViewClosestToAnchorDistance = distanceToCenter;
        }
        return currentViewClosestToAnchorPosition;
    }

    public static interface SnappingRecyclerViewListener {
        public void onPositionChange(int var1);

        public void onScroll(int var1, int var2);
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface AnchorMode {
    }

    @Retention(value=RetentionPolicy.SOURCE)
    public static @interface OrientationMode {
    }
}

