/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.generators.ipo2;

import com.github.dakusui.jcunit.constraint.ConstraintManager;
import com.github.dakusui.jcunit.constraint.ConstraintObserver;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.SystemProperties;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.core.tuples.TupleImpl;
import com.github.dakusui.jcunit.core.tuples.TupleUtils;
import com.github.dakusui.jcunit.core.tuples.Tuples;
import com.github.dakusui.jcunit.exceptions.GiveUp;
import com.github.dakusui.jcunit.exceptions.UndefinedSymbol;
import com.github.dakusui.jcunit.generators.ipo2.optimizers.IPO2Optimizer;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class IPO2
implements ConstraintObserver {
    public static final Object DontCare = new Object(){

        public String toString() {
            return "D/C";
        }
    };
    private final ConstraintManager constraintManager;
    private final Factors factors;
    private final int strength;
    private final IPO2Optimizer optimizer;
    private List<Tuple> result;
    private List<Tuple> remainders;
    private Set<Tuple> learnedConstraint = new LinkedHashSet<Tuple>();

    public IPO2(Factors factors, int strength, ConstraintManager constraintManager, IPO2Optimizer optimizer) {
        Checks.checknotnull(factors);
        Checks.checkcond(factors.size() >= 2, "There must be 2 or more factors.", new Object[0]);
        Checks.checkcond(factors.size() >= strength, "The strength must be greater than 1 and less than %d.", factors.size());
        Checks.checkcond(strength >= 2, "The strength must be greater than 1 and less than %d.", factors.size());
        Checks.checknotnull(constraintManager);
        Checks.checknotnull(optimizer);
        this.factors = factors;
        this.strength = strength;
        this.result = null;
        this.remainders = null;
        this.constraintManager = constraintManager;
        this.optimizer = optimizer;
    }

    private static List<Tuple> lookup(List<Tuple> tuples, Tuple q) {
        LinkedList<Tuple> ret = new LinkedList<Tuple>();
        for (Tuple cur : tuples) {
            if (!IPO2.matches(cur, q)) continue;
            ret.add(cur.cloneTuple());
        }
        return ret;
    }

    private static boolean matches(Tuple tuple, Tuple q) {
        for (String k : q.keySet()) {
            if (tuple.containsKey(k) && Utils.eq(q.get(k), tuple.get(k))) continue;
            return false;
        }
        return true;
    }

    private List<Tuple> filterInvalidTuples(List<Tuple> tuples) {
        ArrayList<Tuple> ret = new ArrayList<Tuple>(tuples.size());
        for (Tuple cur : tuples) {
            if (!this.checkConstraints(cur)) continue;
            ret.add(cur);
        }
        return ret;
    }

    public void ipo() {
        if (this.strength < this.factors.size()) {
            this.remainders = new LinkedList<Tuple>();
            this.result = this.initialTestCases(this.factors.head(this.factors.get((int)this.strength).name));
        } else if (this.factors.size() == this.strength) {
            this.remainders = new LinkedList<Tuple>();
            this.result = this.initialTestCases(this.factors);
            return;
        }
        Set<Tuple> leftOver = new LinkedHashSet<Tuple>();
        for (String factorName : this.factors.tail(this.factors.get((int)this.strength).name).getFactorNames()) {
            Tuples leftTuples = new Tuples(this.factors.head(factorName), this.factors.get(factorName), this.strength);
            leftTuples.addAll(leftOver);
            leftTuples.removeAll(this.findTuplesViolatingLearnedConstraints(leftTuples.leftTuples()));
            if (SystemProperties.isDebugEnabled()) {
                System.out.println("HG:result  =" + TupleUtils.toString(this.result));
                System.out.println("HG:leftover=" + TupleUtils.toString(leftOver));
            }
            leftOver = this.hg(this.result, leftTuples, this.factors.get(factorName));
            if (leftTuples.isEmpty()) continue;
            leftOver = this.factors.isLastKey(factorName) ? this.vg(this.result, leftTuples, this.factors) : this.vg(this.result, leftTuples, this.factors.head(this.factors.nextKey(factorName)));
            if (!SystemProperties.isDebugEnabled()) continue;
            System.out.println("VG:result  =" + TupleUtils.toString(this.result));
            System.out.println("VG:leftover=" + TupleUtils.toString(leftOver));
        }
        LinkedHashSet<Tuple> tmp = new LinkedHashSet<Tuple>(this.result);
        this.result.clear();
        this.result.addAll(tmp);
        this.remainders.addAll(leftOver);
    }

    public List<Tuple> getResult() {
        Checks.checkcond(this.result != null, "Execute ipo() method first", new Object[0]);
        return Collections.unmodifiableList(this.result);
    }

    public List<Tuple> getRemainders() {
        Checks.checkcond(this.result != null, "Execute ipo() method first", new Object[0]);
        return Collections.unmodifiableList(this.remainders);
    }

    private List<Tuple> initialTestCases(Factors factors) {
        TupleUtils.CartesianTuples initialTestCases = TupleUtils.enumerateCartesianProduct(new TupleImpl(), factors.asFactorList().toArray(new Factor[factors.asFactorList().size()]));
        ArrayList<Tuple> ret = new ArrayList<Tuple>((int)initialTestCases.size());
        Iterator i$ = initialTestCases.iterator();
        while (i$.hasNext()) {
            Tuple tuple = (Tuple)i$.next();
            ret.add(tuple);
        }
        return ret;
    }

    private Set<Tuple> hg(List<Tuple> result, Tuples leftTuples, Factor factor) {
        LinkedHashSet<Tuple> leftOver = new LinkedHashSet<Tuple>();
        LinkedList<Tuple> invalidTests = new LinkedList<Tuple>();
        String factorName = factor.name;
        for (int i = 0; i < result.size(); ++i) {
            Tuple cur = result.get(i);
            LinkedList<Object> possibleLevels = new LinkedList<Object>(factor.levels);
            boolean validLevelFound = false;
            while (!possibleLevels.isEmpty()) {
                Object chosenLevel = this.chooseBestValue(factorName, possibleLevels, cur, leftTuples);
                cur.put(factorName, chosenLevel);
                if (this.checkConstraints(cur)) {
                    leftTuples.removeAll(TupleUtils.subtuplesOf(cur, this.strength));
                    validLevelFound = true;
                    break;
                }
                cur.remove(factorName);
                possibleLevels.remove(chosenLevel);
            }
            if (validLevelFound) continue;
            Tuple tupleGivenUp = cur.cloneTuple();
            cur.clear();
            this.handleGivenUpTuple(tupleGivenUp, result, leftOver);
            invalidTests.add(cur);
        }
        for (Tuple cur : invalidTests) {
            result.remove(cur);
        }
        return leftOver;
    }

    private Set<Tuple> vg(List<Tuple> result, Tuples leftTuples, Factors factors) {
        LinkedHashSet<Tuple> ret = new LinkedHashSet<Tuple>();
        List<Tuple> work = leftTuples.leftTuples();
        for (Tuple cur : work) {
            if (leftTuples.isEmpty()) break;
            if (!leftTuples.contains(cur)) continue;
            Tuple t = factors.createTupleFrom(cur, DontCare);
            if (!this.checkConstraints(t)) {
                ret.add(cur);
                continue;
            }
            Tuple best = t;
            int numCovered = leftTuples.coveredBy(t).size();
            for (String factorName : cur.keySet()) {
                Tuple q = cur.cloneTuple();
                q.put(factorName, DontCare);
                List<Tuple> found = this.filterInvalidTuples(IPO2.lookup(result, q));
                if (found.size() <= 0) continue;
                Object levelToBeAssigned = cur.get(factorName);
                Tuple f = this.chooseBestTuple(found, leftTuples, factorName, levelToBeAssigned);
                f.put(factorName, levelToBeAssigned);
                int num = leftTuples.coveredBy(f).size();
                if (num <= numCovered) continue;
                numCovered = num;
                best = f;
            }
            Set<Tuple> subtuplesOfBest = TupleUtils.subtuplesOf(best, this.strength);
            leftTuples.removeAll(subtuplesOfBest);
            ret.removeAll(subtuplesOfBest);
            result.add(best);
        }
        LinkedHashSet<Tuple> remove = new LinkedHashSet<Tuple>();
        for (Tuple testCase : result) {
            try {
                this.fillInMissingFactors(testCase, leftTuples);
                Set<Tuple> subtuples = TupleUtils.subtuplesOf(testCase, this.strength);
                leftTuples.removeAll(subtuples);
                ret.removeAll(subtuples);
            }
            catch (GiveUp e) {
                Tuple tupleGivenUp = this.removeDontCareEntries(e.getTuple().cloneTuple());
                testCase.clear();
                this.handleGivenUpTuple(tupleGivenUp, result, ret);
                remove.add(testCase);
            }
        }
        result.removeAll(remove);
        return ret;
    }

    private void handleGivenUpTuple(Tuple tupleGivenUp, List<Tuple> result, Set<Tuple> leftOver) {
        for (Tuple invalidatedSubTuple : TupleUtils.subtuplesOf(tupleGivenUp, this.strength)) {
            if (IPO2.lookup(result, invalidatedSubTuple).size() != 0 || !this.checkConstraints(invalidatedSubTuple)) continue;
            leftOver.add(invalidatedSubTuple);
        }
    }

    protected void fillInMissingFactors(Tuple tuple, Tuples leftTuples) {
        Checks.checknotnull(tuple);
        Checks.checknotnull(leftTuples);
        Checks.checknotnull(this.constraintManager);
        if (!this.checkConstraints(tuple)) {
            throw new GiveUp(this.removeDontCareEntries(tuple));
        }
        Tuple work = this.optimizer.fillInMissingFactors(tuple.cloneTuple(), leftTuples, this.constraintManager, this.factors);
        Checks.checknotnull(work);
        Checks.checkcond(((Object)work.keySet()).equals(tuple.keySet()), "Key set was modified from %s to %s", tuple.keySet(), work.keySet());
        Checks.checkcond(!work.containsValue(DontCare));
        if (!this.checkConstraints(work)) {
            throw new GiveUp(this.removeDontCareEntries(work));
        }
        tuple.putAll(work);
    }

    private boolean checkConstraints(Tuple cur) {
        Checks.checknotnull(cur);
        try {
            return this.constraintManager.check(this.removeDontCareEntries(cur));
        }
        catch (UndefinedSymbol e) {
            return true;
        }
    }

    protected Tuple chooseBestTuple(List<Tuple> found, Tuples leftTuples, String factorName, Object level) {
        Checks.checknotnull(found);
        Checks.checkcond(found.size() > 0);
        Checks.checknotnull(leftTuples);
        Checks.checknotnull(factorName);
        Tuple ret = this.optimizer.chooseBestTuple(found, leftTuples.unmodifiableVersion(), factorName, level);
        Checks.checknotnull(ret);
        Checks.checkcond(found.contains(ret), "User code must return a value from found tuples.", new Object[0]);
        return ret;
    }

    protected Object chooseBestValue(String factorName, List<Object> factorLevels, Tuple tuple, Tuples leftTuples) {
        Checks.checknotnull(factorName);
        Checks.checknotnull(factorLevels);
        Checks.checkcond(factorLevels.size() > 0);
        Checks.checknotnull(tuple);
        Checks.checknotnull(leftTuples);
        Object ret = this.optimizer.chooseBestValue(factorName, factorLevels.toArray(), tuple, leftTuples.unmodifiableVersion());
        Checks.checkcond(factorLevels.contains(ret));
        return ret;
    }

    private Tuple removeDontCareEntries(Tuple cur) {
        Tuple tuple = cur.cloneTuple();
        for (String factorName : cur.keySet()) {
            if (tuple.get(factorName) != DontCare) continue;
            tuple.remove(factorName);
        }
        return tuple;
    }

    @Override
    public void implicitConstraintFound(Tuple constraint) {
        this.registerImplicitConstraintToLearnedConstraintSet(constraint);
    }

    private void registerImplicitConstraintToLearnedConstraintSet(Tuple implicitConstraint) {
        LinkedHashSet<Tuple> removal = new LinkedHashSet<Tuple>();
        for (Tuple t : this.learnedConstraint) {
            if (!implicitConstraint.isSubtupleOf(t)) continue;
            removal.add(t);
        }
        this.learnedConstraint.removeAll(removal);
        this.learnedConstraint.add(implicitConstraint);
    }

    private boolean checkTupleWithLearnedConstraints(Tuple tuple) {
        for (Tuple t : TupleUtils.subtuplesOf(tuple)) {
            if (!this.learnedConstraint.contains(t)) continue;
            return false;
        }
        return true;
    }

    public Set<Tuple> findTuplesViolatingLearnedConstraints(Collection<Tuple> tuples) {
        Checks.checknotnull(tuples);
        LinkedHashSet<Tuple> ret = new LinkedHashSet<Tuple>();
        for (Tuple t : tuples) {
            if (this.checkTupleWithLearnedConstraints(t)) continue;
            ret.add(t);
        }
        return ret;
    }
}

