/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.generators;

import com.github.dakusui.jcunit.constraint.ConstraintManager;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.JCUnitConfigurablePlugin;
import com.github.dakusui.jcunit.core.Param;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.generators.IPO2TupleGenerator;

public interface TupleGenerator
extends JCUnitConfigurablePlugin,
Iterable<Tuple> {
    public Factors getFactors();

    public void setFactors(Factors var1);

    public ConstraintManager getConstraintManager();

    public void setConstraintManager(ConstraintManager var1);

    public Class<?> getTargetClass();

    public void setTargetClass(Class<?> var1);

    public Tuple get(long var1);

    public long nextId(long var1);

    public long firstId();

    public long size();

    public static class Builder {
        private Class<? extends TupleGenerator> tupleGeneratorClass;
        private Factors factors;
        private ConstraintManager constraintManager;
        private Param[] parameters;
        private Class<?> targetClass;

        public Builder() {
            this(IPO2TupleGenerator.class, ConstraintManager.DEFAULT_CONSTRAINT_MANAGER);
        }

        public Builder(Class<? extends TupleGenerator> tupleGeneratorClass, ConstraintManager cm) {
            this.tupleGeneratorClass = Checks.checknotnull(tupleGeneratorClass);
            this.constraintManager = Checks.checknotnull(cm);
            this.parameters = Param.EMPTY_ARRAY;
        }

        public Builder(Builder base) {
            this.tupleGeneratorClass = base.tupleGeneratorClass;
            this.factors = base.factors;
            this.constraintManager = base.getConstraintManager();
            this.parameters = base.parameters;
        }

        public Builder setTupleGeneratorClass(Class<? extends TupleGenerator> tupleGeneratorClass) {
            this.tupleGeneratorClass = tupleGeneratorClass;
            return this;
        }

        public Builder setFactors(Factors factors) {
            this.factors = factors;
            return this;
        }

        public Builder setConstraintManager(ConstraintManager constraintManager) {
            this.constraintManager = constraintManager;
            return this;
        }

        public Builder setParameters(Param[] parameters) {
            this.parameters = parameters;
            return this;
        }

        public Builder setTargetClass(Class<?> targetClass) {
            this.targetClass = targetClass;
            return this;
        }

        public TupleGenerator build() {
            Checks.checknotnull(this.constraintManager);
            Checks.checknotnull(this.tupleGeneratorClass);
            Checks.checknotnull(this.factors);
            Checks.checknotnull(this.constraintManager);
            TupleGenerator ret = Utils.createNewInstanceUsingNoParameterConstructor(this.tupleGeneratorClass);
            ret.setFactors(this.factors);
            ret.setConstraintManager(this.constraintManager);
            ret.setTargetClass(this.targetClass);
            ret.init(this.parameters);
            return ret;
        }

        public ConstraintManager getConstraintManager() {
            return this.constraintManager;
        }

        public Factors getFactors() {
            return this.factors;
        }
    }
}

