/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.fsm.Action;
import com.github.dakusui.jcunit.fsm.Args;
import com.github.dakusui.jcunit.fsm.Expectation;
import com.github.dakusui.jcunit.fsm.FSMFactors;
import com.github.dakusui.jcunit.fsm.FSMUtils;
import com.github.dakusui.jcunit.fsm.Scenario;
import com.github.dakusui.jcunit.fsm.State;
import java.io.PrintStream;
import java.io.Serializable;

public interface ScenarioSequence<SUT>
extends Serializable {
    public static final ScenarioSequence<?> EMPTY = new EmptyScenarioSequence();

    public <T> void perform(T var1, Type var2, SUT var3, FSMUtils.Synchronizer var4, FSMUtils.Synchronizable var5, Observer var6);

    public int size();

    public Scenario<SUT> get(int var1);

    public State<SUT> state(int var1);

    public Action<SUT> action(int var1);

    public Object arg(int var1, int var2);

    public boolean hasArg(int var1, int var2);

    public Args args(int var1);

    public static interface Observer {
        public static final Observer SILENT = new Observer(){

            @Override
            public Observer createChild(String childName) {
                return this;
            }

            public void startSequence(Type type, ScenarioSequence seq) {
            }

            public void run(Type type, Scenario scenario, Object o) {
            }

            public void passed(Type type, Scenario scenario, Object o) {
            }

            public void failed(Type type, Scenario scenario, Object o, Expectation.Result result) {
            }

            public void endSequence(Type type, ScenarioSequence seq) {
            }
        };

        public <SUT> void startSequence(Type var1, ScenarioSequence<SUT> var2);

        public <SUT> void run(Type var1, Scenario<SUT> var2, SUT var3);

        public <SUT> void passed(Type var1, Scenario<SUT> var2, SUT var3);

        public <SUT> void failed(Type var1, Scenario<SUT> var2, SUT var3, Expectation.Result var4);

        public <SUT> void endSequence(Type var1, ScenarioSequence<SUT> var2);

        public Observer createChild(String var1);

        public static interface Factory {
            public Observer createObserver(String var1);

            public static class ForSimple
            implements Factory {
                public static final Factory INSTANCE = new ForSimple();

                @Override
                public Observer createObserver(String fsmName) {
                    return Utils.createSimpleObserver(fsmName);
                }
            }

            public static class ForSilent
            implements Factory {
                public static final Factory INSTANCE = new ForSilent();

                @Override
                public Observer createObserver(String fsmName) {
                    return SILENT;
                }
            }
        }
    }

    public static class BuilderFromTuple<SUT> {
        private FSMFactors factors;
        private Tuple tuple;
        private String fsmName;

        public BuilderFromTuple<SUT> setFSMFactors(FSMFactors factors) {
            this.factors = factors;
            return this;
        }

        public BuilderFromTuple<SUT> setTuple(Tuple tuple) {
            this.tuple = tuple;
            return this;
        }

        public BuilderFromTuple<SUT> setFSMName(String fsmName) {
            this.fsmName = fsmName;
            return this;
        }

        public ScenarioSequence<SUT> build() {
            Checks.checknotnull(this.tuple);
            Checks.checknotnull(this.factors);
            Checks.checknotnull(this.fsmName);
            Checks.checkcond(this.factors.historyLength(this.fsmName) > 0);
            return new Base<SUT>(){

                @Override
                public Scenario<SUT> get(int i) {
                    Checks.checkcond(i >= 0);
                    Checks.checkcond(i < this.size());
                    State given = this.state(i);
                    Action when = this.action(i);
                    Args with = this.args(i);
                    return new Scenario(given, when, with);
                }

                @Override
                public State<SUT> state(int i) {
                    Checks.checkcond(i >= 0);
                    Checks.checkcond(i < this.size());
                    return (State)BuilderFromTuple.this.tuple.get(BuilderFromTuple.this.factors.stateFactorName(BuilderFromTuple.this.fsmName, i));
                }

                @Override
                public Action<SUT> action(int i) {
                    Checks.checkcond(i >= 0);
                    Checks.checkcond(i < this.size());
                    return (Action)BuilderFromTuple.this.tuple.get(BuilderFromTuple.this.factors.actionFactorName(BuilderFromTuple.this.fsmName, i));
                }

                @Override
                public Object arg(int i, int j) {
                    Checks.checkcond(i >= 0);
                    Checks.checkcond(i < this.size());
                    Checks.checkcond(j >= 0);
                    Checks.checkcond(j < this.action(i).numParameterFactors());
                    return BuilderFromTuple.this.tuple.get(BuilderFromTuple.this.factors.paramFactorName(BuilderFromTuple.this.fsmName, i, j));
                }

                @Override
                public boolean hasArg(int i, int j) {
                    Checks.checkcond(i >= 0);
                    Checks.checkcond(i < this.size());
                    Checks.checkcond(j >= 0);
                    Checks.checkcond(j < this.action(i).numParameterFactors());
                    return BuilderFromTuple.this.tuple.containsKey(BuilderFromTuple.this.factors.paramFactorName(BuilderFromTuple.this.fsmName, i, j));
                }

                @Override
                public Args args(int i) {
                    Checks.checkcond(i >= 0);
                    Checks.checkcond(i < this.size());
                    Object[] values = new Object[this.action(i).numParameterFactors()];
                    for (int j = 0; j < values.length; ++j) {
                        values[j] = BuilderFromTuple.this.tuple.get(BuilderFromTuple.this.factors.paramFactorName(BuilderFromTuple.this.fsmName, i, j));
                    }
                    return new Args(values);
                }

                @Override
                public int size() {
                    return BuilderFromTuple.this.factors.historyLength(BuilderFromTuple.this.fsmName);
                }
            };
        }
    }

    public static class Utils {
        public static <SUT> String toString(ScenarioSequence<SUT> scenarioSequence) {
            Checks.checknotnull(scenarioSequence);
            Object[] scenarios = new Object[scenarioSequence.size()];
            for (int i = 0; i < scenarios.length; ++i) {
                scenarios[i] = scenarioSequence.get(i);
            }
            return String.format("[%d]ScenarioSequence:[%s]", Thread.currentThread().getId(), com.github.dakusui.jcunit.core.Utils.join(",", scenarios));
        }

        static Observer createSimpleObserver(String fsmName) {
            return Utils.createSimpleObserver(fsmName, System.out);
        }

        static Observer createSimpleObserver(String fsmName, PrintStream ps) {
            Checks.checknotnull(ps);
            return Utils.createSimpleObserver(fsmName, ps, 0);
        }

        private static Observer createSimpleObserver(final String fsmName, final PrintStream ps, final int generation) {
            Checks.checknotnull(ps);
            return new Observer(){

                private String indent(int level) {
                    return new String(new char[2 * level]).replace("\u0000", " ");
                }

                @Override
                public Observer createChild(String childName) {
                    return Utils.createSimpleObserver(childName, ps, generation + 1);
                }

                public void startSequence(Type type, ScenarioSequence scenarioSequence) {
                    ps.printf("%s[%d]Starting(%s#%s):%s\n", new Object[]{this.indent(generation), Thread.currentThread().getId(), fsmName, type, scenarioSequence});
                }

                public void run(Type type, Scenario scenario, Object o) {
                    ps.printf("%s[%d]Running(%s#%s):%s expecting %s\n", new Object[]{this.indent(generation + 1), Thread.currentThread().getId(), fsmName, type, scenario, scenario.then()});
                }

                public void passed(Type type, Scenario scenario, Object o) {
                    ps.printf("%s[%d]Passed(%s#%s)\n", new Object[]{this.indent(generation + 1), Thread.currentThread().getId(), fsmName, type});
                }

                public void failed(Type type, Scenario scenario, Object o, Expectation.Result result) {
                    ps.printf("%s[%d]Failed(%s#%s): %s\n", new Object[]{this.indent(generation + 1), Thread.currentThread().getId(), fsmName, type, result.getMessage()});
                }

                public void endSequence(Type type, ScenarioSequence seq) {
                    ps.printf("%s[%d]End(%s#%s)\n", new Object[]{this.indent(generation), Thread.currentThread().getId(), fsmName, type});
                }
            };
        }
    }

    public static class EmptyScenarioSequence
    implements ScenarioSequence {
        public void perform(Object context, Type type, Object o, FSMUtils.Synchronizer synchronizer, FSMUtils.Synchronizable token, Observer observer) {
        }

        @Override
        public int size() {
            return 0;
        }

        public Scenario<?> get(int i) {
            throw new IllegalStateException();
        }

        public State<?> state(int i) {
            throw new IllegalStateException();
        }

        public Action<?> action(int i) {
            throw new IllegalStateException();
        }

        @Override
        public Object arg(int i, int j) {
            throw new IllegalStateException();
        }

        @Override
        public boolean hasArg(int i, int j) {
            throw new IllegalStateException();
        }

        @Override
        public Args args(int i) {
            throw new IllegalStateException();
        }

        public String toString() {
            return Utils.toString(this);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof ScenarioSequence) {
                ScenarioSequence anotherSequence = (ScenarioSequence)another;
                return Utils.toString(this).equals(Utils.toString(anotherSequence));
            }
            return false;
        }
    }

    public static abstract class Base<SUT>
    implements ScenarioSequence<SUT> {
        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public <T> void perform(T context, Type type, SUT sut, FSMUtils.Synchronizer synchronizer, FSMUtils.Synchronizable token, Observer observer) {
            Checks.checknotnull(context);
            Checks.checknotnull(type);
            Checks.checknotnull(synchronizer);
            Checks.checknotnull(token);
            Checks.checknotnull(observer);
            observer.startSequence(type, this);
            try {
                for (int i = 0; i < this.size(); ++i) {
                    Scenario<SUT> each = this.get(i);
                    Expectation.Result result = null;
                    observer.run(type, each, sut);
                    boolean passed = false;
                    try {
                        if (i == 0 && !each.given.check(sut)) {
                            throw new Expectation.Result.Builder("Precondition was not satisfied.").addFailedReason(String.format("SUT(%s) isn't in state '%s'", sut, each.given)).build();
                        }
                        Object r = each.perform(context, sut);
                        passed = true;
                        result = each.then().checkReturnedValue(context, sut, r, type, observer);
                        continue;
                    }
                    catch (Expectation.Result r) {
                        result = r;
                        continue;
                    }
                    catch (Throwable t) {
                        if (!passed) {
                            result = each.then().checkThrownException(context, sut, t, observer);
                            continue;
                        }
                        throw new RuntimeException("Expectation#checkReturnedValue threw an exception. This is considered to be a framework side's bug.", t);
                    }
                    finally {
                        try {
                            if (result != null) {
                                if (result.isSuccessful()) {
                                    observer.passed(type, each, sut);
                                } else {
                                    observer.failed(type, each, sut, result);
                                }
                                result.throwIfFailed();
                            }
                        }
                        finally {
                            synchronizer = synchronizer.finishAndSynchronize(token);
                        }
                    }
                }
            }
            finally {
                synchronizer.unregister(token);
                observer.endSequence(type, this);
            }
        }

        @Override
        public Scenario<SUT> get(int i) {
            Checks.checkcond(i >= 0);
            Checks.checkcond(i < this.size());
            State given = this.state(i);
            Action when = this.action(i);
            Args with = this.args(i);
            return new Scenario(given, when, with);
        }

        public int hashCode() {
            return this.toString().hashCode();
        }

        public boolean equals(Object another) {
            if (another instanceof ScenarioSequence) {
                ScenarioSequence anotherSequence = (ScenarioSequence)another;
                return Utils.toString(this).equals(Utils.toString(anotherSequence));
            }
            return false;
        }

        public String toString() {
            return Utils.toString(this);
        }
    }

    public static enum Type {
        setUp,
        main;

    }
}

