/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.fsm;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.fsm.Action;
import com.github.dakusui.jcunit.fsm.FSM;
import com.github.dakusui.jcunit.fsm.State;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class FSMFactors
extends Factors {
    public static final Object VOID = new Object();
    private final Map<String, FSM<?>> fsmMap;

    protected FSMFactors(List<Factor> factors, Map<String, FSM<?>> fsmMap) {
        super(factors);
        this.fsmMap = Collections.unmodifiableMap(fsmMap);
    }

    public List<String> getFSMNames() {
        ArrayList<String> ret = new ArrayList<String>(this.fsmMap.size());
        ret.addAll(this.fsmMap.keySet());
        return Collections.unmodifiableList(ret);
    }

    public String stateFactorName(String fsmName, int i) {
        Checks.checknotnull(fsmName);
        Checks.checkcond(this.fsmMap.get(fsmName) != null);
        Checks.checkcond(0 <= i);
        Checks.checkcond(i < this.historyLength(fsmName));
        return FSMFactors.stateName(fsmName, i);
    }

    public String actionFactorName(String fsmName, int i) {
        Checks.checknotnull(fsmName);
        Checks.checkcond(this.fsmMap.get(fsmName) != null);
        Checks.checkcond(0 <= i);
        Checks.checkcond(i < this.historyLength(fsmName));
        return FSMFactors.actionName(fsmName, i);
    }

    public String paramFactorName(String fsmName, int i, int j) {
        Checks.checknotnull(fsmName);
        Checks.checkcond(this.fsmMap.get(fsmName) != null);
        return FSMFactors.paramName(fsmName, i, j);
    }

    public int historyLength(String fsmName) {
        Checks.checknotnull(fsmName);
        Checks.checkcond(this.fsmMap.get(fsmName) != null);
        return this.fsmMap.get(fsmName).historyLength();
    }

    public static boolean isFSMFactorName(String factorName) {
        return Checks.checknotnull(factorName).startsWith("FSM:");
    }

    public static int paramIndex(String fsmName) {
        String[] w = Checks.checknotnull(fsmName).split(":");
        int ret = Integer.parseInt(w[4]);
        return ret;
    }

    public static String stateName(String fsmName, int i) {
        return String.format("FSM:%s:state:%d", fsmName, i);
    }

    public static String actionName(String fsmName, int i) {
        return String.format("FSM:%s:action:%d", fsmName, i);
    }

    public static String paramName(String fsmName, int i, int j) {
        return String.format("FSM:%s:param:%d:%d", fsmName, i, j);
    }

    public static class Builder
    extends Factors.Builder {
        private Map<String, FSM<?>> fsms = new LinkedHashMap();
        private Factors baseFactors;

        public Builder addFSM(String name, FSM<?> fsm) {
            Checks.checknotnull(fsm);
            this.fsms.put(name, fsm);
            return this;
        }

        public Builder setBaseFactors(Factors baseFactors) {
            this.baseFactors = baseFactors;
            return this;
        }

        @Override
        public FSMFactors build() {
            HashSet<String> processedFSMfactors = new HashSet<String>();
            for (Map.Entry<String, FSM<?>> entry : this.fsms.entrySet()) {
                String fsmName = entry.getKey();
                processedFSMfactors.add(fsmName);
                FSM<?> fsm = entry.getValue();
                int len = fsm.historyLength();
                for (int index = 0; index < len; ++index) {
                    Factor.Builder bb = new Factor.Builder(FSMFactors.stateName(fsmName, index));
                    for (State<?> each : fsm.states()) {
                        bb.addLevel(each);
                    }
                    this.add(bb.build());
                    ArrayList allParams = new ArrayList();
                    int smallestNumParams = Integer.MAX_VALUE;
                    Factor.Builder bb2 = new Factor.Builder(FSMFactors.actionName(fsmName, index));
                    for (Action<?> action : fsm.actions()) {
                        bb2.addLevel(action);
                        if (action.numParameterFactors() < smallestNumParams) {
                            smallestNumParams = action.numParameterFactors();
                        }
                        for (int i = 0; i < action.numParameterFactors(); ++i) {
                            Object[] paramValues;
                            if (i >= allParams.size()) {
                                allParams.add(new LinkedHashSet());
                            }
                            for (Object v : paramValues = action.parameterFactorLevels(i)) {
                                ((Set)allParams.get(i)).add(v);
                            }
                        }
                    }
                    this.add(bb2.build());
                    int i = 0;
                    for (Set set : allParams) {
                        Factor.Builder bb3 = new Factor.Builder(FSMFactors.paramName(fsmName, index, i++));
                        if (i >= smallestNumParams) {
                            bb3.addLevel(VOID);
                        }
                        for (Object v : set) {
                            bb3.addLevel(v);
                        }
                        this.add(bb3.build());
                    }
                }
            }
            for (int index = 0; index < this.baseFactors.size(); ++index) {
                if (processedFSMfactors.contains(this.baseFactors.get((int)index).name)) continue;
                this.add(this.baseFactors.get(index));
            }
            return new FSMFactors(this.factors, this.fsms);
        }
    }
}

