/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core.tuples;

import com.github.dakusui.enumerator.CartesianEnumeratorAdaptor;
import com.github.dakusui.enumerator.Combinator;
import com.github.dakusui.enumerator.Domains;
import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.Utils;
import com.github.dakusui.jcunit.core.factor.Factor;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.core.tuples.TupleImpl;
import com.github.dakusui.jcunit.exceptions.SavedObjectBrokenException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;

public class TupleUtils {
    public static CartesianTuples enumerateCartesianProduct(Tuple base, Factor ... factors) {
        Checks.checknotnull(base);
        return new CartesianTuples(base, factors);
    }

    public static Set<Tuple> subtuplesOf(Tuple tuple, int strength) {
        Checks.checknotnull(tuple);
        Checks.checkcond(strength >= 0 && strength <= tuple.size());
        LinkedHashSet<Tuple> ret = new LinkedHashSet<Tuple>();
        Combinator c = new Combinator(new LinkedList(tuple.keySet()), strength);
        for (List keys : c) {
            TupleImpl cur = new TupleImpl();
            for (String k : keys) {
                cur.put(k, tuple.get(k));
            }
            ret.add(cur);
        }
        return ret;
    }

    public static Set<Tuple> subtuplesOf(Tuple tuple) {
        Checks.checknotnull(tuple);
        LinkedHashSet<Tuple> ret = new LinkedHashSet<Tuple>();
        int sz = tuple.size();
        for (int i = 0; i <= sz; ++i) {
            ret.addAll(TupleUtils.subtuplesOf(tuple, sz - i));
        }
        return ret;
    }

    public static boolean isSubtupleOf(Tuple t, Tuple u) {
        Checks.checknotnull(t);
        Checks.checknotnull(u);
        return t.isSubtupleOf(u);
    }

    public static Tuple unmodifiableTuple(Tuple tuple) {
        Checks.checknotnull(tuple);
        return new Tuple.Builder().putAll(tuple).setUnmodifiable(true).build();
    }

    public static String toString(Collection<Tuple> tuples) {
        StringBuilder b = new StringBuilder();
        b.append('[');
        boolean firstTime = true;
        for (Tuple t : tuples) {
            if (!firstTime) {
                b.append(",");
            }
            b.append(TupleUtils.toString(t));
            firstTime = false;
        }
        b.append(']');
        return b.toString();
    }

    public static String toString(Tuple tuple) {
        Checks.checknotnull(tuple);
        return TupleUtils.tupleToString(tuple);
    }

    private static String escape(Object v) {
        String ret = v.toString();
        ret = ret.replaceAll("\\\\", "\\\\\\\\");
        ret = ret.replaceAll("\"", "\\\\\"");
        return ret;
    }

    private static String arrToString(Object v) {
        int len = Array.getLength(v);
        StringBuilder b = new StringBuilder();
        b.append('[');
        for (int i = 0; i < len; ++i) {
            if (i > 0) {
                b.append(',');
            }
            b.append(TupleUtils.valueToString(Array.get(v, i)));
        }
        b.append(']');
        return b.toString();
    }

    private static String tupleToString(Tuple tuple) {
        StringBuilder b = new StringBuilder();
        Set keySet = tuple.keySet();
        b.append('{');
        boolean firstTime = true;
        for (String k : keySet) {
            if (!firstTime) {
                b.append(',');
            }
            Object v = tuple.get(k);
            b.append(String.format("\"%s\":%s", TupleUtils.escape(k), TupleUtils.valueToString(v)));
            firstTime = false;
        }
        b.append('}');
        return b.toString();
    }

    private static String valueToString(Object v) {
        return v == null ? null : (v instanceof Tuple ? TupleUtils.tupleToString((Tuple)v) : (v instanceof Number ? v.toString() : (v.getClass().isArray() ? TupleUtils.arrToString(v) : String.format("\"%s\"", TupleUtils.escape(v)))));
    }

    public static void save(Tuple tuple, OutputStream os) {
        Utils.save((Object)tuple, os);
    }

    public static Tuple load(InputStream is) {
        Object obj = Utils.load(is);
        if (obj instanceof Tuple) {
            return (Tuple)obj;
        }
        throw new SavedObjectBrokenException(String.format("Saved object wasn't a tuple (%s)", obj.getClass().getCanonicalName()), null);
    }

    public static class CartesianTuples
    extends CartesianEnumeratorAdaptor<Tuple, String, Object> {
        private final Tuple base;

        protected CartesianTuples(Tuple base, final Factor ... factors) {
            super((Domains)new Domains<String, Object>(){

                public List<String> getDomainNames() {
                    ArrayList<String> ret = new ArrayList<String>(factors.length);
                    for (Factor f : factors) {
                        ret.add(f.name);
                    }
                    return ret;
                }

                public List<Object> getDomain(String s) {
                    Checks.checknotnull(s);
                    for (Factor f : factors) {
                        if (!s.equals(f.name)) continue;
                        return f.levels;
                    }
                    return null;
                }
            });
            this.base = Checks.checknotnull(base);
        }

        protected Tuple createMap() {
            return this.base.cloneTuple();
        }
    }
}

