/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core.factor;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.FactorField;
import com.github.dakusui.jcunit.core.JCUnitConfigurablePluginBase;
import com.github.dakusui.jcunit.core.ParamType;
import com.github.dakusui.jcunit.core.factor.LevelsProvider;
import java.lang.reflect.Field;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;

public abstract class LevelsProviderBase<T>
extends JCUnitConfigurablePluginBase
implements LevelsProvider<T> {
    private Field targetField;
    private FactorField annotation;
    protected final LinkedList<String> errors = new LinkedList();

    protected LevelsProviderBase() {
    }

    @Override
    public ParamType[] parameterTypes() {
        return new ParamType[0];
    }

    @Override
    public final void init(Object[] parameters) {
        Checks.checknotnull(this.annotation);
        Checks.checknotnull(this.targetField);
        this.errors.clear();
        this.init(this.targetField, this.annotation, parameters);
        Checks.checktest(this.errors.isEmpty(), "Errors are found in field '%s' of '%s': %s", this.targetField.getName(), this.targetField.getDeclaringClass().getCanonicalName(), this.errors);
    }

    protected abstract void init(Field var1, FactorField var2, Object[] var3);

    @Override
    public final void setTargetField(Field targetField) {
        Checks.checknotnull(targetField);
        this.targetField = targetField;
    }

    @Override
    public final void setAnnotation(FactorField ann) {
        this.annotation = ann;
    }

    @Override
    public final List<String> getErrorsOnInitialization() {
        return Collections.unmodifiableList(this.errors);
    }
}

