/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core;

import com.github.dakusui.jcunit.core.Checks;
import java.io.File;

public class SystemProperties {
    private SystemProperties() {
    }

    public static File jcunitBaseDir() {
        String rec = System.getProperty(KEY.BASEDIR.key());
        File ret = rec != null ? new File(rec) : new File(".jcunit");
        return ret;
    }

    public static boolean isDebugEnabled() {
        return Boolean.parseBoolean(System.getProperty(KEY.DEBUG.key(), "false"));
    }

    public static boolean isRecorderEnabled() {
        return Boolean.parseBoolean(System.getProperty(KEY.RECORDER.key(), "false"));
    }

    public static boolean isReplayerEnabled() {
        return Boolean.parseBoolean(System.getProperty(KEY.REPLAYER.key(), "false"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static long randomSeed() {
        String randomSeedKey = KEY.RANDOMSEED.key();
        Class<SystemProperties> clazz = SystemProperties.class;
        synchronized (SystemProperties.class) {
            try {
                if (System.getProperty(randomSeedKey) == null) {
                    System.setProperty(randomSeedKey, Long.toString(System.currentTimeMillis()));
                }
                // ** MonitorExit[var1_1] (shouldn't be in output)
                return Long.parseLong(System.getProperty(randomSeedKey));
            }
            catch (NumberFormatException e) {
                Checks.checkenv(false, "The value '%s' specified for system property '%s' is not an integer.", System.getProperty(randomSeedKey), randomSeedKey);
                // ** MonitorExit[var1_1] (shouldn't be in output)
            }
            throw new RuntimeException();
        }
    }

    public static enum KEY {
        DEBUG{

            @Override
            public String key() {
                return "jcunit.debug";
            }
        }
        ,
        BASEDIR{

            @Override
            public String key() {
                return "jcunit.basedir";
            }
        }
        ,
        RECORDER{

            @Override
            public String key() {
                return "jcunit.recorder";
            }
        }
        ,
        REPLAYER{

            @Override
            public String key() {
                return "jcunit.replayer";
            }
        }
        ,
        RANDOMSEED{

            @Override
            public String key() {
                return "jcunit.generator.randomseed";
            }
        };


        public abstract String key();
    }
}

