/*
 * Decompiled with CFR 0.152.
 */
package com.github.dakusui.jcunit.core;

import com.github.dakusui.jcunit.core.Checks;
import com.github.dakusui.jcunit.core.FrameworkMethodUtils;
import com.github.dakusui.jcunit.core.JCUnit;
import com.github.dakusui.jcunit.core.When;
import com.github.dakusui.jcunit.core.factor.Factors;
import com.github.dakusui.jcunit.core.tuples.Tuple;
import com.github.dakusui.jcunit.core.tuples.TupleUtils;
import java.lang.annotation.Annotation;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.junit.Ignore;
import org.junit.runner.Description;
import org.junit.runner.notification.RunNotifier;
import org.junit.runners.BlockJUnit4ClassRunner;
import org.junit.runners.model.FrameworkMethod;
import org.junit.runners.model.InitializationError;
import org.junit.runners.model.Statement;
import org.junit.runners.model.TestClass;

public class JCUnitRunner
extends BlockJUnit4ClassRunner {
    private final Tuple testCase;
    private final int id;
    private final JCUnit.TestCaseType type;
    private final Factors factors;
    private final Map<String, FrameworkMethod> methods = new HashMap<String, FrameworkMethod>();

    public JCUnitRunner(Class<?> clazz, int id, JCUnit.TestCaseType testType, Factors factors, Tuple testCase) throws InitializationError {
        super(clazz);
        Checks.checknotnull(testCase);
        this.factors = factors;
        this.testCase = testCase;
        this.id = id;
        this.type = testType;
        LinkedList<String> errors = new LinkedList<String>();
        for (FrameworkMethod each : FrameworkMethodUtils.FrameworkMethodRetriever.REFERENCED_BY_WHEN.getMethods(clazz)) {
            FrameworkMethodUtils.validateFrameworkMethod(clazz, each, FrameworkMethodUtils.FrameworkMethodValidator.VALIDATOR_FOR_METHOD_REFERENCEDBY_WHEN, errors);
            this.methods.put(each.getName(), each);
        }
        if (!errors.isEmpty()) {
            throw new InitializationError(String.format("Errors are found in '%s'.: %s", clazz.getCanonicalName(), errors));
        }
    }

    protected Statement classBlock(RunNotifier notifier) {
        return this.childrenInvoker(notifier);
    }

    public Object createTest() {
        TestClass klazz = this.getTestClass();
        return JCUnit.createTestObject(klazz, this.testCase);
    }

    protected String getName() {
        return String.format("[%d]", this.id);
    }

    protected String testName(FrameworkMethod method) {
        return String.format("%s[%d]", method.getName(), this.id);
    }

    protected void validateConstructor(List<Throwable> errors) {
        this.validateZeroArgConstructor(errors);
    }

    protected Description describeChild(FrameworkMethod method) {
        Checks.checknotnull(method);
        Annotation[] work = method.getAnnotations();
        ArrayList<JCUnit.InternalAnnotation> annotations = new ArrayList<JCUnit.InternalAnnotation>(work.length + 1);
        annotations.add(new JCUnit.InternalAnnotation(this.type, this.id, this.factors, this.testCase));
        Collections.addAll(annotations, work);
        return Description.createTestDescription((Class)this.getTestClass().getJavaClass(), (String)this.testName(method), (Annotation[])annotations.toArray(new Annotation[annotations.size()]));
    }

    protected void runChild(FrameworkMethod method, RunNotifier notifier) {
        Description description = this.describeChild(method);
        if (method.getAnnotation(Ignore.class) != null) {
            notifier.fireTestIgnored(description);
        } else {
            this.runLeaf(this.methodBlock(method), description, notifier);
        }
    }

    protected List<FrameworkMethod> getChildren() {
        LinkedList<FrameworkMethod> ret = new LinkedList<FrameworkMethod>();
        for (FrameworkMethod each : this.computeTestMethods()) {
            if (!this.shouldInvoke(each, this.createTest())) continue;
            ret.add(each);
        }
        if (ret.isEmpty()) {
            ret.add(this.getDummyMethodForNoMatchingMethodFound());
        }
        return ret;
    }

    private boolean shouldInvoke(FrameworkMethod testMethod, Object testObject) {
        When when = (When)testMethod.getAnnotation(When.class);
        if (when == null) {
            return true;
        }
        String preconditionMethodName = FrameworkMethodUtils.getPreconditionMethodNameFor(when);
        FrameworkMethod preconditionMethod = this.methods.get(preconditionMethodName);
        Checks.checkcond(preconditionMethod != null, "Something went wrong: name=%s, methdos=%s", preconditionMethodName, this.methods);
        boolean ret = false;
        try {
            ret = (Boolean)preconditionMethod.invokeExplosively(testObject, new Object[0]);
        }
        catch (RuntimeException e) {
            throw e;
        }
        catch (Error e) {
            throw e;
        }
        catch (Throwable throwable) {
            Checks.rethrow(throwable);
        }
        return ret;
    }

    private FrameworkMethod getDummyMethodForNoMatchingMethodFound() {
        try {
            return new FrameworkMethod(JCUnitRunner.class.getMethod("noMatchingTestMethodIsFoundForThisTestCase", new Class[0])){

                public String getName() {
                    return String.format("%s:%s", super.getName(), TupleUtils.toString(JCUnitRunner.this.testCase));
                }
            };
        }
        catch (NoSuchMethodException e) {
            assert (false);
            Checks.checkcond(false);
            return null;
        }
    }

    @Ignore
    public static void noMatchingTestMethodIsFoundForThisTestCase() {
    }
}

