/*
 * Decompiled with CFR 0.152.
 */
package com.daimajia.swipe;

import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.Rect;
import android.support.v4.view.ViewCompat;
import android.support.v4.widget.ViewDragHelper;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.ViewParent;
import android.widget.Adapter;
import android.widget.AdapterView;
import android.widget.BaseAdapter;
import android.widget.FrameLayout;
import android.widget.ListAdapter;
import com.daimajia.swipe.R;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class SwipeLayout
extends FrameLayout {
    private ViewDragHelper mDragHelper;
    private int mDragDistance = 0;
    private DragEdge mDragEdge;
    private ShowMode mShowMode;
    private float mHorizontalSwipeOffset;
    private float mVerticalSwipeOffset;
    private List<SwipeListener> mSwipeListeners = new ArrayList<SwipeListener>();
    private List<SwipeDenier> mSwipeDeniers = new ArrayList<SwipeDenier>();
    private Map<View, ArrayList<OnRevealListener>> mRevealListeners = new HashMap<View, ArrayList<OnRevealListener>>();
    private Map<View, Boolean> mShowEntirely = new HashMap<View, Boolean>();
    private DoubleClickListener mDoubleClickListener;
    private boolean mSwipeEnabled = true;
    private ViewDragHelper.Callback mDragHelperCallback = new ViewDragHelper.Callback(){

        public int clampViewPositionHorizontal(View child, int left, int dx) {
            if (child == SwipeLayout.this.getSurfaceView()) {
                switch (SwipeLayout.this.mDragEdge) {
                    case Top: 
                    case Bottom: {
                        return SwipeLayout.this.getPaddingLeft();
                    }
                    case Left: {
                        if (left < SwipeLayout.this.getPaddingLeft()) {
                            return SwipeLayout.this.getPaddingLeft();
                        }
                        if (left <= SwipeLayout.this.getPaddingLeft() + SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingLeft() + SwipeLayout.this.mDragDistance;
                    }
                    case Right: {
                        if (left > SwipeLayout.this.getPaddingLeft()) {
                            return SwipeLayout.this.getPaddingLeft();
                        }
                        if (left >= SwipeLayout.this.getPaddingLeft() - SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingLeft() - SwipeLayout.this.mDragDistance;
                    }
                }
            } else if (child == SwipeLayout.this.getBottomView()) {
                switch (SwipeLayout.this.mDragEdge) {
                    case Top: 
                    case Bottom: {
                        return SwipeLayout.this.getPaddingLeft();
                    }
                    case Left: {
                        if (SwipeLayout.this.mShowMode != ShowMode.PullOut || left <= SwipeLayout.this.getPaddingLeft()) break;
                        return SwipeLayout.this.getPaddingLeft();
                    }
                    case Right: {
                        if (SwipeLayout.this.mShowMode != ShowMode.PullOut || left >= SwipeLayout.this.getMeasuredWidth() - SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getMeasuredWidth() - SwipeLayout.this.mDragDistance;
                    }
                }
            }
            return left;
        }

        public int clampViewPositionVertical(View child, int top, int dy) {
            if (child == SwipeLayout.this.getSurfaceView()) {
                switch (SwipeLayout.this.mDragEdge) {
                    case Left: 
                    case Right: {
                        return SwipeLayout.this.getPaddingTop();
                    }
                    case Top: {
                        if (top < SwipeLayout.this.getPaddingTop()) {
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (top <= SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance;
                    }
                    case Bottom: {
                        if (top < SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance) {
                            return SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance;
                        }
                        if (top <= SwipeLayout.this.getPaddingTop()) break;
                        return SwipeLayout.this.getPaddingTop();
                    }
                }
            } else {
                switch (SwipeLayout.this.mDragEdge) {
                    case Left: 
                    case Right: {
                        return SwipeLayout.this.getPaddingTop();
                    }
                    case Top: {
                        if (SwipeLayout.this.mShowMode == ShowMode.PullOut) {
                            if (top <= SwipeLayout.this.getPaddingTop()) break;
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (SwipeLayout.this.getSurfaceView().getTop() + dy < SwipeLayout.this.getPaddingTop()) {
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (SwipeLayout.this.getSurfaceView().getTop() + dy <= SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingTop() + SwipeLayout.this.mDragDistance;
                    }
                    case Bottom: {
                        if (SwipeLayout.this.mShowMode == ShowMode.PullOut) {
                            if (top >= SwipeLayout.this.getMeasuredHeight() - SwipeLayout.this.mDragDistance) break;
                            return SwipeLayout.this.getMeasuredHeight() - SwipeLayout.this.mDragDistance;
                        }
                        if (SwipeLayout.this.getSurfaceView().getTop() + dy >= SwipeLayout.this.getPaddingTop()) {
                            return SwipeLayout.this.getPaddingTop();
                        }
                        if (SwipeLayout.this.getSurfaceView().getTop() + dy > SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance) break;
                        return SwipeLayout.this.getPaddingTop() - SwipeLayout.this.mDragDistance;
                    }
                }
            }
            return top;
        }

        public boolean tryCaptureView(View child, int pointerId) {
            return child == SwipeLayout.this.getSurfaceView() || child == SwipeLayout.this.getBottomView();
        }

        public int getViewHorizontalDragRange(View child) {
            return SwipeLayout.this.mDragDistance;
        }

        public int getViewVerticalDragRange(View child) {
            return SwipeLayout.this.mDragDistance;
        }

        public void onViewReleased(View releasedChild, float xvel, float yvel) {
            super.onViewReleased(releasedChild, xvel, yvel);
            for (SwipeListener l : SwipeLayout.this.mSwipeListeners) {
                l.onHandRelease(SwipeLayout.this, xvel, yvel);
            }
            if (releasedChild == SwipeLayout.this.getSurfaceView()) {
                SwipeLayout.this.processSurfaceRelease(xvel, yvel);
            } else if (releasedChild == SwipeLayout.this.getBottomView()) {
                if (SwipeLayout.this.getShowMode() == ShowMode.PullOut) {
                    SwipeLayout.this.processBottomPullOutRelease(xvel, yvel);
                } else if (SwipeLayout.this.getShowMode() == ShowMode.LayDown) {
                    SwipeLayout.this.processBottomLayDownMode(xvel, yvel);
                }
            }
            SwipeLayout.this.invalidate();
        }

        public void onViewPositionChanged(View changedView, int left, int top, int dx, int dy) {
            int evLeft = SwipeLayout.this.getSurfaceView().getLeft();
            int evRight = SwipeLayout.this.getSurfaceView().getRight();
            int evTop = SwipeLayout.this.getSurfaceView().getTop();
            int evBottom = SwipeLayout.this.getSurfaceView().getBottom();
            if (changedView == SwipeLayout.this.getSurfaceView()) {
                if (SwipeLayout.this.mShowMode == ShowMode.PullOut) {
                    if (SwipeLayout.this.mDragEdge == DragEdge.Left || SwipeLayout.this.mDragEdge == DragEdge.Right) {
                        SwipeLayout.this.getBottomView().offsetLeftAndRight(dx);
                    } else {
                        SwipeLayout.this.getBottomView().offsetTopAndBottom(dy);
                    }
                }
            } else if (changedView == SwipeLayout.this.getBottomView()) {
                if (SwipeLayout.this.mShowMode == ShowMode.PullOut) {
                    SwipeLayout.this.getSurfaceView().offsetLeftAndRight(dx);
                    SwipeLayout.this.getSurfaceView().offsetTopAndBottom(dy);
                } else {
                    Rect rect = SwipeLayout.this.computeBottomLayDown(SwipeLayout.this.mDragEdge);
                    SwipeLayout.this.getBottomView().layout(rect.left, rect.top, rect.right, rect.bottom);
                    int newLeft = SwipeLayout.this.getSurfaceView().getLeft() + dx;
                    int newTop = SwipeLayout.this.getSurfaceView().getTop() + dy;
                    if (SwipeLayout.this.mDragEdge == DragEdge.Left && newLeft < SwipeLayout.this.getPaddingLeft()) {
                        newLeft = SwipeLayout.this.getPaddingLeft();
                    } else if (SwipeLayout.this.mDragEdge == DragEdge.Right && newLeft > SwipeLayout.this.getPaddingLeft()) {
                        newLeft = SwipeLayout.this.getPaddingLeft();
                    } else if (SwipeLayout.this.mDragEdge == DragEdge.Top && newTop < SwipeLayout.this.getPaddingTop()) {
                        newTop = SwipeLayout.this.getPaddingTop();
                    } else if (SwipeLayout.this.mDragEdge == DragEdge.Bottom && newTop > SwipeLayout.this.getPaddingTop()) {
                        newTop = SwipeLayout.this.getPaddingTop();
                    }
                    SwipeLayout.this.getSurfaceView().layout(newLeft, newTop, newLeft + SwipeLayout.this.getMeasuredWidth(), newTop + SwipeLayout.this.getMeasuredHeight());
                }
            }
            SwipeLayout.this.dispatchRevealEvent(evLeft, evTop, evRight, evBottom);
            SwipeLayout.this.dispatchSwipeEvent(evLeft, evTop, dx, dy);
            SwipeLayout.this.invalidate();
        }
    };
    private int mEventCounter = 0;
    private List<OnLayout> mOnLayoutListeners;
    private boolean mTouchConsumedByChild = false;
    private float sX = -1.0f;
    private float sY = -1.0f;
    private GestureDetector gestureDetector = new GestureDetector(this.getContext(), (GestureDetector.OnGestureListener)new SwipeDetector());

    public SwipeLayout(Context context) {
        this(context, null);
    }

    public SwipeLayout(Context context, AttributeSet attrs) {
        this(context, attrs, 0);
    }

    public SwipeLayout(Context context, AttributeSet attrs, int defStyle) {
        super(context, attrs, defStyle);
        this.mDragHelper = ViewDragHelper.create((ViewGroup)this, (ViewDragHelper.Callback)this.mDragHelperCallback);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.SwipeLayout);
        int ordinal = a.getInt(R.styleable.SwipeLayout_drag_edge, DragEdge.Right.ordinal());
        this.mHorizontalSwipeOffset = a.getDimension(R.styleable.SwipeLayout_horizontalSwipeOffset, 0.0f);
        this.mVerticalSwipeOffset = a.getDimension(R.styleable.SwipeLayout_verticalSwipeOffset, 0.0f);
        this.mDragEdge = DragEdge.values()[ordinal];
        ordinal = a.getInt(R.styleable.SwipeLayout_show_mode, ShowMode.PullOut.ordinal());
        this.mShowMode = ShowMode.values()[ordinal];
    }

    public void addSwipeListener(SwipeListener l) {
        this.mSwipeListeners.add(l);
    }

    public void removeSwipeListener(SwipeListener l) {
        this.mSwipeListeners.remove(l);
    }

    public void addSwipeDenier(SwipeDenier denier) {
        this.mSwipeDeniers.add(denier);
    }

    public void removeSwipeDenier(SwipeDenier denier) {
        this.mSwipeDeniers.remove(denier);
    }

    public void removeAllSwipeDeniers() {
        this.mSwipeDeniers.clear();
    }

    public void addRevealListener(int childId, OnRevealListener l) {
        View child = this.findViewById(childId);
        if (child == null) {
            throw new IllegalArgumentException("Child does not belong to SwipeListener.");
        }
        if (!this.mShowEntirely.containsKey(child)) {
            this.mShowEntirely.put(child, false);
        }
        if (this.mRevealListeners.get(child) == null) {
            this.mRevealListeners.put(child, new ArrayList());
        }
        this.mRevealListeners.get(child).add(l);
    }

    public void addRevealListener(int[] childIds, OnRevealListener l) {
        for (int i : childIds) {
            this.addRevealListener(i, l);
        }
    }

    public void removeRevealListener(int childId, OnRevealListener l) {
        View child = this.findViewById(childId);
        if (child == null) {
            return;
        }
        this.mShowEntirely.remove(child);
        if (this.mRevealListeners.containsKey(child)) {
            this.mRevealListeners.get(child).remove(l);
        }
    }

    public void removeAllRevealListeners(int childId) {
        View child = this.findViewById(childId);
        if (child != null) {
            this.mRevealListeners.remove(child);
            this.mShowEntirely.remove(child);
        }
    }

    protected boolean isViewTotallyFirstShowed(View child, Rect relativePosition, DragEdge edge, int surfaceLeft, int surfaceTop, int surfaceRight, int surfaceBottom) {
        if (this.mShowEntirely.get(child).booleanValue()) {
            return false;
        }
        int childLeft = relativePosition.left;
        int childRight = relativePosition.right;
        int childTop = relativePosition.top;
        int childBottom = relativePosition.bottom;
        boolean r = false;
        if (this.getShowMode() == ShowMode.LayDown) {
            if (edge == DragEdge.Right && surfaceRight <= childLeft || edge == DragEdge.Left && surfaceLeft >= childRight || edge == DragEdge.Top && surfaceTop >= childBottom || edge == DragEdge.Bottom && surfaceBottom <= childTop) {
                r = true;
            }
        } else if (this.getShowMode() == ShowMode.PullOut && (edge == DragEdge.Right && childRight <= this.getWidth() || edge == DragEdge.Left && childLeft >= this.getPaddingLeft() || edge == DragEdge.Top && childTop >= this.getPaddingTop() || edge == DragEdge.Bottom && childBottom <= this.getHeight())) {
            r = true;
        }
        return r;
    }

    protected boolean isViewShowing(View child, Rect relativePosition, DragEdge availableEdge, int surfaceLeft, int surfaceTop, int surfaceRight, int surfaceBottom) {
        int childLeft = relativePosition.left;
        int childRight = relativePosition.right;
        int childTop = relativePosition.top;
        int childBottom = relativePosition.bottom;
        if (this.getShowMode() == ShowMode.LayDown) {
            switch (availableEdge) {
                case Right: {
                    if (surfaceRight <= childLeft || surfaceRight > childRight) break;
                    return true;
                }
                case Left: {
                    if (surfaceLeft >= childRight || surfaceLeft < childLeft) break;
                    return true;
                }
                case Top: {
                    if (surfaceTop < childTop || surfaceTop >= childBottom) break;
                    return true;
                }
                case Bottom: {
                    if (surfaceBottom <= childTop || surfaceBottom > childBottom) break;
                    return true;
                }
            }
        } else if (this.getShowMode() == ShowMode.PullOut) {
            switch (availableEdge) {
                case Right: {
                    if (childLeft > this.getWidth() || childRight <= this.getWidth()) break;
                    return true;
                }
                case Left: {
                    if (childRight < this.getPaddingLeft() || childLeft >= this.getPaddingLeft()) break;
                    return true;
                }
                case Top: {
                    if (childTop >= this.getPaddingTop() || childBottom < this.getPaddingTop()) break;
                    return true;
                }
                case Bottom: {
                    if (childTop >= this.getHeight() || childTop < this.getPaddingTop()) break;
                    return true;
                }
            }
        }
        return false;
    }

    protected Rect getRelativePosition(View child) {
        View t = child;
        Rect r = new Rect(t.getLeft(), t.getTop(), 0, 0);
        while (t.getParent() != null && t != this.getRootView() && (t = (View)t.getParent()) != this) {
            r.left += t.getLeft();
            r.top += t.getTop();
        }
        r.right = r.left + child.getMeasuredWidth();
        r.bottom = r.top + child.getMeasuredHeight();
        return r;
    }

    protected void dispatchSwipeEvent(int surfaceLeft, int surfaceTop, int dx, int dy) {
        DragEdge edge = this.getDragEdge();
        boolean open = true;
        if (edge == DragEdge.Left) {
            if (dx < 0) {
                open = false;
            }
        } else if (edge == DragEdge.Right) {
            if (dx > 0) {
                open = false;
            }
        } else if (edge == DragEdge.Top) {
            if (dy < 0) {
                open = false;
            }
        } else if (edge == DragEdge.Bottom && dy > 0) {
            open = false;
        }
        this.dispatchSwipeEvent(surfaceLeft, surfaceTop, open);
    }

    protected void dispatchSwipeEvent(int surfaceLeft, int surfaceTop, boolean open) {
        this.safeBottomView();
        Status status = this.getOpenStatus();
        if (!this.mSwipeListeners.isEmpty()) {
            ++this.mEventCounter;
            for (SwipeListener l : this.mSwipeListeners) {
                if (this.mEventCounter == 1) {
                    if (open) {
                        l.onStartOpen(this);
                    } else {
                        l.onStartClose(this);
                    }
                }
                l.onUpdate(this, surfaceLeft - this.getPaddingLeft(), surfaceTop - this.getPaddingTop());
            }
            if (status == Status.Close) {
                for (SwipeListener l : this.mSwipeListeners) {
                    l.onClose(this);
                }
                this.mEventCounter = 0;
            }
            if (status == Status.Open) {
                this.getBottomView().setEnabled(true);
                for (SwipeListener l : this.mSwipeListeners) {
                    l.onOpen(this);
                }
                this.mEventCounter = 0;
            }
        }
    }

    private void safeBottomView() {
        Status status = this.getOpenStatus();
        ViewGroup bottom = this.getBottomView();
        if (status == Status.Close) {
            if (bottom.getVisibility() != 4) {
                bottom.setVisibility(4);
            }
        } else if (bottom.getVisibility() != 0) {
            bottom.setVisibility(0);
        }
    }

    protected void dispatchRevealEvent(int surfaceLeft, int surfaceTop, int surfaceRight, int surfaceBottom) {
        if (this.mRevealListeners.isEmpty()) {
            return;
        }
        for (Map.Entry<View, ArrayList<OnRevealListener>> entry : this.mRevealListeners.entrySet()) {
            Rect rect;
            View child = entry.getKey();
            if (this.isViewShowing(child, rect = this.getRelativePosition(child), this.mDragEdge, surfaceLeft, surfaceTop, surfaceRight, surfaceBottom)) {
                this.mShowEntirely.put(child, false);
                int distance = 0;
                float fraction = 0.0f;
                if (this.getShowMode() == ShowMode.LayDown) {
                    switch (this.mDragEdge) {
                        case Left: {
                            distance = rect.left - surfaceLeft;
                            fraction = (float)distance / (float)child.getWidth();
                            break;
                        }
                        case Right: {
                            distance = rect.right - surfaceRight;
                            fraction = (float)distance / (float)child.getWidth();
                            break;
                        }
                        case Top: {
                            distance = rect.top - surfaceTop;
                            fraction = (float)distance / (float)child.getHeight();
                            break;
                        }
                        case Bottom: {
                            distance = rect.bottom - surfaceBottom;
                            fraction = (float)distance / (float)child.getHeight();
                        }
                    }
                } else if (this.getShowMode() == ShowMode.PullOut) {
                    switch (this.mDragEdge) {
                        case Left: {
                            distance = rect.right - this.getPaddingLeft();
                            fraction = (float)distance / (float)child.getWidth();
                            break;
                        }
                        case Right: {
                            distance = rect.left - this.getWidth();
                            fraction = (float)distance / (float)child.getWidth();
                            break;
                        }
                        case Top: {
                            distance = rect.bottom - this.getPaddingTop();
                            fraction = (float)distance / (float)child.getHeight();
                            break;
                        }
                        case Bottom: {
                            distance = rect.top - this.getHeight();
                            fraction = (float)distance / (float)child.getHeight();
                        }
                    }
                }
                for (OnRevealListener l : entry.getValue()) {
                    l.onReveal(child, this.mDragEdge, Math.abs(fraction), distance);
                    if (Math.abs(fraction) != 1.0f) continue;
                    this.mShowEntirely.put(child, true);
                }
            }
            if (!this.isViewTotallyFirstShowed(child, rect, this.mDragEdge, surfaceLeft, surfaceTop, surfaceRight, surfaceBottom)) continue;
            this.mShowEntirely.put(child, true);
            for (OnRevealListener l : entry.getValue()) {
                if (this.mDragEdge == DragEdge.Left || this.mDragEdge == DragEdge.Right) {
                    l.onReveal(child, this.mDragEdge, 1.0f, child.getWidth());
                    continue;
                }
                l.onReveal(child, this.mDragEdge, 1.0f, child.getHeight());
            }
        }
    }

    public void computeScroll() {
        super.computeScroll();
        if (this.mDragHelper.continueSettling(true)) {
            ViewCompat.postInvalidateOnAnimation((View)this);
        }
    }

    public void addOnLayoutListener(OnLayout l) {
        if (this.mOnLayoutListeners == null) {
            this.mOnLayoutListeners = new ArrayList<OnLayout>();
        }
        this.mOnLayoutListeners.add(l);
    }

    public void removeOnLayoutListener(OnLayout l) {
        if (this.mOnLayoutListeners != null) {
            this.mOnLayoutListeners.remove(l);
        }
    }

    protected void onLayout(boolean changed, int l, int t, int r, int b) {
        int childCount = this.getChildCount();
        if (childCount != 2) {
            throw new IllegalStateException("You need 2  views in SwipeLayout");
        }
        if (!(this.getChildAt(0) instanceof ViewGroup) || !(this.getChildAt(1) instanceof ViewGroup)) {
            throw new IllegalArgumentException("The 2 children in SwipeLayout must be an instance of ViewGroup");
        }
        if (this.mShowMode == ShowMode.PullOut) {
            this.layoutPullOut();
        } else if (this.mShowMode == ShowMode.LayDown) {
            this.layoutLayDown();
        }
        this.safeBottomView();
        if (this.mOnLayoutListeners != null) {
            for (int i = 0; i < this.mOnLayoutListeners.size(); ++i) {
                this.mOnLayoutListeners.get(i).onLayout(this);
            }
        }
    }

    void layoutPullOut() {
        Rect rect = this.computeSurfaceLayoutArea(false);
        this.getSurfaceView().layout(rect.left, rect.top, rect.right, rect.bottom);
        rect = this.computeBottomLayoutAreaViaSurface(ShowMode.PullOut, rect);
        this.getBottomView().layout(rect.left, rect.top, rect.right, rect.bottom);
        this.bringChildToFront((View)this.getSurfaceView());
    }

    void layoutLayDown() {
        Rect rect = this.computeSurfaceLayoutArea(false);
        this.getSurfaceView().layout(rect.left, rect.top, rect.right, rect.bottom);
        rect = this.computeBottomLayoutAreaViaSurface(ShowMode.LayDown, rect);
        this.getBottomView().layout(rect.left, rect.top, rect.right, rect.bottom);
        this.bringChildToFront((View)this.getSurfaceView());
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        this.mDragDistance = this.mDragEdge == DragEdge.Left || this.mDragEdge == DragEdge.Right ? this.getBottomView().getMeasuredWidth() - this.dp2px(this.mHorizontalSwipeOffset) : this.getBottomView().getMeasuredHeight() - this.dp2px(this.mVerticalSwipeOffset);
    }

    public boolean onInterceptTouchEvent(MotionEvent ev) {
        if (!this.isEnabled() || !this.isEnabledInAdapterView()) {
            return true;
        }
        if (!this.isSwipeEnabled()) {
            return false;
        }
        for (SwipeDenier denier : this.mSwipeDeniers) {
            if (denier == null || !denier.shouldDenySwipe(ev)) continue;
            return false;
        }
        int action = ev.getActionMasked();
        switch (action) {
            case 0: {
                Status status = this.getOpenStatus();
                if (status == Status.Close) {
                    this.mTouchConsumedByChild = this.childNeedHandleTouchEvent(this.getSurfaceView(), ev) != null;
                    break;
                }
                if (status != Status.Open) break;
                this.mTouchConsumedByChild = this.childNeedHandleTouchEvent(this.getBottomView(), ev) != null;
                break;
            }
            case 1: 
            case 3: {
                this.mTouchConsumedByChild = false;
            }
        }
        if (this.mTouchConsumedByChild) {
            return false;
        }
        return this.mDragHelper.shouldInterceptTouchEvent(ev);
    }

    private View childNeedHandleTouchEvent(ViewGroup v, MotionEvent event) {
        if (v == null) {
            return null;
        }
        if (v.onTouchEvent(event)) {
            return v;
        }
        int childCount = v.getChildCount();
        for (int i = childCount - 1; i >= 0; --i) {
            View child = v.getChildAt(i);
            if (child instanceof ViewGroup) {
                View grandChild = this.childNeedHandleTouchEvent((ViewGroup)child, event);
                if (grandChild == null) continue;
                return grandChild;
            }
            if (!this.childNeedHandleTouchEvent(v.getChildAt(i), event)) continue;
            return v.getChildAt(i);
        }
        return null;
    }

    private boolean childNeedHandleTouchEvent(View v, MotionEvent event) {
        if (v == null) {
            return false;
        }
        int[] loc = new int[2];
        v.getLocationOnScreen(loc);
        int left = loc[0];
        int top = loc[1];
        if (event.getRawX() > (float)left && event.getRawX() < (float)(left + v.getWidth()) && event.getRawY() > (float)top && event.getRawY() < (float)(top + v.getHeight())) {
            return v.onTouchEvent(event);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        if (!this.isEnabledInAdapterView() || !this.isEnabled()) {
            return true;
        }
        if (!this.isSwipeEnabled()) {
            return super.onTouchEvent(event);
        }
        int action = event.getActionMasked();
        ViewParent parent = this.getParent();
        this.gestureDetector.onTouchEvent(event);
        Status status = this.getOpenStatus();
        ViewGroup touching = null;
        if (status == Status.Close) {
            touching = this.getSurfaceView();
        } else if (status == Status.Open) {
            touching = this.getBottomView();
        }
        switch (action) {
            case 0: {
                this.mDragHelper.processTouchEvent(event);
                parent.requestDisallowInterceptTouchEvent(true);
                this.sX = event.getRawX();
                this.sY = event.getRawY();
                if (touching != null) {
                    touching.setPressed(true);
                }
                return true;
            }
            case 2: {
                boolean suitable;
                float distanceX = event.getRawX() - this.sX;
                float distanceY = event.getRawY() - this.sY;
                float angle = Math.abs(distanceY / distanceX);
                angle = (float)Math.toDegrees(Math.atan(angle));
                boolean doNothing = false;
                if (this.mDragEdge == DragEdge.Right) {
                    suitable = status == Status.Open && distanceX > 0.0f || status == Status.Close && distanceX < 0.0f;
                    boolean bl = suitable = suitable || status == Status.Middle;
                    if (angle > 30.0f || !suitable) {
                        doNothing = true;
                    }
                }
                if (this.mDragEdge == DragEdge.Left) {
                    suitable = status == Status.Open && distanceX < 0.0f || status == Status.Close && distanceX > 0.0f;
                    boolean bl = suitable = suitable || status == Status.Middle;
                    if (angle > 30.0f || !suitable) {
                        doNothing = true;
                    }
                }
                if (this.mDragEdge == DragEdge.Top) {
                    suitable = status == Status.Open && distanceY < 0.0f || status == Status.Close && distanceY > 0.0f;
                    boolean bl = suitable = suitable || status == Status.Middle;
                    if (angle < 60.0f || !suitable) {
                        doNothing = true;
                    }
                }
                if (this.mDragEdge == DragEdge.Bottom) {
                    suitable = status == Status.Open && distanceY > 0.0f || status == Status.Close && distanceY < 0.0f;
                    boolean bl = suitable = suitable || status == Status.Middle;
                    if (angle < 60.0f || !suitable) {
                        doNothing = true;
                    }
                }
                if (doNothing) {
                    parent.requestDisallowInterceptTouchEvent(false);
                    return false;
                }
                if (touching != null) {
                    touching.setPressed(false);
                }
                parent.requestDisallowInterceptTouchEvent(true);
                this.mDragHelper.processTouchEvent(event);
                break;
            }
            case 1: 
            case 3: {
                this.sX = -1.0f;
                this.sY = -1.0f;
                if (touching != null) {
                    touching.setPressed(false);
                }
            }
            default: {
                parent.requestDisallowInterceptTouchEvent(true);
                this.mDragHelper.processTouchEvent(event);
            }
        }
        return true;
    }

    private boolean isEnabledInAdapterView() {
        Adapter adapter;
        AdapterView adapterView = this.getAdapterView();
        boolean enable = true;
        if (adapterView != null && (adapter = adapterView.getAdapter()) != null) {
            int p = adapterView.getPositionForView((View)this);
            if (adapter instanceof BaseAdapter) {
                enable = ((BaseAdapter)adapter).isEnabled(p);
            } else if (adapter instanceof ListAdapter) {
                enable = ((ListAdapter)adapter).isEnabled(p);
            }
        }
        return enable;
    }

    public void setSwipeEnabled(boolean enabled) {
        this.mSwipeEnabled = enabled;
    }

    public boolean isSwipeEnabled() {
        return this.mSwipeEnabled;
    }

    private boolean insideAdapterView() {
        return this.getAdapterView() != null;
    }

    private AdapterView getAdapterView() {
        for (ViewParent t = this.getParent(); t != null; t = t.getParent()) {
            if (!(t instanceof AdapterView)) continue;
            return (AdapterView)t;
        }
        return null;
    }

    private void performAdapterViewItemClick(MotionEvent e) {
        for (ViewParent t = this.getParent(); t != null; t = t.getParent()) {
            AdapterView view;
            int p;
            if (!(t instanceof AdapterView ? (p = (view = (AdapterView)t).getPositionForView((View)this)) != -1 && view.performItemClick(view.getChildAt(p - view.getFirstVisiblePosition()), p, view.getAdapter().getItemId(p)) : t instanceof View && ((View)t).performClick())) continue;
            return;
        }
    }

    public void setDragEdge(DragEdge dragEdge) {
        this.mDragEdge = dragEdge;
        this.requestLayout();
    }

    public void setDragDistance(int max) {
        if (max < 0) {
            throw new IllegalArgumentException("Drag distance can not be < 0");
        }
        this.mDragDistance = this.dp2px(max);
        this.requestLayout();
    }

    public void setShowMode(ShowMode mode) {
        this.mShowMode = mode;
        this.requestLayout();
    }

    public DragEdge getDragEdge() {
        return this.mDragEdge;
    }

    public int getDragDistance() {
        return this.mDragDistance;
    }

    public ShowMode getShowMode() {
        return this.mShowMode;
    }

    public ViewGroup getSurfaceView() {
        return (ViewGroup)this.getChildAt(1);
    }

    public ViewGroup getBottomView() {
        return (ViewGroup)this.getChildAt(0);
    }

    public Status getOpenStatus() {
        int surfaceLeft = this.getSurfaceView().getLeft();
        int surfaceTop = this.getSurfaceView().getTop();
        if (surfaceLeft == this.getPaddingLeft() && surfaceTop == this.getPaddingTop()) {
            return Status.Close;
        }
        if (surfaceLeft == this.getPaddingLeft() - this.mDragDistance || surfaceLeft == this.getPaddingLeft() + this.mDragDistance || surfaceTop == this.getPaddingTop() - this.mDragDistance || surfaceTop == this.getPaddingTop() + this.mDragDistance) {
            return Status.Open;
        }
        return Status.Middle;
    }

    private void processSurfaceRelease(float xvel, float yvel) {
        if (xvel == 0.0f && this.getOpenStatus() == Status.Middle) {
            this.close();
        }
        if (this.mDragEdge == DragEdge.Left || this.mDragEdge == DragEdge.Right) {
            if (xvel > 0.0f) {
                if (this.mDragEdge == DragEdge.Left) {
                    this.open();
                } else {
                    this.close();
                }
            }
            if (xvel < 0.0f) {
                if (this.mDragEdge == DragEdge.Left) {
                    this.close();
                } else {
                    this.open();
                }
            }
        } else {
            if (yvel > 0.0f) {
                if (this.mDragEdge == DragEdge.Top) {
                    this.open();
                } else {
                    this.close();
                }
            }
            if (yvel < 0.0f) {
                if (this.mDragEdge == DragEdge.Top) {
                    this.close();
                } else {
                    this.open();
                }
            }
        }
    }

    private void processBottomPullOutRelease(float xvel, float yvel) {
        if (xvel == 0.0f && this.getOpenStatus() == Status.Middle) {
            this.close();
        }
        if (this.mDragEdge == DragEdge.Left || this.mDragEdge == DragEdge.Right) {
            if (xvel > 0.0f) {
                if (this.mDragEdge == DragEdge.Left) {
                    this.open();
                } else {
                    this.close();
                }
            }
            if (xvel < 0.0f) {
                if (this.mDragEdge == DragEdge.Left) {
                    this.close();
                } else {
                    this.open();
                }
            }
        } else {
            if (yvel > 0.0f) {
                if (this.mDragEdge == DragEdge.Top) {
                    this.open();
                } else {
                    this.close();
                }
            }
            if (yvel < 0.0f) {
                if (this.mDragEdge == DragEdge.Top) {
                    this.close();
                } else {
                    this.open();
                }
            }
        }
    }

    private void processBottomLayDownMode(float xvel, float yvel) {
        if (xvel == 0.0f && this.getOpenStatus() == Status.Middle) {
            this.close();
        }
        int l = this.getPaddingLeft();
        int t = this.getPaddingTop();
        if (xvel < 0.0f && this.mDragEdge == DragEdge.Right) {
            l -= this.mDragDistance;
        }
        if (xvel > 0.0f && this.mDragEdge == DragEdge.Left) {
            l += this.mDragDistance;
        }
        if (yvel > 0.0f && this.mDragEdge == DragEdge.Top) {
            t += this.mDragDistance;
        }
        if (yvel < 0.0f && this.mDragEdge == DragEdge.Bottom) {
            t -= this.mDragDistance;
        }
        this.mDragHelper.smoothSlideViewTo((View)this.getSurfaceView(), l, t);
        this.invalidate();
    }

    public void open() {
        this.open(true, true);
    }

    public void open(boolean smooth) {
        this.open(smooth, true);
    }

    public void open(boolean smooth, boolean notify) {
        ViewGroup surface = this.getSurfaceView();
        ViewGroup bottom = this.getBottomView();
        Rect rect = this.computeSurfaceLayoutArea(true);
        if (smooth) {
            this.mDragHelper.smoothSlideViewTo((View)this.getSurfaceView(), rect.left, rect.top);
        } else {
            int dx = rect.left - surface.getLeft();
            int dy = rect.top - surface.getTop();
            surface.layout(rect.left, rect.top, rect.right, rect.bottom);
            if (this.getShowMode() == ShowMode.PullOut) {
                Rect bRect = this.computeBottomLayoutAreaViaSurface(ShowMode.PullOut, rect);
                bottom.layout(bRect.left, bRect.top, bRect.right, bRect.bottom);
            }
            if (notify) {
                this.dispatchRevealEvent(rect.left, rect.top, rect.right, rect.bottom);
                this.dispatchSwipeEvent(rect.left, rect.top, dx, dy);
            } else {
                this.safeBottomView();
            }
        }
        this.invalidate();
    }

    public void close() {
        this.close(true, true);
    }

    public void close(boolean smooth) {
        this.close(smooth, true);
    }

    public void close(boolean smooth, boolean notify) {
        ViewGroup surface = this.getSurfaceView();
        if (smooth) {
            this.mDragHelper.smoothSlideViewTo((View)this.getSurfaceView(), this.getPaddingLeft(), this.getPaddingTop());
        } else {
            Rect rect = this.computeSurfaceLayoutArea(false);
            int dx = rect.left - surface.getLeft();
            int dy = rect.top - surface.getTop();
            surface.layout(rect.left, rect.top, rect.right, rect.bottom);
            if (notify) {
                this.dispatchRevealEvent(rect.left, rect.top, rect.right, rect.bottom);
                this.dispatchSwipeEvent(rect.left, rect.top, dx, dy);
            } else {
                this.safeBottomView();
            }
        }
        this.invalidate();
    }

    public void toggle() {
        this.toggle(true);
    }

    public void toggle(boolean smooth) {
        if (this.getOpenStatus() == Status.Open) {
            this.close(smooth);
        } else if (this.getOpenStatus() == Status.Close) {
            this.open(smooth);
        }
    }

    private Rect computeSurfaceLayoutArea(boolean open) {
        int l = this.getPaddingLeft();
        int t = this.getPaddingTop();
        if (open) {
            if (this.mDragEdge == DragEdge.Left) {
                l = this.getPaddingLeft() + this.mDragDistance;
            } else if (this.mDragEdge == DragEdge.Right) {
                l = this.getPaddingLeft() - this.mDragDistance;
            } else {
                t = this.mDragEdge == DragEdge.Top ? this.getPaddingTop() + this.mDragDistance : this.getPaddingTop() - this.mDragDistance;
            }
        }
        return new Rect(l, t, l + this.getMeasuredWidth(), t + this.getMeasuredHeight());
    }

    private Rect computeBottomLayoutAreaViaSurface(ShowMode mode, Rect surfaceArea) {
        Rect rect = surfaceArea;
        int bl = rect.left;
        int bt = rect.top;
        int br = rect.right;
        int bb = rect.bottom;
        if (mode == ShowMode.PullOut) {
            if (this.mDragEdge == DragEdge.Left) {
                bl = rect.left - this.mDragDistance;
            } else if (this.mDragEdge == DragEdge.Right) {
                bl = rect.right;
            } else {
                bt = this.mDragEdge == DragEdge.Top ? rect.top - this.mDragDistance : rect.bottom;
            }
            if (this.mDragEdge == DragEdge.Left || this.mDragEdge == DragEdge.Right) {
                bb = rect.bottom;
                br = bl + this.getBottomView().getMeasuredWidth();
            } else {
                bb = bt + this.getBottomView().getMeasuredHeight();
                br = rect.right;
            }
        } else if (mode == ShowMode.LayDown) {
            if (this.mDragEdge == DragEdge.Left) {
                br = bl + this.mDragDistance;
            } else if (this.mDragEdge == DragEdge.Right) {
                bl = br - this.mDragDistance;
            } else if (this.mDragEdge == DragEdge.Top) {
                bb = bt + this.mDragDistance;
            } else {
                bt = bb - this.mDragDistance;
            }
        }
        return new Rect(bl, bt, br, bb);
    }

    private Rect computeBottomLayDown(DragEdge dragEdge) {
        int bb;
        int br;
        int bl = this.getPaddingLeft();
        int bt = this.getPaddingTop();
        if (dragEdge == DragEdge.Right) {
            bl = this.getMeasuredWidth() - this.mDragDistance;
        } else if (dragEdge == DragEdge.Bottom) {
            bt = this.getMeasuredHeight() - this.mDragDistance;
        }
        if (dragEdge == DragEdge.Left || dragEdge == DragEdge.Right) {
            br = bl + this.mDragDistance;
            bb = bt + this.getMeasuredHeight();
        } else {
            br = bl + this.getMeasuredWidth();
            bb = bt + this.mDragDistance;
        }
        return new Rect(bl, bt, br, bb);
    }

    public void setOnDoubleClickListener(DoubleClickListener doubleClickListener) {
        this.mDoubleClickListener = doubleClickListener;
    }

    private int dp2px(float dp) {
        return (int)(dp * this.getContext().getResources().getDisplayMetrics().density + 0.5f);
    }

    public static interface DoubleClickListener {
        public void onDoubleClick(SwipeLayout var1, boolean var2);
    }

    public static enum Status {
        Middle,
        Open,
        Close;

    }

    class SwipeDetector
    extends GestureDetector.SimpleOnGestureListener {
        SwipeDetector() {
        }

        public boolean onDown(MotionEvent e) {
            return true;
        }

        public boolean onSingleTapUp(MotionEvent e) {
            if (SwipeLayout.this.mDoubleClickListener == null) {
                SwipeLayout.this.performAdapterViewItemClick(e);
            }
            return true;
        }

        public boolean onSingleTapConfirmed(MotionEvent e) {
            if (SwipeLayout.this.mDoubleClickListener != null) {
                SwipeLayout.this.performAdapterViewItemClick(e);
            }
            return true;
        }

        public void onLongPress(MotionEvent e) {
            SwipeLayout.this.performLongClick();
        }

        public boolean onDoubleTap(MotionEvent e) {
            if (SwipeLayout.this.mDoubleClickListener != null) {
                ViewGroup bottom = SwipeLayout.this.getBottomView();
                ViewGroup surface = SwipeLayout.this.getSurfaceView();
                ViewGroup target = e.getX() > (float)bottom.getLeft() && e.getX() < (float)bottom.getRight() && e.getY() > (float)bottom.getTop() && e.getY() < (float)bottom.getBottom() ? bottom : surface;
                SwipeLayout.this.mDoubleClickListener.onDoubleClick(SwipeLayout.this, target == surface);
            }
            return true;
        }
    }

    public static interface OnLayout {
        public void onLayout(SwipeLayout var1);
    }

    public static interface OnRevealListener {
        public void onReveal(View var1, DragEdge var2, float var3, int var4);
    }

    public static interface SwipeDenier {
        public boolean shouldDenySwipe(MotionEvent var1);
    }

    public static interface SwipeListener {
        public void onStartOpen(SwipeLayout var1);

        public void onOpen(SwipeLayout var1);

        public void onStartClose(SwipeLayout var1);

        public void onClose(SwipeLayout var1);

        public void onUpdate(SwipeLayout var1, int var2, int var3);

        public void onHandRelease(SwipeLayout var1, float var2, float var3);
    }

    public static enum ShowMode {
        LayDown,
        PullOut;

    }

    public static enum DragEdge {
        Left,
        Right,
        Top,
        Bottom;

    }
}

