/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.spring;

import com.github.dadiyang.httpinvoker.annotation.HttpApi;
import com.github.dadiyang.httpinvoker.propertyresolver.PropertyResolver;
import com.github.dadiyang.httpinvoker.requestor.RequestPreprocessor;
import com.github.dadiyang.httpinvoker.requestor.Requestor;
import com.github.dadiyang.httpinvoker.requestor.ResponseProcessor;
import com.github.dadiyang.httpinvoker.spring.HttpApiProxyFactoryBean;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Set;
import org.springframework.beans.factory.FactoryBean;
import org.springframework.beans.factory.annotation.AnnotatedBeanDefinition;
import org.springframework.beans.factory.config.BeanDefinition;
import org.springframework.beans.factory.config.BeanDefinitionHolder;
import org.springframework.beans.factory.support.BeanDefinitionRegistry;
import org.springframework.beans.factory.support.BeanNameGenerator;
import org.springframework.beans.factory.support.DefaultBeanNameGenerator;
import org.springframework.beans.factory.support.DefaultListableBeanFactory;
import org.springframework.beans.factory.support.GenericBeanDefinition;
import org.springframework.context.annotation.ClassPathBeanDefinitionScanner;
import org.springframework.core.type.filter.AnnotationTypeFilter;
import org.springframework.core.type.filter.TypeFilter;

public class ClassPathHttpApiScanner
extends ClassPathBeanDefinitionScanner {
    private static final String HTTP_API_PREFIX = "$HttpApi$";
    private Class<? extends FactoryBean> factoryBean;
    private Class<? extends Annotation> includeAnn;
    private PropertyResolver propertyResolver;
    private Requestor requestor;
    private RequestPreprocessor requestPreprocessor;
    private ResponseProcessor responseProcessor;
    private BeanDefinitionRegistry registry;

    public ClassPathHttpApiScanner(BeanDefinitionRegistry registry, PropertyResolver propertyResolver, Requestor requestor, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        super(registry, false);
        this.setBeanNameGenerator((BeanNameGenerator)new DefaultBeanNameGenerator());
        this.registry = registry;
        this.propertyResolver = propertyResolver;
        this.factoryBean = HttpApiProxyFactoryBean.class;
        this.includeAnn = HttpApi.class;
        this.addIncludeFilter((TypeFilter)new AnnotationTypeFilter(this.includeAnn));
        this.requestor = requestor;
        this.requestPreprocessor = requestPreprocessor;
        this.responseProcessor = responseProcessor;
    }

    public Set<BeanDefinitionHolder> doScan(String ... basePackages) {
        Set beanDefinitions = super.doScan(basePackages);
        if (beanDefinitions.isEmpty()) {
            this.logger.warn((Object)("No " + this.includeAnn.getSimpleName() + " was found in '" + Arrays.toString(basePackages) + "' package. Please check your configuration."));
        }
        return beanDefinitions;
    }

    protected boolean isCandidateComponent(AnnotatedBeanDefinition beanDefinition) {
        return beanDefinition.getMetadata().isInterface() && beanDefinition.getMetadata().isIndependent();
    }

    protected boolean checkCandidate(String beanName, BeanDefinition beanDefinition) {
        if (this.registry.containsBeanDefinition(beanName)) {
            if (this.isHttpApiBean(beanName)) {
                this.logger.info((Object)("an HttpApi bean [" + beanName + "] exists, we ignore the others"));
                return false;
            }
            this.logger.warn((Object)("an not HttpApi bean named [" + beanName + "] exists, we remove it, so that we can generate a new bean."));
            this.registry.removeBeanDefinition(beanName);
        }
        if (super.checkCandidate(beanName, beanDefinition)) {
            return true;
        }
        this.logger.warn((Object)("Skipping " + this.factoryBean.getSimpleName() + " with name '" + beanName + "' and '" + beanDefinition.getBeanClassName() + "' interface. Bean already defined with the same name!"));
        return false;
    }

    private boolean isHttpApiBean(String beanName) {
        if (this.registry instanceof DefaultListableBeanFactory) {
            DefaultListableBeanFactory beanFactory = (DefaultListableBeanFactory)this.registry;
            return beanFactory.containsBean(beanName) && beanFactory.getBean(beanName).toString().startsWith(HTTP_API_PREFIX);
        }
        return false;
    }

    protected void registerBeanDefinition(BeanDefinitionHolder holder, BeanDefinitionRegistry registry) {
        GenericBeanDefinition definition = (GenericBeanDefinition)holder.getBeanDefinition();
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)(this.includeAnn.getSimpleName() + ": Bean with name '" + holder.getBeanName() + "' and '" + definition.getBeanClassName() + "' interface"));
        }
        if (this.logger.isDebugEnabled()) {
            this.logger.debug((Object)("Enabling autowire by type for " + this.factoryBean.getSimpleName() + " with name '" + holder.getBeanName() + "'."));
        }
        definition.setAutowireMode(2);
        definition.getPropertyValues().add("interfaceClass", (Object)definition.getBeanClassName());
        definition.getPropertyValues().add("propertyResolver", (Object)this.propertyResolver);
        if (this.requestor != null) {
            definition.getPropertyValues().add("requestor", (Object)this.requestor);
        }
        if (this.requestPreprocessor != null) {
            definition.getPropertyValues().add("requestPreprocessor", (Object)this.requestPreprocessor);
        }
        if (this.responseProcessor != null) {
            definition.getPropertyValues().add("responseProcessor", (Object)this.responseProcessor);
        }
        String beanName = holder.getBeanName();
        definition.setBeanClass(this.factoryBean);
        registry.registerBeanDefinition(beanName, (BeanDefinition)definition);
    }
}

