/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.requestor;

import com.alibaba.fastjson.JSON;
import com.github.dadiyang.httpinvoker.requestor.HttpRequest;
import com.github.dadiyang.httpinvoker.requestor.HttpResponse;
import com.github.dadiyang.httpinvoker.requestor.JsoupHttpResponse;
import com.github.dadiyang.httpinvoker.requestor.MultiPart;
import com.github.dadiyang.httpinvoker.requestor.Requestor;
import com.github.dadiyang.httpinvoker.util.ObjectUtils;
import com.github.dadiyang.httpinvoker.util.ParamUtils;
import java.io.IOException;
import java.util.Map;
import org.jsoup.Connection;
import org.jsoup.Jsoup;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JsoupRequestor
implements Requestor {
    private static final Logger log = LoggerFactory.getLogger(JsoupRequestor.class);
    private static final String CONTENT_TYPE = "Content-Type";
    private static final String APPLICATION_JSON = "application/json";

    @Override
    public HttpResponse sendRequest(HttpRequest request) throws IOException {
        Connection.Response response;
        Connection.Method m = Connection.Method.valueOf((String)request.getMethod().toUpperCase());
        String url = request.getUrl();
        int timeout = request.getTimeout();
        if (!m.hasBody()) {
            String qs = ParamUtils.toQueryString(request.getData());
            String fullUrl = request.getUrl() + qs;
            log.debug("send {} request to {}", (Object)m, (Object)fullUrl);
            Connection conn = Jsoup.connect((String)fullUrl).method(m).timeout(timeout).maxBodySize(0).ignoreContentType(true).ignoreHttpErrors(true);
            this.addHeadersAndCookies(request, conn);
            this.setContentType(request, conn);
            response = conn.execute();
        } else {
            Connection conn = Jsoup.connect((String)url).method(m).timeout(timeout).maxBodySize(0).ignoreContentType(true).ignoreHttpErrors(true);
            this.addHeadersAndCookies(request, conn);
            this.setContentType(request, conn);
            Map<String, Object> data = request.getData();
            if (request.getBody() != null) {
                Object bodyParam = request.getBody();
                if (ParamUtils.isUploadRequest(bodyParam)) {
                    log.debug("upload file {} request to {} ", (Object)m, (Object)url);
                    response = this.uploadFile(request);
                } else if (this.useJson(request, bodyParam)) {
                    response = conn.requestBody(JSON.toJSONString((Object)bodyParam)).execute();
                } else {
                    Map<String, String> map = ParamUtils.toMapStringString(bodyParam, "");
                    response = conn.data(map).execute();
                }
            } else if (data == null || data.isEmpty()) {
                log.debug("send {} request to {}", (Object)m, (Object)url);
                response = conn.execute();
            } else if (this.useJson(request, data)) {
                if (m == Connection.Method.PATCH) {
                    conn.method(Connection.Method.POST).header("X-HTTP-Method-Override", "PATCH");
                }
                response = conn.requestBody(JSON.toJSONString(data)).execute();
            } else {
                Map<String, String> map = ParamUtils.toMapStringString(data, "");
                response = conn.data(map).execute();
            }
        }
        return new JsoupHttpResponse(response);
    }

    private void setContentType(HttpRequest request, Connection conn) {
        if (request.getHeaders() == null || !request.getHeaders().containsKey(CONTENT_TYPE)) {
            conn.header(CONTENT_TYPE, APPLICATION_JSON);
        }
    }

    private boolean useJson(HttpRequest request, Object param) {
        return ParamUtils.isCollection(param) || request.getHeaders() == null || !request.getHeaders().containsKey(CONTENT_TYPE) || ObjectUtils.equals(request.getHeaders().get(CONTENT_TYPE), APPLICATION_JSON);
    }

    private void addHeadersAndCookies(HttpRequest request, Connection conn) {
        if (request.getHeaders() != null) {
            conn.headers(request.getHeaders());
        }
        if (request.getCookies() != null) {
            conn.cookies(request.getCookies());
        }
    }

    private Connection.Response uploadFile(HttpRequest request) throws IOException {
        Connection conn = Jsoup.connect((String)request.getUrl());
        conn.method(Connection.Method.POST).timeout(request.getTimeout()).ignoreHttpErrors(true).maxBodySize(0).ignoreContentType(true);
        this.addHeadersAndCookies(request, conn);
        Object body = request.getBody();
        if (body instanceof MultiPart) {
            return this.handleMultiPart(conn, (MultiPart)body);
        }
        return this.handleMultiPart(conn, ParamUtils.convertInputStreamAndFile(request));
    }

    private Connection.Response handleMultiPart(Connection conn, MultiPart body) throws IOException {
        for (MultiPart.Part part : body.getParts()) {
            if (part.getKey() == null || part.getValue() == null) {
                throw new IllegalArgumentException("both key and value of part must not be null");
            }
            if (part.getInputStream() != null) {
                conn.data(part.getKey(), part.getValue(), part.getInputStream());
                continue;
            }
            conn.data(part.getKey(), part.getValue());
        }
        return conn.execute();
    }
}

