/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.requestor;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.parser.Feature;
import com.github.dadiyang.httpinvoker.requestor.HttpResponse;
import com.github.dadiyang.httpinvoker.requestor.ResponseProcessor;
import com.github.dadiyang.httpinvoker.util.ObjectUtils;
import java.io.BufferedInputStream;
import java.lang.reflect.Method;

public class DefaultResponseProcessor
implements ResponseProcessor {
    @Override
    public Object process(HttpResponse response, Method method) {
        if (ObjectUtils.equals(method.getReturnType(), Void.class) || ObjectUtils.equals(method.getReturnType(), Void.TYPE)) {
            return null;
        }
        String body = response.getBody();
        if (body == null || body.trim().isEmpty()) {
            return null;
        }
        if (method.getReturnType() == Object.class) {
            return response.getBody();
        }
        if (method.getReturnType() == String.class || method.getReturnType() == CharSequence.class) {
            return body;
        }
        if (method.getReturnType() == byte[].class) {
            return response.getBodyAsBytes();
        }
        if (method.getReturnType().isAssignableFrom(BufferedInputStream.class)) {
            return response.getBodyStream();
        }
        if (method.getReturnType().isAssignableFrom(response.getClass())) {
            return response;
        }
        Class<?> type = method.getGenericReturnType();
        type = type == null ? method.getReturnType() : type;
        return JSON.parseObject((byte[])response.getBodyAsBytes(), type, (Feature[])new Feature[0]);
    }
}

