/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker.mocker;

import com.github.dadiyang.httpinvoker.mocker.MockRule;
import com.github.dadiyang.httpinvoker.requestor.DefaultHttpRequestor;
import com.github.dadiyang.httpinvoker.requestor.HttpRequest;
import com.github.dadiyang.httpinvoker.requestor.HttpResponse;
import com.github.dadiyang.httpinvoker.requestor.Requestor;
import com.github.dadiyang.httpinvoker.util.ObjectUtils;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MockRequestor
implements Requestor {
    private static final Logger log = LoggerFactory.getLogger(MockRequestor.class);
    private boolean ignoreWarning;
    private final List<MockRule> mockRules;
    private final Requestor realRequestor;

    public MockRequestor() {
        this(new ArrayList<MockRule>(), new DefaultHttpRequestor());
    }

    public MockRequestor(List<MockRule> mockRules, Requestor realRequestor) {
        if (realRequestor == null) {
            throw new IllegalArgumentException("\u5fc5\u987b\u914d\u7f6e\u4e00\u4e2a\u771f\u5b9e\u8bf7\u6c42\u7684\u8bf7\u6c42\u5668");
        }
        this.mockRules = mockRules;
        this.realRequestor = realRequestor;
        log.info("\u521d\u59cb\u5316 MOCK \u8bf7\u6c42\u5668\uff0c\u6ce8\u610f\uff1a\u4e00\u822c\u53ea\u7528\u4e8e\u5f00\u53d1\u73af\u5883\u4f7f\u7528\uff0c\u751f\u4ea7\u73af\u5883\u5343\u4e07\u4e0d\u8981\u4f7f\u7528\u6b64\u8bf7\u6c42\u5668\uff01\uff01");
    }

    public MockRequestor(List<MockRule> mockRules) {
        this(new ArrayList<MockRule>(mockRules), new DefaultHttpRequestor());
    }

    public void addRule(MockRule rule) {
        this.mockRules.add(rule);
    }

    @Override
    public HttpResponse sendRequest(HttpRequest request) throws IOException {
        ObjectUtils.requireNonNull(request, "\u8bf7\u6c42\u4e0d\u80fd\u4e3a null");
        ObjectUtils.requireNonNull(request.getUrl(), "\u8bf7\u6c42 url \u4e0d\u80fd\u4e3a null");
        if (!this.ignoreWarning) {
            log.warn("\u5f53\u524d\u4f7f\u7528 MOCK \u8bf7\u6c42\u5668\uff0c\u6ce8\u610f\uff1a\u4e00\u822c\u53ea\u5728\u5f00\u53d1\u73af\u5883\u4f7f\u7528\uff0c\u751f\u4ea7\u73af\u5883\u5343\u4e07\u4e0d\u8981\u4f7f\u7528\u6b64\u8bf7\u6c42\u5668\uff01\uff01");
        }
        LinkedList<MockRule> matchedRule = new LinkedList<MockRule>();
        for (MockRule rule : this.mockRules) {
            if (!this.isMatch(request, rule)) continue;
            matchedRule.add(rule);
        }
        if (matchedRule.isEmpty()) {
            log.info("\u8bf7\u6c42\u6ca1\u6709\u627e\u5230\u5bf9\u5e94\u7684 mock\uff0c\u6240\u4ee5\u53d1\u8d77\u771f\u5b9e\u8bf7\u6c42: " + request.getUrl());
            return this.realRequestor.sendRequest(request);
        }
        if (matchedRule.size() > 1) {
            LinkedList<MockRule> exactlyMatches = new LinkedList<MockRule>();
            for (MockRule rule : matchedRule) {
                if (!ObjectUtils.equals(rule.getUrlReg(), request.getUrl()) && !ObjectUtils.equals(rule.getUriReg(), this.getUri(request.getUrl()))) continue;
                exactlyMatches.add(rule);
            }
            matchedRule = exactlyMatches;
            if (matchedRule.size() > 1) {
                throw new IllegalStateException("\u4e00\u4e2a\u8bf7\u6c42\u5339\u914d\u5230 " + matchedRule.size() + " \u4e2a mock \u89c4\u5219\uff0c\u8bf7\u786e\u8ba4\u662f\u5426\u91cd\u590d\u6dfb\u52a0: " + request.getUrl());
            }
        }
        MockRule rule = (MockRule)matchedRule.get(0);
        log.info("mock\u5339\u914d\u6210\u529f\uff0c\u4f7f\u7528\u5339\u914d\u5230\u7684\u89c4\u5219\uff0c\u8bf7\u6c42url: " + request.getUrl() + ", \u89c4\u5219: " + rule);
        return rule.getResponse();
    }

    private String getUri(String url) {
        try {
            return new URL(url).getPath();
        }
        catch (MalformedURLException e) {
            return url;
        }
    }

    private boolean isMatch(HttpRequest request, MockRule rule) {
        if (rule == null) {
            return false;
        }
        if (rule.getMethod() != null && !rule.getMethod().isEmpty() && !ObjectUtils.equals(request.getMethod().toUpperCase(), rule.getMethod().toUpperCase())) {
            log.info("\u8bf7\u6c42\u65b9\u6cd5\u89c4\u5219\u4e0d\u5339\u914d: requestMethod: " + request.getMethod() + ", ruleMethod: " + rule.getMethod());
            return false;
        }
        if (!this.isUrlOrUriMatch(request, rule)) {
            return false;
        }
        if (!this.isMapMatch(rule.getData(), request.getData())) {
            log.info("\u53c2\u6570\u89c4\u5219\u4e0d\u5339\u914d: requestData: " + request.getData() + ", ruleData: " + rule.getData());
            return false;
        }
        if (!ObjectUtils.equals(rule.getBody(), request.getBody())) {
            log.info("\u8bf7\u6c42\u4f53\u89c4\u5219\u4e0d\u5339\u914d: requestBody: " + request.getBody() + ", ruleBody: " + rule.getBody());
            return false;
        }
        if (!this.isMapMatch(rule.getCookies(), request.getCookies())) {
            log.info("Cookie\u89c4\u5219\u4e0d\u5339\u914d: requestCookies: " + request.getCookies() + ", ruleCookies: " + rule.getCookies());
            return false;
        }
        if (!this.isMapMatch(rule.getHeaders(), request.getHeaders())) {
            log.info("Header\u89c4\u5219\u4e0d\u5339\u914d: requestHeaders: " + request.getHeaders() + ", ruleHeaders: " + rule.getHeaders());
            return false;
        }
        return true;
    }

    private boolean isUrlOrUriMatch(HttpRequest request, MockRule m) {
        if (m.getUrlReg() != null && !m.getUrlReg().isEmpty()) {
            boolean urlMatch = this.isStringMatch(request.getUrl(), m.getUrlReg());
            if (!urlMatch) {
                log.info("url\u89c4\u5219\u4e0d\u5339\u914d: requestUrl: " + request.getUrl() + ", ruleUrl: " + m.getUrlReg());
                return false;
            }
        } else if (m.getUriReg() != null && !m.getUriReg().isEmpty()) {
            String uri = this.getUri(request.getUrl());
            boolean uriMatch = this.isStringMatch(uri, m.getUriReg());
            if (!uriMatch) {
                log.info("uri \u89c4\u5219\u4e0d\u5339\u914d: requestUri: " + uri + ", ruleUri: " + m.getUriReg());
                return false;
            }
        } else {
            log.info("url \u548c uri \u89c4\u5219\u4e0d\u80fd\u540c\u65f6\u4e3a\u7a7a\u4e0d\u5339\u914d: requestUrl: " + request.getUrl() + ", ruleUrl: " + m.getUrlReg());
            return false;
        }
        return true;
    }

    private boolean isStringMatch(String uri, String urlReg) {
        return ObjectUtils.equals(uri, urlReg) || uri.matches(urlReg);
    }

    private boolean isMapMatch(Map<String, ?> mapFromMockRule, Map<String, ?> mapFromRequest) {
        if (mapFromMockRule == null || mapFromMockRule.isEmpty()) {
            return true;
        }
        if (mapFromRequest == null || mapFromRequest.isEmpty()) {
            return false;
        }
        for (Map.Entry<String, ?> entry : mapFromMockRule.entrySet()) {
            Object value = mapFromRequest.get(entry.getKey());
            if (ObjectUtils.equals(entry.getValue(), value)) continue;
            return false;
        }
        return true;
    }

    public void setIgnoreWarning(boolean ignoreWarning) {
        this.ignoreWarning = ignoreWarning;
    }
}

