/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker;

import com.github.dadiyang.httpinvoker.HttpApiInvoker;
import com.github.dadiyang.httpinvoker.propertyresolver.EnvironmentBasePropertyResolver;
import com.github.dadiyang.httpinvoker.propertyresolver.MultiSourcePropertyResolver;
import com.github.dadiyang.httpinvoker.propertyresolver.PropertiesBasePropertyResolver;
import com.github.dadiyang.httpinvoker.propertyresolver.PropertyResolver;
import com.github.dadiyang.httpinvoker.requestor.DefaultHttpRequestor;
import com.github.dadiyang.httpinvoker.requestor.RequestPreprocessor;
import com.github.dadiyang.httpinvoker.requestor.Requestor;
import com.github.dadiyang.httpinvoker.requestor.ResponseProcessor;
import com.github.dadiyang.httpinvoker.util.IoUtils;
import com.github.dadiyang.httpinvoker.util.ObjectUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Proxy;
import java.util.Map;
import java.util.Properties;
import java.util.concurrent.ConcurrentHashMap;
import org.springframework.core.env.Environment;

public class HttpApiProxyFactory {
    private Map<Class<?>, Object> instances = new ConcurrentHashMap();
    private Requestor requestor;
    private PropertyResolver propertyResolver;
    private RequestPreprocessor requestPreprocessor;
    private ResponseProcessor responseProcessor;

    public HttpApiProxyFactory() {
        this((Requestor)new DefaultHttpRequestor(), System.getProperties());
    }

    public HttpApiProxyFactory(Requestor requestor) {
        this(requestor, System.getProperties());
    }

    public HttpApiProxyFactory(Properties properties) {
        this((Requestor)new DefaultHttpRequestor(), properties);
    }

    public HttpApiProxyFactory(Requestor requestor, Properties properties) {
        this(requestor, properties, null);
    }

    public HttpApiProxyFactory(Properties properties, RequestPreprocessor requestPreprocessor) {
        this(null, properties, requestPreprocessor);
    }

    public HttpApiProxyFactory(Properties properties, ResponseProcessor responseProcessor) {
        this(properties, null, responseProcessor);
    }

    public HttpApiProxyFactory(Properties properties, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        this(null, properties, requestPreprocessor, responseProcessor);
    }

    public HttpApiProxyFactory(RequestPreprocessor requestPreprocessor) {
        this(requestPreprocessor, null);
    }

    public HttpApiProxyFactory(ResponseProcessor responseProcessor) {
        this(System.getProperties(), responseProcessor);
    }

    public HttpApiProxyFactory(RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        this(System.getProperties(), requestPreprocessor, responseProcessor);
    }

    public HttpApiProxyFactory(PropertyResolver propertyResolver) {
        this((Requestor)new DefaultHttpRequestor(), propertyResolver);
    }

    public HttpApiProxyFactory(Requestor requestor, PropertyResolver propertyResolver) {
        this(requestor, propertyResolver, null);
    }

    public HttpApiProxyFactory(PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor) {
        this(null, propertyResolver, requestPreprocessor);
    }

    public HttpApiProxyFactory(PropertyResolver propertyResolver, ResponseProcessor responseProcessor) {
        this(null, propertyResolver, null, responseProcessor);
    }

    public HttpApiProxyFactory(PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        this(null, propertyResolver, requestPreprocessor, responseProcessor);
    }

    public HttpApiProxyFactory(Requestor requestor, Properties properties, RequestPreprocessor requestPreprocessor) {
        this(requestor, properties, requestPreprocessor, null);
    }

    public HttpApiProxyFactory(Requestor requestor, Properties properties, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        this(requestor, properties == null ? null : new PropertiesBasePropertyResolver(properties), requestPreprocessor, responseProcessor);
    }

    public HttpApiProxyFactory(Requestor requestor, PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor) {
        this(requestor, propertyResolver, requestPreprocessor, null);
    }

    public HttpApiProxyFactory(Requestor requestor, PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        this.requestor = requestor;
        this.propertyResolver = propertyResolver == null ? new PropertiesBasePropertyResolver(System.getProperties()) : propertyResolver;
        this.requestPreprocessor = requestPreprocessor;
        this.responseProcessor = responseProcessor;
    }

    public static <T> T newProxy(Class<T> clazz) {
        return HttpApiProxyFactory.newProxy(clazz, System.getProperties());
    }

    public static <T> T newProxy(Class<T> clazz, Properties properties) {
        return HttpApiProxyFactory.newProxy(clazz, null, properties);
    }

    public static <T> T newProxy(Class<T> clazz, RequestPreprocessor requestPreprocessor) {
        return HttpApiProxyFactory.newProxy(clazz, System.getProperties(), requestPreprocessor);
    }

    public static <T> T newProxy(Class<T> clazz, Requestor requestor) {
        return HttpApiProxyFactory.newProxy(clazz, requestor, System.getProperties());
    }

    public static <T> T newProxy(Class<T> clazz, Requestor requestor, Properties properties) {
        return HttpApiProxyFactory.newProxy(clazz, requestor, properties, null);
    }

    public static <T> T newProxy(Class<T> clazz, Properties properties, RequestPreprocessor requestPreprocessor) {
        return HttpApiProxyFactory.newProxy(clazz, null, properties, requestPreprocessor);
    }

    public static <T> T newProxy(Class<T> clazz, Requestor requestor, Properties properties, RequestPreprocessor requestPreprocessor) {
        return HttpApiProxyFactory.newProxyInstance(requestor, properties, clazz, requestPreprocessor, null);
    }

    public static <T> T newProxy(Class<T> clazz, Requestor requestor, Properties properties, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        return HttpApiProxyFactory.newProxyInstance(requestor, properties, clazz, requestPreprocessor, responseProcessor);
    }

    public static <T> T newProxy(Class<T> clazz, PropertyResolver propertyResolver) {
        return HttpApiProxyFactory.newProxy(clazz, null, propertyResolver);
    }

    public static <T> T newProxy(Class<T> clazz, Requestor requestor, PropertyResolver propertyResolver) {
        return HttpApiProxyFactory.newProxy(clazz, requestor, propertyResolver, null);
    }

    public static <T> T newProxy(Class<T> clazz, PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor) {
        return HttpApiProxyFactory.newProxy(clazz, null, propertyResolver, requestPreprocessor);
    }

    public static <T> T newProxy(Class<T> clazz, PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        return HttpApiProxyFactory.newProxy(clazz, null, propertyResolver, requestPreprocessor, responseProcessor);
    }

    public static <T> T newProxy(Class<T> clazz, PropertyResolver propertyResolver, ResponseProcessor responseProcessor) {
        return HttpApiProxyFactory.newProxy(clazz, null, propertyResolver, null, responseProcessor);
    }

    public static <T> T newProxy(Class<T> clazz, ResponseProcessor responseProcessor) {
        return HttpApiProxyFactory.newProxy(clazz, null, new PropertiesBasePropertyResolver(System.getProperties()), null, responseProcessor);
    }

    public static <T> T newProxy(Class<T> clazz, Requestor requestor, PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor) {
        return HttpApiProxyFactory.newProxyInstance(requestor, propertyResolver, clazz, requestPreprocessor, null);
    }

    public static <T> T newProxy(Class<T> clazz, Requestor requestor, PropertyResolver propertyResolver, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        return HttpApiProxyFactory.newProxyInstance(requestor, propertyResolver, clazz, requestPreprocessor, responseProcessor);
    }

    private static <T> T newProxyInstance(Requestor requestor, PropertyResolver propertyResolver, Class<?> clazz, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        HttpApiInvoker handler = new HttpApiInvoker(requestor, propertyResolver, clazz, requestPreprocessor, responseProcessor);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
    }

    private static <T> T newProxyInstance(Requestor requestor, Properties properties, Class<?> clazz, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        HttpApiInvoker handler = new HttpApiInvoker(requestor, properties, clazz, requestPreprocessor, responseProcessor);
        return (T)Proxy.newProxyInstance(clazz.getClassLoader(), new Class[]{clazz}, (InvocationHandler)handler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public <T> T getProxy(Class<T> clazz) {
        if (this.instances.containsKey(clazz)) return (T)this.instances.get(clazz);
        Class<HttpApiProxyFactory> clazz2 = HttpApiProxyFactory.class;
        synchronized (HttpApiProxyFactory.class) {
            if (this.instances.containsKey(clazz)) return (T)this.instances.get(clazz);
            this.instances.put(clazz, HttpApiProxyFactory.newProxyInstance(this.requestor, this.propertyResolver, clazz, this.requestPreprocessor, this.responseProcessor));
            // ** MonitorExit[var2_2] (shouldn't be in output)
            return (T)this.instances.get(clazz);
        }
    }

    public Requestor getRequestor() {
        return this.requestor;
    }

    public PropertyResolver getPropertyResolver() {
        return this.propertyResolver;
    }

    public RequestPreprocessor getRequestPreprocessor() {
        return this.requestPreprocessor;
    }

    public ResponseProcessor getResponseProcessor() {
        return this.responseProcessor;
    }

    public static class Builder {
        private Requestor requestor;
        private MultiSourcePropertyResolver propertyResolvers = new MultiSourcePropertyResolver();
        private RequestPreprocessor requestPreprocessor;
        private ResponseProcessor responseProcessor;

        public Builder setRequestor(Requestor requestor) {
            this.requestor = requestor;
            return this;
        }

        public Builder setRequestPreprocessor(RequestPreprocessor requestPreprocessor) {
            this.requestPreprocessor = requestPreprocessor;
            return this;
        }

        public Builder setResponseProcessor(ResponseProcessor responseProcessor) {
            this.responseProcessor = responseProcessor;
            return this;
        }

        public Builder addPropertyResolver(PropertyResolver propertyResolver) {
            this.propertyResolvers.addPropertyResolver(propertyResolver);
            return this;
        }

        public Builder addProperties(Properties properties) {
            this.propertyResolvers.addPropertyResolver(new PropertiesBasePropertyResolver(properties));
            return this;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Builder addProperties(InputStream in) throws IOException {
            try {
                Properties properties = new Properties();
                properties.load(in);
                Builder builder = this.addProperties(properties);
                return builder;
            }
            finally {
                in.close();
            }
        }

        public Builder addProperties(File file) throws IOException {
            ObjectUtils.requireNonNull(file, "properties file should not be null");
            Properties properties = IoUtils.getPropertiesFromFile(file.getAbsolutePath());
            return this.addProperties(properties);
        }

        public Builder addEnvironment(Environment environment) {
            this.propertyResolvers.addPropertyResolver(new EnvironmentBasePropertyResolver(environment));
            return this;
        }

        public HttpApiProxyFactory build() {
            HttpApiProxyFactory factory = new HttpApiProxyFactory();
            factory.requestor = this.requestor != null ? this.requestor : factory.requestor;
            factory.responseProcessor = this.responseProcessor != null ? this.responseProcessor : factory.responseProcessor;
            factory.requestPreprocessor = this.requestPreprocessor != null ? this.requestPreprocessor : factory.requestPreprocessor;
            this.propertyResolvers.addPropertyResolver(factory.propertyResolver);
            factory.propertyResolver = this.propertyResolvers;
            return factory;
        }
    }
}

