/*
 * Decompiled with CFR 0.152.
 */
package com.github.dadiyang.httpinvoker;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.github.dadiyang.httpinvoker.annotation.ContentType;
import com.github.dadiyang.httpinvoker.annotation.Cookies;
import com.github.dadiyang.httpinvoker.annotation.Form;
import com.github.dadiyang.httpinvoker.annotation.Headers;
import com.github.dadiyang.httpinvoker.annotation.HttpApi;
import com.github.dadiyang.httpinvoker.annotation.HttpReq;
import com.github.dadiyang.httpinvoker.annotation.Param;
import com.github.dadiyang.httpinvoker.annotation.RetryPolicy;
import com.github.dadiyang.httpinvoker.annotation.UserAgent;
import com.github.dadiyang.httpinvoker.propertyresolver.PropertiesBasePropertyResolver;
import com.github.dadiyang.httpinvoker.propertyresolver.PropertyResolver;
import com.github.dadiyang.httpinvoker.requestor.DefaultHttpRequestor;
import com.github.dadiyang.httpinvoker.requestor.DefaultResponseProcessor;
import com.github.dadiyang.httpinvoker.requestor.HttpRequest;
import com.github.dadiyang.httpinvoker.requestor.HttpResponse;
import com.github.dadiyang.httpinvoker.requestor.MultiPart;
import com.github.dadiyang.httpinvoker.requestor.RequestPreprocessor;
import com.github.dadiyang.httpinvoker.requestor.Requestor;
import com.github.dadiyang.httpinvoker.requestor.ResponseProcessor;
import com.github.dadiyang.httpinvoker.requestor.Status;
import com.github.dadiyang.httpinvoker.util.ParamUtils;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationHandler;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class HttpApiInvoker
implements InvocationHandler {
    private static final Logger log = LoggerFactory.getLogger(HttpApiInvoker.class);
    private static final ResponseProcessor DEFAULT_RESPONSE_PROCESSOR = new DefaultResponseProcessor();
    private static final Pattern PATH_VARIABLE_PATTERN = Pattern.compile("\\{([^/]+?)}");
    private static final Pattern VARIABLE_PATTERN = Pattern.compile("\\$\\{([^/]+?)}");
    private static final Pattern PATH_NOT_REMOVE_VARIABLE_PATTERN = Pattern.compile("#\\{([^/]+?)}");
    private static final Pattern PROTOCOL_PATTERN = Pattern.compile("^[a-zA-Z].+://");
    private static final int OK_CODE_L = 200;
    private static final int OK_CODE_H = 300;
    private static final String HTTP_API_PREFIX = "$HttpApi$";
    private static final String TO_STRING = "toString";
    private static final String CONTENT_TYPE = "Content-Type";
    private Requestor requestor;
    private PropertyResolver propertyResolver;
    private Class<?> clazz;
    private RequestPreprocessor requestPreprocessor;
    private ResponseProcessor responseProcessor;

    public HttpApiInvoker(Requestor requestor, Properties properties, Class<?> clazz, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        this.requestor = requestor == null ? new DefaultHttpRequestor() : requestor;
        properties = properties == null ? System.getProperties() : properties;
        this.propertyResolver = new PropertiesBasePropertyResolver(properties);
        this.requestPreprocessor = requestPreprocessor;
        this.responseProcessor = responseProcessor;
        this.clazz = clazz;
    }

    public HttpApiInvoker(Requestor requestor, PropertyResolver propertyResolver, Class<?> clazz, RequestPreprocessor requestPreprocessor, ResponseProcessor responseProcessor) {
        this.requestor = requestor == null ? new DefaultHttpRequestor() : requestor;
        this.propertyResolver = propertyResolver == null ? new PropertiesBasePropertyResolver(System.getProperties()) : propertyResolver;
        this.requestPreprocessor = requestPreprocessor;
        this.responseProcessor = responseProcessor;
        this.clazz = clazz;
    }

    @Override
    public Object invoke(Object proxy, Method method, Object[] args) throws Throwable {
        if (!method.isAnnotationPresent(HttpReq.class)) {
            if (TO_STRING.equals(method.getName()) && method.getParameterTypes().length == 0) {
                return HTTP_API_PREFIX + this;
            }
            if (this.getClass().getMethod(method.getName(), method.getParameterTypes()) != null) {
                return method.invoke((Object)this, args);
            }
            throw new IllegalStateException("this proxy only implement those HttpReq-annotated method");
        }
        HttpReq anno = method.getAnnotation(HttpReq.class);
        String url = this.prepareUrl(anno);
        HttpRequest request = new HttpRequest(anno.timeout(), anno.method());
        request.setUrl(url);
        if (args != null && args.length > 0) {
            for (Object arg : args) {
                if (!(arg instanceof MultiPart)) continue;
                if (!"POST".equalsIgnoreCase(request.getMethod())) {
                    throw new IllegalStateException("unsupported request method for multipart form: " + request.getMethod());
                }
                request.setBody(arg);
            }
            Map<String, Object> params = null;
            Map<String, Object> annotatedParam = this.parseAnnotatedParams(args, method, request);
            if (annotatedParam != null && !annotatedParam.isEmpty()) {
                params = annotatedParam;
            } else if (request.getBody() == null) {
                if (ParamUtils.isCollection(args[0])) {
                    request.setBody(args[0]);
                } else if (args[0] != null) {
                    params = this.parseParam(args[0]);
                }
            } else {
                request.setData(this.parseParam(request.getBody()));
            }
            url = this.fillPathVariables(params, url, false);
            request.setUrl(url);
            request.setData(params);
        }
        this.addHeaders(method, request);
        this.addCookies(method, request);
        this.addContentType(method, request);
        this.addUserAgent(method, request);
        if (this.requestPreprocessor != null) {
            this.requestPreprocessor.process(request);
        }
        url = this.fillPathVariables(request.getData(), url, true);
        request.setUrl(url);
        long start = System.currentTimeMillis();
        RetryPolicy retryPolicy = this.getRetryPolicy(method);
        HttpResponse response = retryPolicy == null ? this.requestor.sendRequest(request) : this.retrySendRequest(request, retryPolicy);
        if (this.isSuc(url, response)) {
            return null;
        }
        Object returnValue = this.responseProcessor != null ? this.responseProcessor.process(response, method) : DEFAULT_RESPONSE_PROCESSOR.process(response, method);
        if (log.isDebugEnabled()) {
            log.debug("send request to url: {}, time consume: {} ms", (Object)request.getUrl(), (Object)(System.currentTimeMillis() - start));
        }
        return returnValue;
    }

    private void addContentType(Method method, HttpRequest request) {
        if (this.clazz.isAnnotationPresent(Form.class) || method.isAnnotationPresent(Form.class)) {
            request.addHeader(CONTENT_TYPE, "application/x-www-form-urlencoded");
            return;
        }
        ContentType contentType = this.getAnn(method, ContentType.class);
        if (contentType != null && !contentType.value().isEmpty()) {
            request.addHeader(CONTENT_TYPE, contentType.value());
        }
    }

    private void addUserAgent(Method method, HttpRequest request) {
        UserAgent userAgent = this.getAnn(method, UserAgent.class);
        if (userAgent != null && !userAgent.value().isEmpty()) {
            request.addHeader("User-Agent", userAgent.value());
        }
    }

    private void addCookies(Method method, HttpRequest request) {
        Cookies headers;
        if (method.getDeclaringClass().isAnnotationPresent(Cookies.class)) {
            headers = method.getDeclaringClass().getAnnotation(Cookies.class);
            this.addCookies(request, headers);
        }
        if (method.isAnnotationPresent(Cookies.class)) {
            headers = method.getAnnotation(Cookies.class);
            this.addCookies(request, headers);
        }
    }

    private void addCookies(HttpRequest request, Cookies cookies) {
        if (cookies != null && cookies.keys().length > 0) {
            if (cookies.values().length == cookies.keys().length) {
                for (int i = 0; i < cookies.keys().length; ++i) {
                    String key = cookies.keys()[i];
                    String value = cookies.values()[i];
                    request.addCookie(key, value);
                }
            } else {
                throw new IllegalStateException("cookies' keys and values must one-to-one correspondence");
            }
        }
    }

    private void addHeaders(Method method, HttpRequest request) {
        Headers headers;
        if (method.getDeclaringClass().isAnnotationPresent(Headers.class)) {
            headers = method.getDeclaringClass().getAnnotation(Headers.class);
            this.addHeaders(request, headers);
        }
        if (method.isAnnotationPresent(Headers.class)) {
            headers = method.getAnnotation(Headers.class);
            this.addHeaders(request, headers);
        }
    }

    private void addHeaders(HttpRequest request, Headers headers) {
        if (headers != null && headers.keys().length > 0) {
            if (headers.values().length == headers.keys().length) {
                for (int i = 0; i < headers.keys().length; ++i) {
                    String key = headers.keys()[i];
                    String value = headers.values()[i];
                    request.addHeader(key, value);
                }
            } else {
                throw new IllegalStateException("headers' keys and values must one-to-one correspondence");
            }
        }
    }

    private <T extends Annotation> T getAnn(Method method, Class<T> ann) {
        if (method.isAnnotationPresent(ann)) {
            return method.getAnnotation(ann);
        }
        if (method.getDeclaringClass().isAnnotationPresent(ann)) {
            return method.getDeclaringClass().getAnnotation(ann);
        }
        return null;
    }

    private String prepareUrl(HttpReq anno) {
        String url = anno.value();
        url = this.fillConfigVariables(url);
        url = this.setPrefix(url);
        return this.fillConfigVariables(url);
    }

    private String setPrefix(String url) {
        if (this.clazz.isAnnotationPresent(HttpApi.class) && !PROTOCOL_PATTERN.matcher(url).find()) {
            HttpApi httpApi = this.clazz.getAnnotation(HttpApi.class);
            String pre = "".equals(httpApi.prefix()) ? httpApi.value() : httpApi.prefix();
            url = pre + url;
        }
        return url;
    }

    private boolean isSuc(String url, HttpResponse response) throws IOException {
        if (response == null) {
            return true;
        }
        if (response.getStatusCode() < 200 || response.getStatusCode() >= 300) {
            throw new IOException(url + ", statusCode: " + response.getStatusCode() + ", statusMsg: " + response.getStatusMessage());
        }
        return false;
    }

    private HttpResponse retrySendRequest(HttpRequest request, RetryPolicy retryPolicy) throws IOException {
        int retryTime = retryPolicy.times();
        if (retryTime <= 0) {
            return this.requestor.sendRequest(request);
        }
        Status[] retryForStatus = retryPolicy.retryForStatus();
        Class<? extends Throwable>[] retryFor = retryPolicy.retryFor();
        HttpResponse response = null;
        int tryTime = 0;
        while (++tryTime <= retryTime) {
            if (tryTime > 1 && retryPolicy.fixedBackOffPeriod() > 0L) {
                try {
                    Thread.sleep(retryPolicy.fixedBackOffPeriod());
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    throw new IllegalStateException("thread interrupted when waiting for retry", e);
                }
            }
            boolean needRetry = false;
            try {
                response = this.requestor.sendRequest(request);
                int statusCode = response.getStatusCode();
                for (Status status : retryForStatus) {
                    if (statusCode < status.getFrom() || statusCode > status.getTo()) continue;
                    needRetry = true;
                }
                if (needRetry) continue;
                return response;
            }
            catch (IOException e) {
                if (tryTime >= retryTime) {
                    throw e;
                }
                for (Class<? extends Throwable> clazz : retryFor) {
                    if (!clazz.isAssignableFrom(e.getClass())) continue;
                    needRetry = true;
                }
                if (!needRetry) {
                    throw e;
                }
                log.warn("send request error, tryTime: {}, url: {}, error: {}", new Object[]{tryTime, request.getUrl(), e.getMessage()});
            }
        }
        return response;
    }

    private RetryPolicy getRetryPolicy(Method method) {
        RetryPolicy retryPolicy = null;
        if (method.isAnnotationPresent(RetryPolicy.class)) {
            retryPolicy = method.getAnnotation(RetryPolicy.class);
        } else if (this.clazz.isAnnotationPresent(RetryPolicy.class)) {
            retryPolicy = this.clazz.getAnnotation(RetryPolicy.class);
        }
        return retryPolicy;
    }

    private Map<String, Object> parseParam(Object arg) {
        Class<?> cls = arg.getClass();
        JSONObject params = ParamUtils.isBasicType(cls) || ParamUtils.isCollection(arg) ? null : JSON.parseObject((String)JSON.toJSONString((Object)arg));
        return params;
    }

    private Map<String, Object> parseAnnotatedParams(Object[] args, Method method, HttpRequest request) {
        Annotation[][] annotations = method.getParameterAnnotations();
        if (annotations.length <= 0) {
            return Collections.emptyMap();
        }
        HashMap<String, Object> map = null;
        int annotationsLength = annotations.length;
        for (int i = 0; i < annotationsLength; ++i) {
            Annotation[] annotation;
            if (args[i] == null || (annotation = annotations[i]).length == 0) continue;
            for (Annotation ann : annotation) {
                if (ann instanceof Param) {
                    Param param = (Param)ann;
                    if (map == null) {
                        map = new HashMap<String, Object>();
                    }
                    if (this.isFile(args[i])) {
                        request.setBody(args[i]);
                        request.setFileFormKey(param.value());
                    } else if (param.isBody()) {
                        Map<String, Object> body = this.parseParam(args[i]);
                        if (body == null) {
                            map.put(param.value(), args[i]);
                        } else {
                            map.putAll(body);
                        }
                    } else {
                        String key = param.value();
                        if (!key.isEmpty()) {
                            map.put(key, args[i]);
                        }
                    }
                }
                if (ann instanceof Headers) {
                    this.mustBeMapStringString(method.getGenericParameterTypes()[i]);
                    request.setHeaders((Map)args[i]);
                }
                if (!(ann instanceof Cookies)) continue;
                this.mustBeMapStringString(method.getGenericParameterTypes()[i]);
                request.setCookies((Map)args[i]);
            }
        }
        return map;
    }

    private boolean isFile(Object arg) {
        return InputStream.class.isAssignableFrom(arg.getClass()) || File.class.isAssignableFrom(arg.getClass());
    }

    private void mustBeMapStringString(Type arg) {
        if (!(arg instanceof ParameterizedType) || ((ParameterizedType)arg).getRawType() != Map.class) {
            throw new IllegalArgumentException("Headers and Cookies annotation should only be annotated on parameter of Map<String, String> type.");
        }
        Type[] types = ((ParameterizedType)arg).getActualTypeArguments();
        if (types[0] != String.class || types[1] != String.class) {
            throw new IllegalArgumentException("Headers and Cookies annotation should only be annotated on parameter of Map<String, String> type.");
        }
    }

    private String fillPathVariables(Map<String, Object> params, String url, boolean exceptionOnNotProvided) {
        url = this.fillPathVariables(params, url, exceptionOnNotProvided, false);
        return this.fillPathVariables(params, url, exceptionOnNotProvided, true);
    }

    private String fillPathVariables(Map<String, Object> params, String url, boolean exceptionOnNotProvided, boolean remove) {
        Pattern pattern = remove ? PATH_VARIABLE_PATTERN : PATH_NOT_REMOVE_VARIABLE_PATTERN;
        Matcher matcher = pattern.matcher(url);
        while (matcher.find()) {
            String prop;
            String key = matcher.group(1);
            if (params == null || !params.containsKey(key) || params.get(key) == null) {
                String msg = "the url [" + url + "] needs a variable: [" + key + "], but not provided.";
                log.warn(msg);
                if (!exceptionOnNotProvided) continue;
                throw new IllegalArgumentException(msg);
            }
            if (remove) {
                prop = params.remove(key).toString();
                url = url.replace("{" + key + "}", prop);
                continue;
            }
            prop = params.get(key).toString();
            url = url.replace("#{" + key + "}", prop);
        }
        return url;
    }

    private String fillConfigVariables(String url) {
        Matcher matcher = VARIABLE_PATTERN.matcher(url);
        while (matcher.find()) {
            String key = matcher.group(1);
            if (this.propertyResolver == null || !this.propertyResolver.containsProperty(key)) {
                String msg = "the url [" + url + "] needs a variable: [" + key + "], but not provided.";
                log.warn(msg);
                throw new IllegalArgumentException(msg);
            }
            String prop = this.propertyResolver.getProperty(key);
            url = url.replace("${" + key + "}", prop);
        }
        return url;
    }
}

