/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web.foundation.variable;

import com.github.dactiv.orm.core.PropertyFilter;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.entity.foundation.variable.DictionaryCategory;
import com.github.dactiv.showcase.service.foundation.SystemVariableManager;
import java.util.ArrayList;
import java.util.List;
import javax.validation.Valid;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.ui.Model;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@OperatingAudit(value="\u5b57\u5178\u7c7b\u522b\u7ba1\u7406")
@RequestMapping(value={"/foundation/variable/dictionary-category"})
public class DictionaryCategoryController {
    @Autowired
    private SystemVariableManager systemDictionaryManager;

    @RequestMapping(value={"view"})
    public List<DictionaryCategory> view() {
        return this.systemDictionaryManager.getParentDictionaryCategories();
    }

    @RequestMapping(value={"save"})
    @OperatingAudit(function="\u4fdd\u5b58\u6216\u66f4\u65b0\u5b57\u5178\u7c7b\u522b")
    public String save(@ModelAttribute(value="entity") @Valid DictionaryCategory entity, String parentId, RedirectAttributes redirectAttributes) {
        if (StringUtils.isEmpty((CharSequence)parentId)) {
            entity.setParent(null);
        } else {
            entity.setParent(this.systemDictionaryManager.getDictionaryCategory(parentId));
        }
        this.systemDictionaryManager.saveDictionaryCategory(entity);
        redirectAttributes.addFlashAttribute("success", (Object)"\u4fdd\u5b58\u6210\u529f");
        return "redirect:/foundation/variable/dictionary-category/view";
    }

    @RequestMapping(value={"read"})
    public void read(String id, Model model) {
        ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            filters.add(PropertyFilters.get((String)"NES_id", (String)id));
        }
        model.addAttribute("categoriesList", (Object)this.systemDictionaryManager.getDictionaryCategories(filters));
    }

    @RequestMapping(value={"delete"})
    @OperatingAudit(function="\u5220\u9664\u5b57\u5178\u7c7b\u522b")
    public String delete(@RequestParam(value="ids") List<String> ids, RedirectAttributes redirectAttributes) {
        this.systemDictionaryManager.deleteDictionaryCategory(ids);
        redirectAttributes.addFlashAttribute("success", (Object)("\u5220\u9664" + ids.size() + "\u6761\u4fe1\u606f\u6210\u529f"));
        return "redirect:/foundation/variable/dictionary-category/view";
    }

    @ModelAttribute(value="entity")
    public DictionaryCategory bindingModel(String id) {
        DictionaryCategory category = new DictionaryCategory();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            category = this.systemDictionaryManager.getDictionaryCategory(id);
        }
        return category;
    }
}

