/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web;

import com.github.dactiv.common.spring.mvc.SpringMvcHolder;
import com.github.dactiv.showcase.service.ServiceException;
import org.springframework.stereotype.Controller;
import org.springframework.validation.BindException;
import org.springframework.web.bind.annotation.ControllerAdvice;
import org.springframework.web.bind.annotation.ExceptionHandler;
import org.springframework.web.bind.annotation.RequestMapping;

@Controller
@ControllerAdvice
public class SystemExceptionController {
    @RequestMapping(value={"/unauthorized"})
    public String unauthorized() {
        return "exception/unauthorized";
    }

    @ExceptionHandler(value={ServiceException.class})
    public String serviceException(ServiceException exception) {
        SpringMvcHolder.addRequestAttribute((String)"exception", (Object)exception);
        return "exception/service-exception";
    }

    @ExceptionHandler(value={BindException.class})
    public String bindException(BindException exception) {
        SpringMvcHolder.addRequestAttribute((String)"errors", (Object)exception.getBindingResult().getAllErrors());
        return "exception/bind-exception";
    }

    @ExceptionHandler
    public String globalException(Throwable throwable) {
        throwable.printStackTrace();
        return "exception/global-exception";
    }
}

