/*
 * Decompiled with CFR 0.152.
 */
package com.github.dactiv.showcase.web.foundation.variable;

import com.github.dactiv.orm.core.Page;
import com.github.dactiv.orm.core.PageRequest;
import com.github.dactiv.orm.core.PropertyFilter;
import com.github.dactiv.orm.core.PropertyFilters;
import com.github.dactiv.showcase.common.annotation.OperatingAudit;
import com.github.dactiv.showcase.entity.foundation.variable.DictionaryCategory;
import com.github.dactiv.showcase.service.foundation.SystemVariableManager;
import java.util.ArrayList;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.ModelAttribute;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.servlet.mvc.support.RedirectAttributes;

@Controller
@OperatingAudit(value="\u5b57\u5178\u7c7b\u522b\u7ba1\u7406")
@RequestMapping(value={"/foundation/variable/dictionary-category"})
public class DictionaryCategoryController {
    @Autowired
    private SystemVariableManager systemDictionaryManager;

    @RequestMapping(value={"view"})
    public Page<DictionaryCategory> view(PageRequest pageRequest, HttpServletRequest request) {
        List filters = PropertyFilters.build((HttpServletRequest)request, (boolean)true);
        if (!pageRequest.isOrderBySetted()) {
            pageRequest.setOrderBy("id");
            pageRequest.setOrderDir("desc");
        }
        request.setAttribute("categoriesList", (Object)this.systemDictionaryManager.getDictionaryCategories());
        return this.systemDictionaryManager.searchDictionaryCategoryPage(pageRequest, filters);
    }

    @RequestMapping(value={"save"})
    @OperatingAudit(function="\u4fdd\u5b58\u6216\u66f4\u65b0\u5b57\u5178\u7c7b\u522b")
    public String save(@ModelAttribute(value="entity") DictionaryCategory entity, String parentId, RedirectAttributes redirectAttributes) {
        if (StringUtils.isEmpty((CharSequence)parentId)) {
            entity.setParent(null);
        } else {
            entity.setParent(this.systemDictionaryManager.getDictionaryCategory(parentId));
        }
        this.systemDictionaryManager.saveDictionaryCategory(entity);
        redirectAttributes.addFlashAttribute("success", (Object)"\u4fdd\u5b58\u6210\u529f");
        return "redirect:/foundation/variable/dictionary-category/view";
    }

    @RequestMapping(value={"read"})
    public String read(HttpServletRequest request) {
        ArrayList<PropertyFilter> filters = new ArrayList<PropertyFilter>();
        String id = request.getParameter("id");
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            filters.add(PropertyFilters.build((String)"NES_id", (String)id));
        }
        request.setAttribute("categoriesList", (Object)this.systemDictionaryManager.getDictionaryCategories(filters));
        return "/foundation/variable/dictionary-category/read";
    }

    @RequestMapping(value={"delete"})
    @OperatingAudit(function="\u5220\u9664\u5b57\u5178\u7c7b\u522b")
    public String delete(@RequestParam(value="ids") List<String> ids, RedirectAttributes redirectAttributes) {
        this.systemDictionaryManager.deleteDictionaryCategory(ids);
        redirectAttributes.addFlashAttribute("success", (Object)("\u5220\u9664" + ids.size() + "\u6761\u4fe1\u606f\u6210\u529f"));
        return "redirect:/foundation/variable/dictionary-category/view";
    }

    @ModelAttribute(value="entity")
    public DictionaryCategory bindingModel(@RequestParam(value="id", required=false) String id) {
        DictionaryCategory dictionaryCategory = new DictionaryCategory();
        if (StringUtils.isNotEmpty((CharSequence)id)) {
            dictionaryCategory = this.systemDictionaryManager.getDictionaryCategory(id);
        }
        return dictionaryCategory;
    }
}

