/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.mif;

import com.daxie.log.LogFile;
import com.daxie.tool.FileFunctions;
import com.daxie.xops.mif.MissionInfo;
import java.io.FileNotFoundException;
import java.io.UnsupportedEncodingException;
import java.util.List;

class MIFParser {
    private MissionInfo mission_info = new MissionInfo();

    public MIFParser(String mif_filename, String encoding) throws FileNotFoundException, UnsupportedEncodingException, NumberFormatException {
        List lines = FileFunctions.GetFileAllLines((String)mif_filename, (String)encoding);
        if (lines.size() < 10) {
            LogFile.WriteWarn((String)"[MIFParser-<init>] Too few lines in the MIF file.", (boolean)true);
            return;
        }
        this.mission_info.SetMissionName((String)lines.get(0));
        this.mission_info.SetMissionFormalName((String)lines.get(1));
        this.mission_info.SetBD1Filename((String)lines.get(2));
        this.mission_info.SetPD1Filename((String)lines.get(3));
        this.mission_info.SetSkyType(Integer.parseInt((String)lines.get(4)));
        int flags = Integer.parseInt((String)lines.get(5));
        if ((flags & 2) != 0) {
            this.mission_info.SetDarkenScreenFlag(true);
        } else {
            this.mission_info.SetDarkenScreenFlag(false);
        }
        if ((flags & 1) != 0) {
            this.mission_info.SetExtraHitcheckFlag(true);
        } else {
            this.mission_info.SetExtraHitcheckFlag(false);
        }
        this.mission_info.SetArticleInfoFilename((String)lines.get(6));
        this.mission_info.SetImage1Filename((String)lines.get(7));
        this.mission_info.SetImage2Filename((String)lines.get(8));
        for (int i = 9; i < lines.size(); ++i) {
            this.mission_info.AddBriefingTextLine((String)lines.get(i));
        }
    }

    public MissionInfo GetMissionInfo() {
        return new MissionInfo(this.mission_info);
    }
}

