/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.addon;

import com.daxie.log.LogFile;
import com.daxie.tool.HashFunctions;
import java.io.FileNotFoundException;
import java.security.NoSuchAlgorithmException;

public class AddonHashCalculator {
    private String algorithm;
    private String bd1_hash;
    private String pd1_hash;
    private String mif_hash;
    private String combined_hash;

    public AddonHashCalculator(String algorithm) {
        this.algorithm = algorithm;
        this.bd1_hash = "";
        this.pd1_hash = "";
        this.mif_hash = "";
        this.combined_hash = "";
    }

    public int CalculateBD1Hash(String bd1_filename) {
        try {
            this.bd1_hash = HashFunctions.GetFileHash(bd1_filename, this.algorithm);
        }
        catch (FileNotFoundException e) {
            LogFile.WriteError("[AddonHashCalculator-CalculateBD1Hash] File not found. filename:" + bd1_filename);
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            LogFile.WriteError("[AddonHashCalculator-CalculateBD1Hash] No such algorithm. algorithm:" + this.algorithm);
            return -1;
        }
        return 0;
    }

    public int CalculatePD1Hash(String pd1_filename) {
        try {
            this.pd1_hash = HashFunctions.GetFileHash(pd1_filename, this.algorithm);
        }
        catch (FileNotFoundException e) {
            LogFile.WriteError("[AddonHashCalculator-CalculatePD1Hash] File not found. filename:" + pd1_filename);
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            LogFile.WriteError("[AddonHashCalculator-CalculatePD1Hash] No such algorithm. algorithm:" + this.algorithm);
            return -1;
        }
        return 0;
    }

    public int CalculateMIFHash(String mif_filename) {
        try {
            this.mif_hash = HashFunctions.GetFileHash(mif_filename, this.algorithm);
        }
        catch (FileNotFoundException e) {
            LogFile.WriteError("[AddonHashCalculator-CalculateMIFHash] File not found. filename:" + mif_filename);
            return -1;
        }
        catch (NoSuchAlgorithmException e) {
            LogFile.WriteError("[AddonHashCalculator-CalculateMIFHash] No such algorithm. algorithm:" + this.algorithm);
            return -1;
        }
        return 0;
    }

    public int CalculateCombinedHash() {
        boolean hash_not_calculated_flag = false;
        if (this.bd1_hash.equals("")) {
            LogFile.WriteError("[AddonHashCalculator-CalculateCombinedHash] BD1 hash not calculated yet.");
            hash_not_calculated_flag = true;
        }
        if (this.pd1_hash.equals("")) {
            LogFile.WriteError("[AddonHashCalculator-CalculateCombinedHash] PD1 hash not calculated yet.");
            hash_not_calculated_flag = true;
        }
        if (this.mif_hash.equals("")) {
            LogFile.WriteError("[AddonHashCalculator-CalculateCombinedHash] MIF hash not calculated yet.");
            hash_not_calculated_flag = true;
        }
        if (hash_not_calculated_flag) {
            return -1;
        }
        String str = this.bd1_hash + this.pd1_hash + this.mif_hash;
        try {
            this.combined_hash = HashFunctions.GetHash(str, this.algorithm);
        }
        catch (NoSuchAlgorithmException e) {
            return -1;
        }
        return 0;
    }

    public String GetBD1Hash() {
        return this.bd1_hash;
    }

    public String GetPD1Hash() {
        return this.pd1_hash;
    }

    public String GetMIFHash() {
        return this.mif_hash;
    }

    public String GetCombinedHash() {
        return this.combined_hash;
    }
}

