/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.xgs;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.weapon.WeaponData;
import com.daxie.xops.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.weapon.WeaponModelType;
import com.daxie.xops.weapon.WeaponScopeMode;
import com.daxie.xops.weapon.WeaponShootingStance;
import com.daxie.xops.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.weapon.WeaponTextureType;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.ArrayList;

class XGSParser {
    private WeaponData[] weapon_data_array;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public XGSParser(String xgs_filename) throws FileNotFoundException {
        ArrayList<Byte> bin;
        block28: {
            String str;
            this.weapon_data_array = null;
            bin = new ArrayList<Byte>();
            DataInputStream dis = new DataInputStream(new BufferedInputStream(new FileInputStream(xgs_filename)));
            this.weapon_data_array = new WeaponData[23];
            for (int i = 0; i < 23; ++i) {
                this.weapon_data_array[i] = new WeaponData();
            }
            try {
                while (true) {
                    byte read_byte = dis.readByte();
                    bin.add(read_byte);
                }
            }
            catch (EOFException read_byte) {
                try {
                    if (dis != null) {
                        dis.close();
                    }
                }
                catch (IOException e) {
                    str = ExceptionFunctions.GetPrintStackTraceString(e);
                    LogFile.WriteFatal("[XGSParser-<init>] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
            }
            catch (IOException e) {
                try {
                    str = ExceptionFunctions.GetPrintStackTraceString(e);
                    LogFile.WriteFatal("[XGSParser-<init>] Below is the stack trace.");
                    LogFile.WriteLine(str);
                    LogFile.CloseLogFile();
                    System.exit(1);
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    try {
                        if (dis != null) {
                            dis.close();
                        }
                    }
                    catch (IOException e2) {
                        str = ExceptionFunctions.GetPrintStackTraceString(e2);
                        LogFile.WriteFatal("[XGSParser-<init>] Below is the stack trace.");
                        LogFile.WriteLine(str);
                        LogFile.CloseLogFile();
                        System.exit(1);
                    }
                }
            }
            if (bin.size() == 1732) break block28;
            LogFile.WriteError("[XGSParser-<init>] Invalid file size. filename:" + xgs_filename);
            return;
        }
        byte[] b = new byte[2];
        int count = 14;
        for (int i = 0; i < 23; ++i) {
            b[0] = (Byte)bin.get(count);
            b[1] = (Byte)bin.get(count + 1);
            short itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetAttackPower(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetPenetration(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetFiringInterval(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetBulletSpeed(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetNumberOfBullets(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetReloadingTime(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetRecoil(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetErrorRangeMin(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetErrorRangeMax(itemp);
            Vector vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetZ(itemp);
            this.weapon_data_array[i].SetPosition(vtemp);
            vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetZ(itemp);
            this.weapon_data_array[i].SetFlashPosition(vtemp);
            vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetZ(itemp);
            this.weapon_data_array[i].SetCartridgePosition(vtemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponShootingStance shooting_stance = WeaponBinSpecifierAndEnumConverter.GetWeaponShootingStanceFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetShootingStance(shooting_stance);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            if (itemp == 0) {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(true);
            } else {
                this.weapon_data_array[i].SetRapidFireEnabledFlag(false);
            }
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponScopeMode scope_mode = WeaponBinSpecifierAndEnumConverter.GetWeaponScopeModeFromBinSpecifier(itemp);
            this.weapon_data_array[i].SetScopeMode(scope_mode);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponTextureType texture_type = WeaponBinSpecifierAndEnumConverter.GetWeaponTextureTypeFromBinSpecifier(itemp);
            String texture_filename = WeaponTextureFilenamesStock.GetTextureFilename(texture_type);
            this.weapon_data_array[i].SetTextureFilename(texture_filename);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            WeaponModelType model_type = WeaponBinSpecifierAndEnumConverter.GetWeaponModelTypeFromBinSpecifier(itemp);
            String model_filename = WeaponModelFilenamesStock.GetModelFilename(model_type);
            this.weapon_data_array[i].SetModelFilename(model_filename);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetScale((float)itemp * 0.1f);
            vtemp = new Vector();
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetX(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            vtemp.SetY(itemp);
            vtemp.SetZ(0.0f);
            this.weapon_data_array[i].SetCartridgeVelocity(vtemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetSoundID(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            this.weapon_data_array[i].SetSoundVolume(itemp);
            b[0] = (Byte)bin.get(count += 2);
            b[1] = (Byte)bin.get(count + 1);
            itemp = ByteFunctions.byte_to_short_le(b);
            if (itemp == 0) {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(false);
            } else {
                this.weapon_data_array[i].SetSuppressorEnabledFlag(true);
            }
            count += 2;
            if (i == 4) {
                this.weapon_data_array[i].SetChangeableWeapon(16);
            } else if (i == 16) {
                this.weapon_data_array[i].SetChangeableWeapon(4);
            }
            if (i != 19) continue;
            this.weapon_data_array[i].SetNumberOfProjectiles(6);
        }
        count = 1348;
        for (int i = 0; i < 23; ++i) {
            byte[] name_buffer = new byte[16];
            for (int j = 0; j < 15; ++j) {
                name_buffer[j] = (Byte)bin.get(count + j);
            }
            name_buffer[15] = 0;
            count += 16;
            String strtemp = new String(name_buffer);
            int first_null_pos = 15;
            for (int j = 0; j < 16; ++j) {
                if (strtemp.charAt(j) != '\u0000') continue;
                first_null_pos = j;
                break;
            }
            strtemp = strtemp.substring(0, first_null_pos);
            this.weapon_data_array[22 - i].SetName(strtemp);
        }
    }

    public WeaponData[] GetWeaponDataArray() {
        WeaponData[] ret = new WeaponData[this.weapon_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new WeaponData(this.weapon_data_array[i]);
        }
        return ret;
    }
}

