/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.exe;

import com.github.dabasan.tool.DateFunctions;
import com.github.dabasan.tool.FileFunctions;
import com.github.dabasan.tool.FilenameFunctions;
import com.github.dabasan.xops.properties.entity.character.CharacterData;
import com.github.dabasan.xops.properties.entity.weapon.WeaponData;
import com.github.dabasan.xops.properties.exe.XOPSExeCharacterDataReader;
import com.github.dabasan.xops.properties.exe.XOPSExeCharacterDataWriter;
import com.github.dabasan.xops.properties.exe.XOPSExeFunctions;
import com.github.dabasan.xops.properties.exe.XOPSExeWeaponDataReader;
import com.github.dabasan.xops.properties.exe.XOPSExeWeaponDataWriter;
import com.github.dabasan.xops.properties.exe.XOPSVersion;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XOPSExeManipulator {
    private final Logger logger = LoggerFactory.getLogger(XOPSExeManipulator.class);
    private WeaponData[] weapon_data_array;
    private CharacterData[] character_data_array;

    public XOPSExeManipulator(String xops_filename) throws IOException {
        int character_data_start_pos;
        int weapon_name_start_pos;
        int weapon_data_start_pos;
        List bin = FileFunctions.GetFileAllBin((String)xops_filename);
        XOPSVersion version = XOPSExeFunctions.GetXOPSVersion(bin);
        if (version == XOPSVersion.UNKNOWN_VERSION) {
            int i;
            this.logger.warn("Unknown version of X operations.");
            this.weapon_data_array = new WeaponData[23];
            for (i = 0; i < this.weapon_data_array.length; ++i) {
                this.weapon_data_array[i] = new WeaponData();
            }
            this.character_data_array = new CharacterData[43];
            for (i = 0; i < this.character_data_array.length; ++i) {
                this.character_data_array[i] = new CharacterData();
            }
            return;
        }
        switch (version) {
            case XOPS096: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS096T: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS097FT: {
                weapon_data_start_pos = 385836;
                weapon_name_start_pos = 422372;
                character_data_start_pos = 387172;
                break;
            }
            case XOPS0975T: {
                weapon_data_start_pos = 491440;
                weapon_name_start_pos = 495936;
                character_data_start_pos = 492776;
                break;
            }
            case XOPSOLT18F2: {
                weapon_data_start_pos = 418828;
                weapon_name_start_pos = 454532;
                character_data_start_pos = 420164;
                break;
            }
            case XOPSOLT19F2: {
                weapon_data_start_pos = 489448;
                weapon_name_start_pos = 488304;
                character_data_start_pos = 490784;
                break;
            }
            default: {
                weapon_data_start_pos = 0;
                weapon_name_start_pos = 0;
                character_data_start_pos = 0;
            }
        }
        XOPSExeWeaponDataReader weapon_data_parser = new XOPSExeWeaponDataReader(bin, weapon_data_start_pos, weapon_name_start_pos);
        XOPSExeCharacterDataReader character_data_parser = new XOPSExeCharacterDataReader(bin, character_data_start_pos);
        this.weapon_data_array = weapon_data_parser.GetWeaponData();
        this.character_data_array = character_data_parser.GetCharacterData();
    }

    public XOPSExeManipulator(String xops_filename, int weapon_data_start_pos, int weapon_name_start_pos, int character_data_start_pos) throws IOException {
        List bin = FileFunctions.GetFileAllBin((String)xops_filename);
        XOPSExeWeaponDataReader weapon_data_parser = null;
        XOPSExeCharacterDataReader character_data_parser = null;
        try {
            weapon_data_parser = new XOPSExeWeaponDataReader(bin, weapon_data_start_pos, weapon_name_start_pos);
            character_data_parser = new XOPSExeCharacterDataReader(bin, character_data_start_pos);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.error("Error while reading.", (Throwable)e);
            return;
        }
        this.weapon_data_array = weapon_data_parser.GetWeaponData();
        this.character_data_array = character_data_parser.GetCharacterData();
    }

    public XOPSExeManipulator() {
    }

    public WeaponData[] GetWeaponData() {
        if (this.weapon_data_array == null) {
            return null;
        }
        WeaponData[] ret = new WeaponData[this.weapon_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new WeaponData(this.weapon_data_array[i]);
        }
        return ret;
    }

    public CharacterData[] GetCharacterData() {
        if (this.character_data_array == null) {
            return null;
        }
        CharacterData[] ret = new CharacterData[this.character_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new CharacterData(this.character_data_array[i]);
        }
        return ret;
    }

    public void SetWeaponData(WeaponData[] weapon_data_array) {
        if (weapon_data_array == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.weapon_data_array = weapon_data_array;
    }

    public void SetCharacterData(CharacterData[] character_data_array) {
        if (character_data_array == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.character_data_array = character_data_array;
    }

    public int Write(String xops_filename, boolean create_backup_flag) {
        int character_data_start_pos;
        int weapon_name_start_pos;
        int weapon_data_start_pos;
        List bin;
        try {
            bin = FileFunctions.GetFileAllBin((String)xops_filename);
        }
        catch (IOException e) {
            this.logger.error("Failed to write in an EXE file. exe_filename={}", (Object)xops_filename);
            this.logger.error("", (Throwable)e);
            return -1;
        }
        if (create_backup_flag) {
            String date = DateFunctions.GetDateStringWithoutDelimiters();
            String filename_without_extension = FilenameFunctions.GetFilenameWithoutExtension((String)xops_filename);
            String backup_filename = filename_without_extension + "_" + date + ".exe";
            try {
                FileFunctions.CreateBinFile((String)backup_filename, (List)bin);
            }
            catch (IOException e) {
                this.logger.error("Failed to create a backup file.", (Throwable)e);
                return -1;
            }
        }
        XOPSExeWeaponDataWriter weapon_data_writer = new XOPSExeWeaponDataWriter(this.weapon_data_array);
        XOPSExeCharacterDataWriter character_data_writer = new XOPSExeCharacterDataWriter(this.character_data_array);
        XOPSVersion version = XOPSExeFunctions.GetXOPSVersion(bin);
        switch (version) {
            case XOPS096: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS096T: {
                weapon_data_start_pos = 381740;
                weapon_name_start_pos = 418276;
                character_data_start_pos = 383076;
                break;
            }
            case XOPS097FT: {
                weapon_data_start_pos = 385836;
                weapon_name_start_pos = 422372;
                character_data_start_pos = 387172;
                break;
            }
            case XOPS0975T: {
                weapon_data_start_pos = 491440;
                weapon_name_start_pos = 495936;
                character_data_start_pos = 492776;
                break;
            }
            case XOPSOLT18F2: {
                weapon_data_start_pos = 418828;
                weapon_name_start_pos = 454532;
                character_data_start_pos = 420164;
                break;
            }
            case XOPSOLT19F2: {
                weapon_data_start_pos = 489448;
                weapon_name_start_pos = 488304;
                character_data_start_pos = 490784;
                break;
            }
            default: {
                weapon_data_start_pos = 0;
                weapon_name_start_pos = 0;
                character_data_start_pos = 0;
            }
        }
        weapon_data_writer.Write(bin, weapon_data_start_pos, weapon_name_start_pos);
        character_data_writer.Write(bin, character_data_start_pos);
        try {
            FileFunctions.CreateBinFile((String)xops_filename, (List)bin);
        }
        catch (IOException e) {
            this.logger.error("Failed to write in an EXE file. exe_filename={}", (Object)xops_filename);
            return -1;
        }
        return 0;
    }

    public int Write(String xops_filename, int weapon_data_start_pos, int weapon_name_start_pos, int character_data_start_pos, boolean create_backup_flag) {
        List bin;
        try {
            bin = FileFunctions.GetFileAllBin((String)xops_filename);
        }
        catch (IOException e) {
            this.logger.error("Failed to write in an EXE file. exe_filename={}", (Object)xops_filename);
            this.logger.error("", (Throwable)e);
            return -1;
        }
        if (create_backup_flag) {
            String date = DateFunctions.GetDateStringWithoutDelimiters();
            String filename_without_extension = FilenameFunctions.GetFilenameWithoutExtension((String)xops_filename);
            String backup_filename = filename_without_extension + "_" + date + ".exe";
            try {
                FileFunctions.CreateBinFile((String)backup_filename, (List)bin);
            }
            catch (IOException e) {
                this.logger.error("Failed to create a backup file.", (Throwable)e);
                return -1;
            }
        }
        XOPSExeWeaponDataWriter weapon_data_writer = new XOPSExeWeaponDataWriter(this.weapon_data_array);
        XOPSExeCharacterDataWriter character_data_writer = new XOPSExeCharacterDataWriter(this.character_data_array);
        try {
            weapon_data_writer.Write(bin, weapon_data_start_pos, weapon_name_start_pos);
            character_data_writer.Write(bin, character_data_start_pos);
        }
        catch (IndexOutOfBoundsException e) {
            this.logger.error("Error while writing.", (Throwable)e);
            return -1;
        }
        try {
            FileFunctions.CreateBinFile((String)xops_filename, (List)bin);
        }
        catch (IOException e) {
            this.logger.error("Failed to write in an EXE file. exe_filename={}", (Object)xops_filename);
            return -1;
        }
        return 0;
    }
}

