/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.config;

import com.github.dabasan.xops.properties.config.Config;
import com.github.dabasan.xops.properties.config.ConfigParser;
import com.github.dabasan.xops.properties.config.ConfigWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ConfigManipulator {
    private final Logger logger = LoggerFactory.getLogger(ConfigManipulator.class);
    private Config config;

    public ConfigManipulator(String config_filename) throws IOException {
        ConfigParser config_parser = new ConfigParser(config_filename);
        this.config = config_parser.GetConfig();
    }

    public ConfigManipulator() {
        this.config = new Config();
    }

    public void SetConfig(Config config) {
        if (config == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.config = config;
    }

    public Config GetConfig() {
        return new Config(this.config);
    }

    public int Write(String config_filename) {
        ConfigWriter config_writer = new ConfigWriter(this.config);
        int ret = config_writer.Write(config_filename);
        if (ret < 0) {
            this.logger.error("Failed to write in a config file. config_filename={}", (Object)config_filename);
            return -1;
        }
        return 0;
    }
}

