/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.xms.ids;

import com.github.dabasan.basis.vector.Vector;
import com.github.dabasan.tool.ByteFunctions;
import com.github.dabasan.tool.FileFunctions;
import com.github.dabasan.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.github.dabasan.xops.properties.entity.weapon.WeaponData;
import com.github.dabasan.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.github.dabasan.xops.properties.entity.weapon.WeaponModelType;
import com.github.dabasan.xops.properties.entity.weapon.WeaponScopeMode;
import com.github.dabasan.xops.properties.entity.weapon.WeaponShootingStance;
import com.github.dabasan.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.github.dabasan.xops.properties.entity.weapon.WeaponTextureType;
import java.io.IOException;
import java.util.ArrayList;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IDSWriter {
    private final Logger logger = LoggerFactory.getLogger(IDSWriter.class);
    private final WeaponData weapon_data;

    public IDSWriter(WeaponData weapon_data) {
        this.weapon_data = weapon_data;
    }

    public int Write(String ids_filename) {
        int i;
        if (this.weapon_data == null) {
            this.logger.warn("Data not prepared.");
            return -1;
        }
        ArrayList<Byte> bin = new ArrayList<Byte>();
        bin.add((byte)73);
        bin.add((byte)68);
        bin.add((byte)83);
        bin.add((byte)0);
        bin.add((byte)1);
        bin.add((byte)0);
        bin.add((byte)10);
        bin.add((byte)0);
        bin.add((byte)29);
        bin.add((byte)0);
        int itemp = this.weapon_data.GetAttackPower();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetPenetration();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetFiringInterval();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetBulletSpeed();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetNumberOfBullets();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetReloadingTime();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetRecoil();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetErrorRangeMin();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetErrorRangeMax();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        Vector vtemp = this.weapon_data.GetPosition();
        itemp = Math.round(vtemp.GetX());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(vtemp.GetY());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(vtemp.GetZ());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        vtemp = this.weapon_data.GetFlashPosition();
        itemp = Math.round(vtemp.GetX());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(vtemp.GetY());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(vtemp.GetZ());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        vtemp = this.weapon_data.GetCartridgePosition();
        itemp = Math.round(vtemp.GetX());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(vtemp.GetY());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(vtemp.GetZ());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        WeaponShootingStance shooting_stance = this.weapon_data.GetShootingStance();
        itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponShootingStance(shooting_stance);
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = !this.weapon_data.GetRapidFireEnabledFlag() ? 1 : 0;
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        WeaponScopeMode scope_mode = this.weapon_data.GetScopeMode();
        itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponScopeMode(scope_mode);
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        String texture_filename = this.weapon_data.GetTextureFilename();
        WeaponTextureType texture_type = WeaponTextureFilenamesStock.GetWeaponTextureTypeFromFilename(texture_filename);
        itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponTextureType(texture_type);
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        String model_filename = this.weapon_data.GetModelFilename();
        WeaponModelType model_type = WeaponModelFilenamesStock.GetWeaponModelTypeFromFilename(model_filename);
        itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponModelType(model_type);
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(this.weapon_data.GetScale() * 10.0f);
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        vtemp = this.weapon_data.GetCartridgeVelocity();
        itemp = Math.round(vtemp.GetX());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = Math.round(vtemp.GetY());
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetSoundID();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = this.weapon_data.GetSoundVolume();
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        itemp = !this.weapon_data.GetSuppressorEnabledFlag() ? 0 : 1;
        ByteFunctions.AddShortValueToBin_LE(bin, (short)((short)itemp));
        String name = this.weapon_data.GetName();
        byte[] name_buffer = new byte[16];
        for (i = 0; i < 16; ++i) {
            name_buffer[i] = 0;
        }
        for (i = 0; i < name.length() && i < 15; ++i) {
            name_buffer[i] = (byte)name.charAt(i);
        }
        for (i = 0; i < 16; ++i) {
            bin.add(name_buffer[i]);
        }
        try {
            FileFunctions.CreateBinFile((String)ids_filename, bin);
        }
        catch (IOException e) {
            this.logger.error("Error while writing.", (Throwable)e);
            return -1;
        }
        return 0;
    }
}

