/*
 * Decompiled with CFR 0.152.
 */
package com.github.dabasan.xops.properties.xms.ids;

import com.github.dabasan.basis.vector.Vector;
import com.github.dabasan.tool.ByteFunctions;
import com.github.dabasan.tool.FileFunctions;
import com.github.dabasan.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.github.dabasan.xops.properties.entity.weapon.WeaponData;
import com.github.dabasan.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.github.dabasan.xops.properties.entity.weapon.WeaponModelType;
import com.github.dabasan.xops.properties.entity.weapon.WeaponScopeMode;
import com.github.dabasan.xops.properties.entity.weapon.WeaponShootingStance;
import com.github.dabasan.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.github.dabasan.xops.properties.entity.weapon.WeaponTextureType;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class IDSParser {
    private final Logger logger = LoggerFactory.getLogger(IDSParser.class);
    private WeaponData weapon_data;

    public IDSParser(String ids_filename) throws IOException {
        List bin = FileFunctions.GetFileAllBin((String)ids_filename);
        this.weapon_data = new WeaponData();
        if (bin.size() != 84) {
            this.logger.warn("Invalid file size. ids_filename={}", (Object)ids_filename);
            return;
        }
        int pos = 10;
        short itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)pos);
        this.weapon_data.SetAttackPower(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetPenetration(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetFiringInterval(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetBulletSpeed(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetNumberOfBullets(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetReloadingTime(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetRecoil(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetErrorRangeMin(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetErrorRangeMax(itemp);
        Vector vtemp = new Vector();
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetX((float)itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetY((float)itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetZ((float)itemp);
        this.weapon_data.SetPosition(vtemp);
        vtemp = new Vector();
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetX((float)itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetY((float)itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetZ((float)itemp);
        this.weapon_data.SetFlashPosition(vtemp);
        vtemp = new Vector();
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetX((float)itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetY((float)itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetZ((float)itemp);
        this.weapon_data.SetCartridgePosition(vtemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        WeaponShootingStance shooting_stance = WeaponBinSpecifierAndEnumConverter.GetWeaponShootingStanceFromBinSpecifier(itemp);
        this.weapon_data.SetShootingStance(shooting_stance);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        if (itemp == 0) {
            this.weapon_data.SetRapidFireEnabledFlag(true);
        } else {
            this.weapon_data.SetRapidFireEnabledFlag(false);
        }
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        WeaponScopeMode scope_mode = WeaponBinSpecifierAndEnumConverter.GetWeaponScopeModeFromBinSpecifier(itemp);
        this.weapon_data.SetScopeMode(scope_mode);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        WeaponTextureType texture_type = WeaponBinSpecifierAndEnumConverter.GetWeaponTextureTypeFromBinSpecifier(itemp);
        String texture_filename = WeaponTextureFilenamesStock.GetTextureFilename(texture_type);
        this.weapon_data.SetTextureFilename(texture_filename);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        WeaponModelType model_type = WeaponBinSpecifierAndEnumConverter.GetWeaponModelTypeFromBinSpecifier(itemp);
        String model_filename = WeaponModelFilenamesStock.GetModelFilename(model_type);
        this.weapon_data.SetModelFilename(model_filename);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetScale((float)itemp * 0.1f);
        vtemp = new Vector();
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetX((float)itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        vtemp.SetY((float)itemp);
        vtemp.SetZ(0.0f);
        this.weapon_data.SetCartridgeVelocity(vtemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetSoundID(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        this.weapon_data.SetSoundVolume(itemp);
        itemp = ByteFunctions.GetShortValueFromBin_LE((List)bin, (int)(pos += 2));
        if (itemp == 0) {
            this.weapon_data.SetSuppressorEnabledFlag(false);
        } else {
            this.weapon_data.SetSuppressorEnabledFlag(true);
        }
        pos += 2;
        byte[] name_buffer = new byte[16];
        for (int i = 0; i < 15; ++i) {
            name_buffer[i] = (Byte)bin.get(pos + i);
        }
        name_buffer[15] = 0;
        String strtemp = new String(name_buffer);
        int first_null_pos = 15;
        for (int i = 0; i < 16; ++i) {
            if (strtemp.charAt(i) != '\u0000') continue;
            first_null_pos = i;
            break;
        }
        strtemp = strtemp.substring(0, first_null_pos);
        this.weapon_data.SetName(strtemp);
        this.weapon_data.SetChangeableWeapon(-1);
    }

    public WeaponData GetWeaponData() {
        return this.weapon_data;
    }
}

