/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xms.xgs;

import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.xms.xgs.XGSParser;
import com.daxie.xops.properties.xms.xgs.XGSWriter;
import java.io.IOException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class XGSManipulator {
    private Logger logger = LoggerFactory.getLogger(XGSManipulator.class);
    private WeaponData[] weapon_data_array = null;

    public XGSManipulator(String xgs_filename) throws IOException {
        XGSParser xgs_parser = new XGSParser(xgs_filename);
        this.weapon_data_array = xgs_parser.GetWeaponDataArray();
    }

    public XGSManipulator() {
    }

    public WeaponData[] GetWeaponDataArray() {
        if (this.weapon_data_array == null) {
            return null;
        }
        WeaponData[] ret = new WeaponData[this.weapon_data_array.length];
        for (int i = 0; i < ret.length; ++i) {
            ret[i] = new WeaponData(this.weapon_data_array[i]);
        }
        return ret;
    }

    public void SetWeaponDataArray(WeaponData[] weapon_data_array) {
        if (weapon_data_array == null) {
            this.logger.warn("Null argument where non-null required.");
            return;
        }
        this.weapon_data_array = weapon_data_array;
    }

    public int Write(String xgs_filename) {
        XGSWriter xgs_writer = new XGSWriter(this.weapon_data_array);
        int ret = xgs_writer.Write(xgs_filename);
        if (ret < 0) {
            this.logger.error("Failed to write data in a XGS file. xgs_filename={}", (Object)xgs_filename);
            return -1;
        }
        return 0;
    }
}

