/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.openxops;

import com.daxie.basis.vector.Vector;
import com.daxie.tool.StringFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.openxops.WeaponSpecifierConverter;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WeaponDataCodeOutputter {
    private Logger logger = LoggerFactory.getLogger(WeaponDataCodeOutputter.class);
    private List<WeaponData> weapon_data_list;

    public WeaponDataCodeOutputter(List<WeaponData> weapon_data_list) {
        this.weapon_data_list = weapon_data_list;
    }

    public String GetWeaponDataSourceCode() {
        String ret = "";
        if (this.weapon_data_list == null) {
            this.logger.warn("Data not prepared.");
            return ret;
        }
        String array_name = "Weapon";
        String separator = System.getProperty("line.separator");
        for (int i = 0; i < this.weapon_data_list.size(); ++i) {
            WeaponData weapon_data = this.weapon_data_list.get(i);
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"name", (String)weapon_data.GetName()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"model", (String)weapon_data.GetModelFilename()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"texture", (String)weapon_data.GetTextureFilename()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"attacks", (int)weapon_data.GetAttackPower()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"penetration", (int)weapon_data.GetPenetration()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"blazings", (int)weapon_data.GetFiringInterval()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"speed", (int)weapon_data.GetBulletSpeed()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"nbsmax", (int)weapon_data.GetNumberOfBullets()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"reloads", (int)weapon_data.GetReloadingTime()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"reaction", (int)weapon_data.GetRecoil()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"ErrorRangeMIN", (int)weapon_data.GetErrorRangeMin()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"ErrorRangeMAX", (int)weapon_data.GetErrorRangeMax()) + separator;
            Vector position = weapon_data.GetPosition();
            Vector flash_position = weapon_data.GetFlashPosition();
            Vector cartridge_position = weapon_data.GetCartridgePosition();
            Vector cartridge_velocity = weapon_data.GetCartridgeVelocity();
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"mx", (float)position.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"my", (float)position.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"mz", (float)position.GetZ()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"flashx", (float)flash_position.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"flashy", (float)flash_position.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"flashz", (float)flash_position.GetZ()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"yakkyou_px", (float)cartridge_position.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"yakkyou_py", (float)cartridge_position.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"yakkyou_pz", (float)cartridge_position.GetZ()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"yakkyou_sx", (float)cartridge_velocity.GetX()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"yakkyou_sy", (float)cartridge_velocity.GetY()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"blazingmode", (boolean)weapon_data.GetRapidFireEnabledFlag()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"scopemode", (int)weapon_data.GetScopeMode().ordinal()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"size", (float)weapon_data.GetScale()) + separator;
            int sound_id = weapon_data.GetSoundID();
            sound_id = WeaponSpecifierConverter.GetOpenXOPSSoundIDFromXOPSSoundID(sound_id);
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"soundid", (int)sound_id) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"soundvolume", (int)weapon_data.GetSoundVolume()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"silencer", (boolean)weapon_data.GetSuppressorEnabledFlag()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"WeaponP", (int)weapon_data.GetShootingStance().ordinal()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"ChangeWeapon", (int)weapon_data.GetChangeableWeapon()) + separator;
            ret = ret + StringFunctions.GetCPPArrayFormatString((String)"Weapon", (int)i, (String)"burst", (int)weapon_data.GetNumberOfProjectiles()) + separator;
        }
        return ret;
    }
}

