/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.exe;

import com.daxie.tool.ByteFunctions;
import com.daxie.xops.properties.entity.character.CharacterAILevel;
import com.daxie.xops.properties.entity.character.CharacterBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.character.CharacterData;
import com.daxie.xops.properties.entity.character.CharacterModelType;
import com.daxie.xops.properties.entity.character.CharacterTextureType;
import com.daxie.xops.properties.entity.character.CharacterType;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class XOPSExeCharacterDataWriter {
    private Logger logger = LoggerFactory.getLogger(XOPSExeCharacterDataWriter.class);
    private CharacterData[] character_data_array;

    public XOPSExeCharacterDataWriter(CharacterData[] character_data_array) {
        this.character_data_array = character_data_array;
    }

    public int Write(List<Byte> bin, int character_data_start_pos) {
        if (this.character_data_array == null) {
            this.logger.warn("Data not prepared.");
            return -1;
        }
        if (this.character_data_array.length != 43) {
            this.logger.warn("Invalid number of data. data_num={}", (Object)this.character_data_array.length);
            return -1;
        }
        int pos = character_data_start_pos;
        for (int i = 0; i < 43; ++i) {
            CharacterTextureType texture_type = this.character_data_array[i].GetTextureType();
            int itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterTextureType(texture_type);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)pos, (short)((short)itemp));
            CharacterModelType model_type = this.character_data_array[i].GetModelType();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterModelType(model_type);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.character_data_array[i].GetHP();
            ByteFunctions.SetUShortValueToBin_LE(bin, (int)(pos += 2), (int)itemp);
            CharacterAILevel ai_level = this.character_data_array[i].GetAILevel();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterAILevel(ai_level);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.character_data_array[i].GetWeaponID(0);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            itemp = this.character_data_array[i].GetWeaponID(1);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            CharacterType type = this.character_data_array[i].GetType();
            itemp = CharacterBinSpecifierAndEnumConverter.GetBinSpecifierFromCharacterType(type);
            ByteFunctions.SetShortValueToBin_LE(bin, (int)(pos += 2), (short)((short)itemp));
            pos += 2;
        }
        return 0;
    }
}

