/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.entity.character;

import com.daxie.xops.properties.entity.character.CharacterAILevel;
import com.daxie.xops.properties.entity.character.CharacterModelType;
import com.daxie.xops.properties.entity.character.CharacterTextureType;
import com.daxie.xops.properties.entity.character.CharacterType;
import java.util.HashMap;
import java.util.Map;

public class CharacterData {
    private CharacterModelType model_type;
    private CharacterTextureType texture_type;
    private int hp;
    private CharacterAILevel ai_level;
    private Map<Integer, Integer> weapon_ids_map;
    private CharacterType type;

    public CharacterData() {
        this.model_type = CharacterModelType.MALE;
        this.texture_type = CharacterTextureType.SOLDIER_BLACK;
        this.hp = 100;
        this.ai_level = CharacterAILevel.D;
        this.weapon_ids_map = new HashMap<Integer, Integer>();
        this.weapon_ids_map.put(0, 0);
        this.weapon_ids_map.put(1, 0);
        this.type = CharacterType.HUMAN;
    }

    public CharacterData(CharacterData c) {
        this.model_type = c.GetModelType();
        this.texture_type = c.GetTextureType();
        this.hp = c.GetHP();
        this.ai_level = c.GetAILevel();
        this.weapon_ids_map = c.GetWeaponIDsMap();
        this.type = c.GetType();
    }

    public String toString() {
        String ret = "";
        String separator = System.getProperty("line.separator");
        ret = ret + "model_type:" + this.model_type.toString() + separator;
        ret = ret + "texture_type:" + this.texture_type.toString() + separator;
        ret = ret + "hp:" + this.hp + separator;
        ret = ret + "ai_level:" + this.ai_level.toString() + separator;
        ret = ret + "weapon_ids:";
        for (int i = 0; i < this.weapon_ids_map.size(); ++i) {
            if (!this.weapon_ids_map.containsKey(i)) continue;
            ret = ret + this.weapon_ids_map.get(i);
            if (i == this.weapon_ids_map.size() - 1) continue;
            ret = ret + ",";
        }
        ret = ret + separator;
        ret = ret + "type:" + this.type.toString();
        return ret;
    }

    public void SetModelType(CharacterModelType model_type) {
        this.model_type = model_type;
    }

    public void SetTextureType(CharacterTextureType texture_type) {
        this.texture_type = texture_type;
    }

    public void SetHP(int hp) {
        this.hp = hp;
    }

    public void SetAILevel(CharacterAILevel ai_level) {
        this.ai_level = ai_level;
    }

    public void SetWeaponID(int i, int weapon_id) {
        this.weapon_ids_map.put(i, weapon_id);
    }

    public void SetType(CharacterType type) {
        this.type = type;
    }

    public CharacterModelType GetModelType() {
        return this.model_type;
    }

    public CharacterTextureType GetTextureType() {
        return this.texture_type;
    }

    public int GetHP() {
        return this.hp;
    }

    public CharacterAILevel GetAILevel() {
        return this.ai_level;
    }

    public int GetWeaponID(int index) {
        if (!this.weapon_ids_map.containsKey(index)) {
            return 0;
        }
        return this.weapon_ids_map.get(index);
    }

    public Map<Integer, Integer> GetWeaponIDsMap() {
        return new HashMap<Integer, Integer>(this.weapon_ids_map);
    }

    public CharacterType GetType() {
        return this.type;
    }

    public boolean WeaponIDExists(int index) {
        return this.weapon_ids_map.containsKey(index);
    }
}

