/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.config;

import com.daxie.tool.FileFunctions;
import com.daxie.xops.properties.config.Config;
import com.daxie.xops.properties.config.KeyCode;
import com.daxie.xops.properties.config.WindowMode;
import java.io.IOException;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ConfigParser {
    private Logger logger = LoggerFactory.getLogger(ConfigParser.class);
    private Config config = new Config();

    public ConfigParser(String config_filename) throws IOException {
        List bin = FileFunctions.GetFileAllBin((String)config_filename);
        if (bin.size() != 47) {
            this.logger.warn("Invalid file size. config_filename={}", (Object)config_filename);
            return;
        }
        this.config.SetTurnUp(this.GetKeyCodeFromBin(bin, 0));
        this.config.SetTurnDown(this.GetKeyCodeFromBin(bin, 1));
        this.config.SetTurnLeft(this.GetKeyCodeFromBin(bin, 2));
        this.config.SetTurnRight(this.GetKeyCodeFromBin(bin, 3));
        this.config.SetMoveForward(this.GetKeyCodeFromBin(bin, 4));
        this.config.SetMoveBackward(this.GetKeyCodeFromBin(bin, 5));
        this.config.SetMoveLeft(this.GetKeyCodeFromBin(bin, 6));
        this.config.SetMoveRight(this.GetKeyCodeFromBin(bin, 7));
        this.config.SetWalk(this.GetKeyCodeFromBin(bin, 8));
        this.config.SetJump(this.GetKeyCodeFromBin(bin, 9));
        this.config.SetReload(this.GetKeyCodeFromBin(bin, 10));
        this.config.SetDropWeapon(this.GetKeyCodeFromBin(bin, 11));
        this.config.SetZoom(this.GetKeyCodeFromBin(bin, 12));
        this.config.SetFireMode(this.GetKeyCodeFromBin(bin, 13));
        this.config.SetSwitchWeapon(this.GetKeyCodeFromBin(bin, 14));
        this.config.SetWeapon1(this.GetKeyCodeFromBin(bin, 15));
        this.config.SetWeapon2(this.GetKeyCodeFromBin(bin, 16));
        this.config.SetFire(this.GetKeyCodeFromBin(bin, 17));
        this.config.SetMouseSensitivity(Byte.toUnsignedInt((Byte)bin.get(18)));
        this.config.SetWindowMode(this.GetWindowModeFromBin(bin, 19));
        this.config.SetEnableSound(this.GetFlagFromBin(bin, 20));
        this.config.SetEnableBlood(this.GetFlagFromBin(bin, 21));
        this.config.SetBrightness(Byte.toUnsignedInt((Byte)bin.get(22)));
        this.config.SetInvertMouse(this.GetFlagFromBin(bin, 23));
        this.config.SetFrameSkip(this.GetFlagFromBin(bin, 24));
        this.config.SetAnotherGunsight(this.GetFlagFromBin(bin, 25));
        this.config.SetName(this.GetNameFromBin(bin));
    }

    private KeyCode GetKeyCodeFromBin(List<Byte> bin, int pos) {
        KeyCode ret;
        KeyCode[] values = KeyCode.values();
        int key_index = Byte.toUnsignedInt(bin.get(pos));
        if (0 <= key_index && key_index < values.length) {
            ret = values[key_index];
        } else {
            this.logger.warn("Key index out of bounds. pos={}", (Object)pos);
            ret = KeyCode.KEY_UP;
        }
        return ret;
    }

    private boolean GetFlagFromBin(List<Byte> bin, int pos) {
        int i = Byte.toUnsignedInt(bin.get(pos));
        return i != 0;
    }

    private WindowMode GetWindowModeFromBin(List<Byte> bin, int pos) {
        int i = Byte.toUnsignedInt(bin.get(pos));
        WindowMode ret = i == 0 ? WindowMode.WINDOW : WindowMode.FULL_SCREEN;
        return ret;
    }

    private String GetNameFromBin(List<Byte> bin) {
        byte[] name_buffer = new byte[21];
        for (int i = 0; i < 20; ++i) {
            name_buffer[i] = bin.get(26 + i);
        }
        name_buffer[20] = 0;
        String ret = new String(name_buffer);
        int first_null_pos = 20;
        for (int i = 0; i < 20; ++i) {
            if (ret.charAt(i) != '\u0000') continue;
            first_null_pos = i;
            break;
        }
        ret = ret.substring(0, first_null_pos);
        return ret;
    }

    public Config GetConfig() {
        return new Config(this.config);
    }
}

