/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xml;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogWriter;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;
import com.daxie.xops.properties.openxops.WeaponSpecifierConverter;
import java.nio.file.Paths;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class WeaponDataXMLParser {
    private Map<Integer, WeaponData> weapon_data_map = new HashMap<Integer, WeaponData>();
    private boolean openxops_compatible_flag = true;

    public void SetOpenXOPSCompatibleFlag(boolean openxops_compatible_flag) {
        this.openxops_compatible_flag = openxops_compatible_flag;
    }

    public int LoadWeaponDataXML(String xml_filename) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogWriter.WriteWarn((String)"[WeaponDataXMLParser-LoadWeaponDataXML] Below is the stack trace.", (boolean)true);
            LogWriter.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        Document document = null;
        try {
            document = builder.parse(Paths.get(xml_filename, new String[0]).toFile());
        }
        catch (Exception e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogWriter.WriteWarn((String)"[WeaponDataXMLParser-LoadWeaponDataXML] Below is the stack trace.", (boolean)true);
            LogWriter.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        Element el_weapon_data_list = document.getDocumentElement();
        NodeList node_list = el_weapon_data_list.getChildNodes();
        for (int i = 0; i < node_list.getLength(); ++i) {
            Element element;
            String element_name;
            Node node = node_list.item(i);
            if (node.getNodeType() != 1 || !(element_name = (element = (Element)node).getNodeName()).equals("weapon")) continue;
            int weapon_id = -1;
            WeaponData weapon_data = new WeaponData();
            String strtemp = element.getAttribute("id");
            try {
                weapon_id = Integer.parseInt(strtemp);
            }
            catch (NumberFormatException e) {
                LogWriter.WriteWarn((String)("[WeaponDataXMLParser-LoadWeaponDataXML] Invalid format of number. id:" + strtemp), (boolean)true);
                continue;
            }
            NodeList node_list_sub = element.getChildNodes();
            for (int j = 0; j < node_list_sub.getLength(); ++j) {
                String str;
                Enum[] values;
                Vector vtemp;
                float ftemp;
                int itemp;
                Node node_sub = node_list_sub.item(j);
                if (node_sub.getNodeType() != 1) continue;
                Element element_sub = (Element)node_sub;
                String element_sub_name = element_sub.getNodeName();
                strtemp = element_sub.getTextContent();
                if (element_sub_name.equals("name")) {
                    weapon_data.SetName(strtemp);
                    continue;
                }
                if (element_sub_name.equals("model")) {
                    weapon_data.SetModelFilename(strtemp);
                    continue;
                }
                if (element_sub_name.equals("texture")) {
                    weapon_data.SetTextureFilename(strtemp);
                    continue;
                }
                if (element_sub_name.equals("attacks")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetAttackPower(itemp);
                    continue;
                }
                if (element_sub_name.equals("penetration")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetPenetration(itemp);
                    continue;
                }
                if (element_sub_name.equals("blazings")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetFiringInterval(itemp);
                    continue;
                }
                if (element_sub_name.equals("speed")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetBulletSpeed(itemp);
                    continue;
                }
                if (element_sub_name.equals("nbsmax")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetNumberOfBullets(itemp);
                    continue;
                }
                if (element_sub_name.equals("reloads")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetReloadingTime(itemp);
                    continue;
                }
                if (element_sub_name.equals("reaction")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetRecoil(itemp);
                    continue;
                }
                if (element_sub_name.equals("ErrorRangeMIN")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetErrorRangeMin(itemp);
                    continue;
                }
                if (element_sub_name.equals("ErrorRangeMAX")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetErrorRangeMax(itemp);
                    continue;
                }
                if (element_sub_name.equals("mx")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetPosition();
                    vtemp.SetX(ftemp);
                    weapon_data.SetPosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("my")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetPosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetY(ftemp);
                    weapon_data.SetPosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("mz")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetPosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetZ(ftemp);
                    weapon_data.SetPosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("flashx")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetFlashPosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetX(ftemp);
                    weapon_data.SetFlashPosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("flashy")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetFlashPosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetY(ftemp);
                    weapon_data.SetFlashPosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("flashz")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetFlashPosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetZ(ftemp);
                    weapon_data.SetFlashPosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("yakkyou_px")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetCartridgePosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetX(ftemp);
                    weapon_data.SetCartridgePosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("yakkyou_py")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetCartridgePosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetY(ftemp);
                    weapon_data.SetCartridgePosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("yakkyou_pz")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetCartridgePosition();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetZ(ftemp);
                    weapon_data.SetCartridgePosition(vtemp);
                    continue;
                }
                if (element_sub_name.equals("yakkyou_sx")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetCartridgeVelocity();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetX(ftemp);
                    weapon_data.SetCartridgeVelocity(vtemp);
                    continue;
                }
                if (element_sub_name.equals("yakkyou_sy")) {
                    ftemp = Float.parseFloat(strtemp);
                    vtemp = weapon_data.GetCartridgeVelocity();
                    ftemp = Float.parseFloat(strtemp);
                    vtemp.SetY(ftemp);
                    weapon_data.SetCartridgeVelocity(vtemp);
                    continue;
                }
                if (element_sub_name.equals("blazingmode")) {
                    if (strtemp.equals("false")) {
                        weapon_data.SetRapidFireEnabledFlag(false);
                        continue;
                    }
                    weapon_data.SetRapidFireEnabledFlag(true);
                    continue;
                }
                if (element_sub_name.equals("scopemode")) {
                    itemp = Integer.parseInt(strtemp);
                    values = WeaponScopeMode.values();
                    if (0 > itemp || itemp >= values.length) {
                        LogWriter.WriteWarn((String)"[WeaponDataXMLParser-LoadWeaponDataXML] Specifier out of bounds.", (boolean)true);
                        str = "";
                        str = str + "weapon_id:" + weapon_id + " ";
                        str = str + "scope_mode:" + itemp;
                        LogWriter.WriteLine((String)str);
                        weapon_data.SetScopeMode(WeaponScopeMode.NONE);
                        continue;
                    }
                    weapon_data.SetScopeMode(values[itemp]);
                    continue;
                }
                if (element_sub_name.equals("size")) {
                    ftemp = Float.parseFloat(strtemp);
                    weapon_data.SetScale(ftemp);
                    continue;
                }
                if (element_sub_name.equals("soundid")) {
                    itemp = Integer.parseInt(strtemp);
                    if (this.openxops_compatible_flag) {
                        itemp = WeaponSpecifierConverter.GetXOPSSoundIDFromOpenXOPSSoundID(itemp);
                    }
                    weapon_data.SetSoundID(itemp);
                    continue;
                }
                if (element_sub_name.equals("soundvolume")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetSoundVolume(itemp);
                    continue;
                }
                if (element_sub_name.equals("silencer")) {
                    if (strtemp.equals("false")) {
                        weapon_data.SetSuppressorEnabledFlag(false);
                        continue;
                    }
                    weapon_data.SetSuppressorEnabledFlag(true);
                    continue;
                }
                if (element_sub_name.equals("WeaponP")) {
                    itemp = Integer.parseInt(strtemp);
                    values = WeaponShootingStance.values();
                    if (0 > itemp || itemp >= values.length) {
                        LogWriter.WriteWarn((String)"[WeaponDataXMLParser-LoadWeaponDataXML] Specifier out of bounds.", (boolean)true);
                        str = "";
                        str = str + "weapon_id:" + weapon_id + " ";
                        str = str + "shooting_stance:" + itemp;
                        LogWriter.WriteLine((String)str);
                        weapon_data.SetShootingStance(WeaponShootingStance.RIFLE);
                        continue;
                    }
                    weapon_data.SetShootingStance((WeaponShootingStance)values[itemp]);
                    continue;
                }
                if (element_sub_name.equals("ChangeWeapon")) {
                    itemp = Integer.parseInt(strtemp);
                    weapon_data.SetChangeableWeapon(itemp);
                    continue;
                }
                if (!element_sub_name.equals("burst")) continue;
                itemp = Integer.parseInt(strtemp);
                weapon_data.SetNumberOfProjectiles(itemp);
            }
            this.weapon_data_map.put(weapon_id, weapon_data);
        }
        return 0;
    }

    public Map<Integer, WeaponData> GetWeaponDataMap() {
        return new HashMap<Integer, WeaponData>(this.weapon_data_map);
    }
}

