/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.openxops;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogWriter;
import com.daxie.tool.FileFunctions;
import com.daxie.tool.StringFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;
import com.daxie.xops.properties.openxops.WeaponSpecifierConverter;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.regex.Pattern;

public class WeaponDataCodeParser {
    private Map<Integer, WeaponData> weapon_data_map = new HashMap<Integer, WeaponData>();

    public WeaponDataCodeParser(List<String> lines) {
        if (lines == null) {
            LogWriter.WriteWarn((String)"[WeaponDataCodeParser-<init>] Null argument.", (boolean)true);
            return;
        }
        this.ParseLines(lines);
    }

    public WeaponDataCodeParser(String code_filename, String encoding) throws IOException {
        List lines = FileFunctions.GetFileAllLines((String)code_filename, (String)encoding);
        this.ParseLines(lines);
    }

    private void ParseLines(List<String> lines) {
        for (int i = 0; i < lines.size(); ++i) {
            WeaponData weapon_data;
            int index;
            block83: {
                String line = lines.get(i);
                String[] split_by_equal = (line = line.replace(";", "")).split("=");
                if (split_by_equal.length != 2) {
                    LogWriter.WriteWarn((String)("[WeaponDataCodeParser-ParseLines] Syntax error. line:" + i), (boolean)true);
                    continue;
                }
                String left = split_by_equal[0];
                String[] split_by_dot = left.split(Pattern.quote("."));
                if (split_by_dot.length != 2) {
                    LogWriter.WriteWarn((String)("[WeaponDataCodeParser-ParseLines] Syntax error. line:" + i), (boolean)true);
                    continue;
                }
                String field_name = split_by_dot[1];
                field_name = field_name.replace(" ", "");
                String array_name_and_index = split_by_dot[0];
                String index_str = StringFunctions.GetFirstStringInBetween((String)array_name_and_index, (char)'[', (char)']');
                index = -1;
                try {
                    index = Integer.parseInt(index_str);
                }
                catch (NumberFormatException e) {
                    LogWriter.WriteWarn((String)("[WeaponDataCodeParser-ParseLines] Invalid index. line:" + i), (boolean)true);
                    continue;
                }
                if (index < 0) {
                    LogWriter.WriteWarn((String)"[WeaponDataCodeParser-ParseLines] Index must be a number of 0 or more.", (boolean)true);
                    continue;
                }
                if (!this.weapon_data_map.containsKey(index)) {
                    weapon_data = new WeaponData();
                    this.weapon_data_map.put(index, weapon_data);
                }
                weapon_data = this.weapon_data_map.get(index);
                String value = split_by_equal[1];
                try {
                    switch (field_name) {
                        case "name": {
                            value = StringFunctions.GetFirstStringInBetween((String)value, (char)'\"', (char)'\"');
                            weapon_data.SetName(value);
                            break block83;
                        }
                        case "model": {
                            value = StringFunctions.GetFirstStringInBetween((String)value, (char)'\"', (char)'\"');
                            weapon_data.SetModelFilename(value);
                            break block83;
                        }
                        case "texture": {
                            value = StringFunctions.GetFirstStringInBetween((String)value, (char)'\"', (char)'\"');
                            weapon_data.SetTextureFilename(value);
                            break block83;
                        }
                        case "attacks": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetAttackPower(itemp);
                            break block83;
                        }
                        case "penetration": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetPenetration(itemp);
                            break block83;
                        }
                        case "blazings": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetFiringInterval(itemp);
                            break block83;
                        }
                        case "speed": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetBulletSpeed(itemp);
                            break block83;
                        }
                        case "nbsmax": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetNumberOfBullets(itemp);
                            break block83;
                        }
                        case "reloads": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetReloadingTime(itemp);
                            break block83;
                        }
                        case "reaction": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetRecoil(itemp);
                            break block83;
                        }
                        case "ErrorRangeMIN": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetErrorRangeMin(itemp);
                            break block83;
                        }
                        case "ErrorRangeMAX": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetErrorRangeMax(itemp);
                            break block83;
                        }
                        case "mx": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetPosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetX(ftemp);
                            weapon_data.SetPosition(vtemp);
                            break block83;
                        }
                        case "my": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetPosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetY(ftemp);
                            weapon_data.SetPosition(vtemp);
                            break block83;
                        }
                        case "mz": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetPosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetZ(ftemp);
                            weapon_data.SetPosition(vtemp);
                            break block83;
                        }
                        case "flashx": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetFlashPosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetX(ftemp);
                            weapon_data.SetFlashPosition(vtemp);
                            break block83;
                        }
                        case "flashy": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetFlashPosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetY(ftemp);
                            weapon_data.SetFlashPosition(vtemp);
                            break block83;
                        }
                        case "flashz": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetFlashPosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetZ(ftemp);
                            weapon_data.SetFlashPosition(vtemp);
                            break block83;
                        }
                        case "yakkyou_px": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetCartridgePosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetX(ftemp);
                            weapon_data.SetCartridgePosition(vtemp);
                            break block83;
                        }
                        case "yakkyou_py": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetCartridgePosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetY(ftemp);
                            weapon_data.SetCartridgePosition(vtemp);
                            break block83;
                        }
                        case "yakkyou_pz": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetCartridgePosition();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetZ(ftemp);
                            weapon_data.SetCartridgePosition(vtemp);
                            break block83;
                        }
                        case "yakkyou_sx": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetCartridgeVelocity();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetX(ftemp);
                            weapon_data.SetCartridgeVelocity(vtemp);
                            break block83;
                        }
                        case "yakkyou_sy": {
                            value = value.replace(" ", "");
                            Vector vtemp = weapon_data.GetCartridgeVelocity();
                            float ftemp = Float.parseFloat(value);
                            vtemp.SetY(ftemp);
                            weapon_data.SetCartridgeVelocity(vtemp);
                            break block83;
                        }
                        case "blazingmode": {
                            value = value.replace(" ", "");
                            if (value.equals("false")) {
                                weapon_data.SetRapidFireEnabledFlag(false);
                                break block83;
                            }
                            if (value.equals("true")) {
                                weapon_data.SetRapidFireEnabledFlag(true);
                                break block83;
                            }
                            LogWriter.WriteWarn((String)("[WeaponDaraCodeParser-ParseLines] Invalid value. line:" + i), (boolean)true);
                            break;
                        }
                        case "scopemode": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            WeaponScopeMode[] scope_modes = WeaponScopeMode.values();
                            if (0 > itemp || itemp >= scope_modes.length) {
                                LogWriter.WriteWarn((String)("[WeaponDataCodeParser-ParseLines] Value out of bounds. line:" + i), (boolean)true);
                                break;
                            }
                            weapon_data.SetScopeMode(scope_modes[itemp]);
                            break block83;
                        }
                        case "size": {
                            value = value.replace(" ", "");
                            float ftemp = Float.parseFloat(value);
                            weapon_data.SetScale(ftemp);
                            break block83;
                        }
                        case "soundid": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            itemp = WeaponSpecifierConverter.GetXOPSSoundIDFromOpenXOPSSoundID(itemp);
                            weapon_data.SetSoundID(itemp);
                            break block83;
                        }
                        case "soundvolume": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetSoundVolume(itemp);
                            break block83;
                        }
                        case "silencer": {
                            value = value.replace(" ", "");
                            if (value.equals("false")) {
                                weapon_data.SetSuppressorEnabledFlag(false);
                                break block83;
                            }
                            if (value.equals("true")) {
                                weapon_data.SetSuppressorEnabledFlag(true);
                                break block83;
                            }
                            LogWriter.WriteWarn((String)("[WeaponDaraCodeParser-ParseLines] Invalid value. line:" + i), (boolean)true);
                            break;
                        }
                        case "WeaponP": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            WeaponShootingStance[] shooting_stances = WeaponShootingStance.values();
                            if (0 > itemp || itemp >= shooting_stances.length) {
                                LogWriter.WriteWarn((String)("[WeaponDataCodeParser-ParseLines] Value out of bounds. line:" + i), (boolean)true);
                                break;
                            }
                            weapon_data.SetShootingStance(shooting_stances[itemp]);
                            break block83;
                        }
                        case "ChangeWeapon": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetChangeableWeapon(itemp);
                            break block83;
                        }
                        case "burst": {
                            value = value.replace(" ", "");
                            int itemp = Integer.parseInt(value);
                            weapon_data.SetNumberOfProjectiles(itemp);
                            break block83;
                        }
                        default: {
                            LogWriter.WriteWarn((String)("[WeaponDataCodeParser-ParseLines] Unknown field name. line:" + i), (boolean)true);
                            break;
                        }
                    }
                }
                catch (NumberFormatException e) {
                    LogWriter.WriteWarn((String)("[WeaponDataCodeParser-ParseLines] Invalid number format. line:" + i), (boolean)true);
                }
                continue;
            }
            this.weapon_data_map.put(index, weapon_data);
        }
    }

    public HashMap<Integer, WeaponData> GetWeaponDataMap() {
        return new HashMap<Integer, WeaponData>(this.weapon_data_map);
    }

    public TreeMap<Integer, WeaponData> GetWeaponDataOrderedMap() {
        return new TreeMap<Integer, WeaponData>(this.weapon_data_map);
    }
}

