package com.daxie.xops.properties.xms.ids;

import java.io.IOException;

import com.daxie.log.LogWriter;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponData;

/**
 * Manipulates an IDS file.
 * @author Daba
 *
 */
public class IDSManipulator {
	private WeaponData weapon_data=null;
	
	/**
	 * 
	 * @param ids_filename IDS filename to load
	 * @throws IOException
	 */
	public IDSManipulator(String ids_filename) throws IOException{
		IDSParser ids_parser=new IDSParser(ids_filename);
		weapon_data=ids_parser.GetWeaponData();
	}
	public IDSManipulator() {
		
	}
	
	/**
	 * Returns weapon data.
	 * @return Weapon data
	 */
	public WeaponData GetWeaponData() {
		if(weapon_data==null)return null;
		return new WeaponData(weapon_data);
	}
	/**
	 * Sets weapon data.
	 * @param weapon_data Weapon data
	 */
	public void SetWeaponData(WeaponData weapon_data) {
		if(weapon_data==null) {
			LogWriter.WriteWarn("[IDSManipulator-SetWeaponData] Null argument where non-null required.",true);
			return;
		}
		this.weapon_data=weapon_data;
	}
	
	/**
	 * Writes out data to an IDS file.
	 * @param ids_filename Filename
	 * @return -1 on error and 0 on success
	 */
	public int Write(String ids_filename) {
		IDSWriter ids_writer=new IDSWriter(weapon_data);
		try {
			ids_writer.Write(ids_filename);
		}
		catch(IOException e) {
			String str=ExceptionFunctions.GetPrintStackTraceString(e);
			
			LogWriter.WriteWarn("[IDSManipulator-Write] Failed to write data.",true);
			LogWriter.WriteWarn("Below is the stack trace.",false);
			LogWriter.WriteWarn(str,false);
			
			return -1;
		}
		
		return 0;
	}
}
