/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.xml;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ExceptionFunctions;
import com.daxie.tool.XMLFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.openxops.WeaponSpecifierConverter;
import java.io.File;
import java.util.List;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;

public class WeaponDataXMLOutputter {
    private List<WeaponData> weapon_data_list;
    private boolean openxops_compatible_flag;

    public WeaponDataXMLOutputter(List<WeaponData> weapon_data_list) {
        this.weapon_data_list = weapon_data_list;
        this.openxops_compatible_flag = true;
    }

    public void SetOpenXOPSCompatibleFlag(boolean openxops_compatible_flag) {
        this.openxops_compatible_flag = openxops_compatible_flag;
    }

    public int WriteXML(String xml_filename) {
        if (this.weapon_data_list == null) {
            LogFile.WriteWarn((String)"[WeaponDataXMLOutputter-WriteXML] Data is null.", (boolean)true);
            return -1;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = null;
        try {
            builder = factory.newDocumentBuilder();
        }
        catch (ParserConfigurationException e) {
            String str = ExceptionFunctions.GetPrintStackTraceString((Throwable)e);
            LogFile.WriteWarn((String)"[WeaponDataXMLOutputter-WriteXML] Below is the stack trace.", (boolean)true);
            LogFile.WriteWarn((String)str, (boolean)false);
            return -1;
        }
        Document document = builder.newDocument();
        Element el_weapon_list = document.createElement("weapon_list");
        document.appendChild(el_weapon_list);
        int id = 0;
        for (WeaponData weapon_data : this.weapon_data_list) {
            Element el_weapon = document.createElement("weapon");
            el_weapon.setAttribute("id", "" + id);
            Element el_name = document.createElement("name");
            el_name.setTextContent(weapon_data.GetName());
            el_weapon.appendChild(el_name);
            Element el_model_filename = document.createElement("model");
            el_model_filename.setTextContent(weapon_data.GetModelFilename());
            el_weapon.appendChild(el_model_filename);
            Element el_texture_filename = document.createElement("texture");
            el_texture_filename.setTextContent(weapon_data.GetTextureFilename());
            el_weapon.appendChild(el_texture_filename);
            Element el_attack_power = document.createElement("attacks");
            el_attack_power.setTextContent("" + weapon_data.GetAttackPower());
            el_weapon.appendChild(el_attack_power);
            Element el_penetration = document.createElement("penetration");
            el_penetration.setTextContent("" + weapon_data.GetPenetration());
            el_weapon.appendChild(el_penetration);
            Element el_firing_interval = document.createElement("blazings");
            el_firing_interval.setTextContent("" + weapon_data.GetFiringInterval());
            el_weapon.appendChild(el_firing_interval);
            Element el_bullet_speed = document.createElement("speed");
            el_bullet_speed.setTextContent("" + weapon_data.GetBulletSpeed());
            el_weapon.appendChild(el_bullet_speed);
            Element el_number_of_bullets = document.createElement("nbsmax");
            el_number_of_bullets.setTextContent("" + weapon_data.GetNumberOfBullets());
            el_weapon.appendChild(el_number_of_bullets);
            Element el_reloading_time = document.createElement("reloads");
            el_reloading_time.setTextContent("" + weapon_data.GetReloadingTime());
            el_weapon.appendChild(el_reloading_time);
            Element el_recoil = document.createElement("reaction");
            el_recoil.setTextContent("" + weapon_data.GetRecoil());
            el_weapon.appendChild(el_recoil);
            Element el_error_range_min = document.createElement("ErrorRangeMIN");
            el_error_range_min.setTextContent("" + weapon_data.GetErrorRangeMin());
            el_weapon.appendChild(el_error_range_min);
            Element el_error_range_max = document.createElement("ErrorRangeMAX");
            el_error_range_max.setTextContent("" + weapon_data.GetErrorRangeMax());
            el_weapon.appendChild(el_error_range_max);
            Element el_position_x = document.createElement("mx");
            Element el_position_y = document.createElement("my");
            Element el_position_z = document.createElement("mz");
            Vector position = weapon_data.GetPosition();
            el_position_x.setTextContent("" + position.GetX());
            el_position_y.setTextContent("" + position.GetY());
            el_position_z.setTextContent("" + position.GetZ());
            el_weapon.appendChild(el_position_x);
            el_weapon.appendChild(el_position_y);
            el_weapon.appendChild(el_position_z);
            Element el_flash_x = document.createElement("flashx");
            Element el_flash_y = document.createElement("flashy");
            Element el_flash_z = document.createElement("flashz");
            Vector flash_position = weapon_data.GetFlashPosition();
            el_flash_x.setTextContent("" + flash_position.GetX());
            el_flash_y.setTextContent("" + flash_position.GetY());
            el_flash_z.setTextContent("" + flash_position.GetZ());
            el_weapon.appendChild(el_flash_x);
            el_weapon.appendChild(el_flash_y);
            el_weapon.appendChild(el_flash_z);
            Element el_cartridge_px = document.createElement("yakkyou_px");
            Element el_cartridge_py = document.createElement("yakkyou_py");
            Element el_cartridge_pz = document.createElement("yakkyou_pz");
            Vector cartridge_position = weapon_data.GetCartridgePosition();
            el_cartridge_px.setTextContent("" + cartridge_position.GetX());
            el_cartridge_py.setTextContent("" + cartridge_position.GetY());
            el_cartridge_pz.setTextContent("" + cartridge_position.GetZ());
            el_weapon.appendChild(el_cartridge_px);
            el_weapon.appendChild(el_cartridge_py);
            el_weapon.appendChild(el_cartridge_pz);
            Element el_cartridge_sx = document.createElement("yakkyou_sx");
            Element el_cartridge_sy = document.createElement("yakkyou_sy");
            Vector cartridge_velocity = weapon_data.GetCartridgeVelocity();
            el_cartridge_sx.setTextContent("" + cartridge_velocity.GetX());
            el_cartridge_sy.setTextContent("" + cartridge_velocity.GetY());
            el_weapon.appendChild(el_cartridge_sx);
            el_weapon.appendChild(el_cartridge_sy);
            Element el_rapid_fire = document.createElement("blazingmode");
            if (!weapon_data.GetRapidFireEnabledFlag()) {
                el_rapid_fire.setTextContent("false");
            } else {
                el_rapid_fire.setTextContent("true");
            }
            el_weapon.appendChild(el_rapid_fire);
            Element el_scope_mode = document.createElement("scopemode");
            el_scope_mode.setTextContent("" + weapon_data.GetScopeMode().ordinal());
            el_weapon.appendChild(el_scope_mode);
            Element el_scale = document.createElement("size");
            el_scale.setTextContent("" + weapon_data.GetScale());
            el_weapon.appendChild(el_scale);
            int sound_id = weapon_data.GetSoundID();
            if (this.openxops_compatible_flag) {
                sound_id = WeaponSpecifierConverter.GetOpenXOPSSoundIDFromXOPSSoundID(sound_id);
            }
            Element el_sound_id = document.createElement("soundid");
            el_sound_id.setTextContent("" + sound_id);
            el_weapon.appendChild(el_sound_id);
            Element el_sound_volume = document.createElement("soundvolume");
            el_sound_volume.setTextContent("" + weapon_data.GetSoundVolume());
            el_weapon.appendChild(el_sound_volume);
            Element el_suppressor = document.createElement("silencer");
            if (!weapon_data.GetSuppressorEnabledFlag()) {
                el_suppressor.setTextContent("false");
            } else {
                el_suppressor.setTextContent("true");
            }
            el_weapon.appendChild(el_suppressor);
            Element el_shooting_stance = document.createElement("WeaponP");
            el_shooting_stance.setTextContent("" + weapon_data.GetShootingStance().ordinal());
            el_weapon.appendChild(el_shooting_stance);
            Element el_changeable_weapon = document.createElement("ChangeWeapon");
            el_changeable_weapon.setTextContent("" + weapon_data.GetChangeableWeapon());
            el_weapon.appendChild(el_changeable_weapon);
            Element el_number_of_projectiles = document.createElement("burst");
            el_number_of_projectiles.setTextContent("" + weapon_data.GetNumberOfProjectiles());
            el_weapon.appendChild(el_number_of_projectiles);
            el_weapon_list.appendChild(el_weapon);
            ++id;
        }
        File file = new File(xml_filename);
        int res = XMLFunctions.WriteXML((File)file, (Document)document);
        if (res < 0) {
            return -1;
        }
        return 0;
    }
}

