/*
 * Decompiled with CFR 0.152.
 */
package com.daxie.xops.properties.exe;

import com.daxie.basis.vector.Vector;
import com.daxie.log.LogFile;
import com.daxie.tool.ByteFunctions;
import com.daxie.xops.properties.entity.weapon.WeaponBinSpecifierAndEnumConverter;
import com.daxie.xops.properties.entity.weapon.WeaponData;
import com.daxie.xops.properties.entity.weapon.WeaponModelFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponModelType;
import com.daxie.xops.properties.entity.weapon.WeaponScopeMode;
import com.daxie.xops.properties.entity.weapon.WeaponShootingStance;
import com.daxie.xops.properties.entity.weapon.WeaponTextureFilenamesStock;
import com.daxie.xops.properties.entity.weapon.WeaponTextureType;
import java.util.List;

class XOPSExeWeaponDataWriter {
    private WeaponData[] weapon_data_array;

    public XOPSExeWeaponDataWriter(WeaponData[] weapon_data_array) {
        this.weapon_data_array = weapon_data_array;
    }

    public void Write(List<Byte> bin, int weapon_data_start_pos, int weapon_name_start_pos) {
        int i;
        if (this.weapon_data_array == null) {
            LogFile.WriteWarn((String)"[XOPSExeWeaponDataWriter-Write] Data is null.", (boolean)true);
            return;
        }
        if (this.weapon_data_array.length != 23) {
            LogFile.WriteWarn((String)("[XOPSExeWeaponDataWriter-Write] Invalid number of data. data_num:" + this.weapon_data_array.length), (boolean)true);
            return;
        }
        int pos = weapon_data_start_pos;
        for (i = 0; i < 23; ++i) {
            int itemp = this.weapon_data_array[i].GetAttackPower();
            byte[] b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetPenetration();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetFiringInterval();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetBulletSpeed();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetNumberOfBullets();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetReloadingTime();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetRecoil();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetErrorRangeMin();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetErrorRangeMax();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            Vector vtemp = this.weapon_data_array[i].GetPosition();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(vtemp.GetZ());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            vtemp = this.weapon_data_array[i].GetFlashPosition();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(vtemp.GetZ());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            vtemp = this.weapon_data_array[i].GetCartridgePosition();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(vtemp.GetZ());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            WeaponShootingStance shooting_stance = this.weapon_data_array[i].GetShootingStance();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponShootingStance(shooting_stance);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = !this.weapon_data_array[i].GetRapidFireEnabledFlag() ? 1 : 0;
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            WeaponScopeMode scope_mode = this.weapon_data_array[i].GetScopeMode();
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponScopeMode(scope_mode);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            String texture_filename = this.weapon_data_array[i].GetTextureFilename();
            WeaponTextureType texture_type = WeaponTextureFilenamesStock.GetWeaponTextureTypeFromFilename(texture_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponTextureType(texture_type);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            String model_filename = this.weapon_data_array[i].GetModelFilename();
            WeaponModelType model_type = WeaponModelFilenamesStock.GetWeaponModelTypeFromFilename(model_filename);
            itemp = WeaponBinSpecifierAndEnumConverter.GetBinSpecifierFromWeaponModelType(model_type);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(this.weapon_data_array[i].GetScale() * 10.0f);
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            vtemp = this.weapon_data_array[i].GetCartridgeVelocity();
            itemp = Math.round(vtemp.GetX());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = Math.round(vtemp.GetY());
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetSoundID();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = this.weapon_data_array[i].GetSoundVolume();
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            itemp = !this.weapon_data_array[i].GetSuppressorEnabledFlag() ? 0 : 1;
            b = ByteFunctions.short_to_byte_le((short)((short)itemp));
            bin.set(pos += 2, b[0]);
            bin.set(pos + 1, b[1]);
            pos += 2;
        }
        pos = weapon_name_start_pos;
        for (i = 0; i < 23; ++i) {
            int j;
            String name = this.weapon_data_array[22 - i].GetName();
            byte[] name_buffer = new byte[16];
            for (j = 0; j < 16; ++j) {
                name_buffer[j] = 0;
            }
            for (j = 0; j < name.length() && j < 15; ++j) {
                name_buffer[j] = (byte)name.charAt(j);
            }
            for (j = 0; j < 16; ++j) {
                bin.set(pos + j, name_buffer[j]);
            }
            pos += 16;
        }
    }
}

