/*
 * Decompiled with CFR 0.152.
 */
package ezy.ui.layout;

import android.app.Activity;
import android.app.Fragment;
import android.content.Context;
import android.content.res.TypedArray;
import android.graphics.drawable.Drawable;
import android.support.annotation.DrawableRes;
import android.support.annotation.LayoutRes;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.FrameLayout;
import android.widget.ImageView;
import android.widget.TextView;
import com.github.czy1121.loadinglayout.R;
import java.util.HashMap;
import java.util.Map;

public class LoadingLayout
extends FrameLayout {
    int mEmptyImage;
    CharSequence mEmptyText;
    int mErrorImage;
    CharSequence mErrorText;
    CharSequence mRetryText;
    View.OnClickListener mRetryButtonClickListener = new View.OnClickListener(){

        public void onClick(View v) {
            if (LoadingLayout.this.mRetryListener != null) {
                LoadingLayout.this.mRetryListener.onClick(v);
            }
        }
    };
    View.OnClickListener mRetryListener;
    OnInflateListener mOnEmptyInflateListener;
    OnInflateListener mOnErrorInflateListener;
    int mTextColor;
    int mTextSize;
    int mButtonTextColor;
    int mButtonTextSize;
    Drawable mButtonBackground;
    int mEmptyResId = -1;
    int mLoadingResId = -1;
    int mErrorResId = -1;
    int mContentId = -1;
    Map<Integer, View> mLayouts = new HashMap<Integer, View>();
    LayoutInflater mInflater;

    public static LoadingLayout wrap(Activity activity) {
        return LoadingLayout.wrap(((ViewGroup)activity.findViewById(0x1020002)).getChildAt(0));
    }

    public static LoadingLayout wrap(Fragment fragment) {
        return LoadingLayout.wrap(fragment.getView());
    }

    public static LoadingLayout wrap(View view) {
        if (view == null) {
            throw new RuntimeException("content view can not be null");
        }
        ViewGroup parent = (ViewGroup)view.getParent();
        if (view == null) {
            throw new RuntimeException("parent view can not be null");
        }
        ViewGroup.LayoutParams lp = view.getLayoutParams();
        int index = parent.indexOfChild(view);
        parent.removeView(view);
        LoadingLayout layout2 = new LoadingLayout(view.getContext());
        parent.addView((View)layout2, index, lp);
        layout2.addView(view);
        layout2.setContentView(view);
        return layout2;
    }

    public LoadingLayout(Context context) {
        this(context, null, R.attr.styleLoadingLayout);
    }

    public LoadingLayout(Context context, AttributeSet attrs) {
        this(context, attrs, R.attr.styleLoadingLayout);
    }

    public LoadingLayout(Context context, AttributeSet attrs, int defStyleAttr) {
        super(context, attrs, defStyleAttr);
        this.mInflater = LayoutInflater.from((Context)context);
        TypedArray a = context.obtainStyledAttributes(attrs, R.styleable.LoadingLayout, defStyleAttr, R.style.LoadingLayout_Style);
        this.mEmptyImage = a.getResourceId(R.styleable.LoadingLayout_llEmptyImage, -1);
        this.mEmptyText = a.getString(R.styleable.LoadingLayout_llEmptyText);
        this.mErrorImage = a.getResourceId(R.styleable.LoadingLayout_llErrorImage, -1);
        this.mErrorText = a.getString(R.styleable.LoadingLayout_llErrorText);
        this.mRetryText = a.getString(R.styleable.LoadingLayout_llRetryText);
        this.mTextColor = a.getColor(R.styleable.LoadingLayout_llTextColor, -6710887);
        this.mTextSize = a.getDimensionPixelSize(R.styleable.LoadingLayout_llTextSize, this.dp2px(16.0f));
        this.mButtonTextColor = a.getColor(R.styleable.LoadingLayout_llButtonTextColor, -6710887);
        this.mButtonTextSize = a.getDimensionPixelSize(R.styleable.LoadingLayout_llButtonTextSize, this.dp2px(16.0f));
        this.mButtonBackground = a.getDrawable(R.styleable.LoadingLayout_llButtonBackground);
        this.mEmptyResId = a.getResourceId(R.styleable.LoadingLayout_llEmptyResId, R.layout._loading_layout_empty);
        this.mLoadingResId = a.getResourceId(R.styleable.LoadingLayout_llLoadingResId, R.layout._loading_layout_loading);
        this.mErrorResId = a.getResourceId(R.styleable.LoadingLayout_llErrorResId, R.layout._loading_layout_error);
        a.recycle();
    }

    int dp2px(float dp) {
        return (int)(this.getResources().getDisplayMetrics().density * dp);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        if (this.getChildCount() == 0) {
            return;
        }
        if (this.getChildCount() > 1) {
            this.removeViews(1, this.getChildCount() - 1);
        }
        View view = this.getChildAt(0);
        this.setContentView(view);
        this.showLoading();
    }

    private void setContentView(View view) {
        this.mContentId = view.getId();
        this.mLayouts.put(this.mContentId, view);
    }

    public LoadingLayout setLoading(@LayoutRes int id2) {
        if (this.mLoadingResId != id2) {
            this.remove(this.mLoadingResId);
            this.mLoadingResId = id2;
        }
        return this;
    }

    public LoadingLayout setEmpty(@LayoutRes int id2) {
        if (this.mEmptyResId != id2) {
            this.remove(this.mEmptyResId);
            this.mEmptyResId = id2;
        }
        return this;
    }

    public LoadingLayout setOnEmptyInflateListener(OnInflateListener listener) {
        this.mOnEmptyInflateListener = listener;
        if (this.mOnEmptyInflateListener != null && this.mLayouts.containsKey(this.mEmptyResId)) {
            listener.onInflate(this.mLayouts.get(this.mEmptyResId));
        }
        return this;
    }

    public LoadingLayout setOnErrorInflateListener(OnInflateListener listener) {
        this.mOnErrorInflateListener = listener;
        if (this.mOnErrorInflateListener != null && this.mLayouts.containsKey(this.mErrorResId)) {
            listener.onInflate(this.mLayouts.get(this.mErrorResId));
        }
        return this;
    }

    public LoadingLayout setEmptyImage(@DrawableRes int resId) {
        this.mEmptyImage = resId;
        this.image(this.mEmptyResId, R.id.empty_image, this.mEmptyImage);
        return this;
    }

    public LoadingLayout setEmptyText(String value) {
        this.mEmptyText = value;
        this.text(this.mEmptyResId, R.id.empty_text, this.mEmptyText);
        return this;
    }

    public LoadingLayout setErrorImage(@DrawableRes int resId) {
        this.mErrorImage = resId;
        this.image(this.mErrorResId, R.id.error_image, this.mErrorImage);
        return this;
    }

    public LoadingLayout setErrorText(String value) {
        this.mErrorText = value;
        this.text(this.mErrorResId, R.id.error_text, this.mErrorText);
        return this;
    }

    public LoadingLayout setRetryText(String text) {
        this.mRetryText = text;
        this.text(this.mErrorResId, R.id.retry_button, this.mRetryText);
        return this;
    }

    public LoadingLayout setRetryListener(View.OnClickListener listener) {
        this.mRetryListener = listener;
        return this;
    }

    public void showLoading() {
        this.show(this.mLoadingResId);
    }

    public void showEmpty() {
        this.show(this.mEmptyResId);
    }

    public void showError() {
        this.show(this.mErrorResId);
    }

    public void showContent() {
        this.show(this.mContentId);
    }

    private void show(int layoutId) {
        for (View view : this.mLayouts.values()) {
            view.setVisibility(8);
        }
        this.layout(layoutId).setVisibility(0);
    }

    private void remove(int layoutId) {
        if (this.mLayouts.containsKey(layoutId)) {
            View vg = this.mLayouts.remove(layoutId);
            this.removeView(vg);
        }
    }

    private View layout(int layoutId) {
        if (this.mLayouts.containsKey(layoutId)) {
            return this.mLayouts.get(layoutId);
        }
        View layout2 = this.mInflater.inflate(layoutId, (ViewGroup)this, false);
        layout2.setVisibility(8);
        this.addView(layout2);
        this.mLayouts.put(layoutId, layout2);
        if (layoutId == this.mEmptyResId) {
            TextView view;
            ImageView img = (ImageView)layout2.findViewById(R.id.empty_image);
            if (img != null) {
                img.setImageResource(this.mEmptyImage);
            }
            if ((view = (TextView)layout2.findViewById(R.id.empty_text)) != null) {
                view.setText(this.mEmptyText);
                view.setTextColor(this.mTextColor);
                view.setTextSize(0, (float)this.mTextSize);
            }
            if (this.mOnEmptyInflateListener != null) {
                this.mOnEmptyInflateListener.onInflate(layout2);
            }
        } else if (layoutId == this.mErrorResId) {
            TextView btn;
            TextView txt;
            ImageView img = (ImageView)layout2.findViewById(R.id.error_image);
            if (img != null) {
                img.setImageResource(this.mErrorImage);
            }
            if ((txt = (TextView)layout2.findViewById(R.id.error_text)) != null) {
                txt.setText(this.mErrorText);
                txt.setTextColor(this.mTextColor);
                txt.setTextSize(0, (float)this.mTextSize);
            }
            if ((btn = (TextView)layout2.findViewById(R.id.retry_button)) != null) {
                btn.setText(this.mRetryText);
                btn.setTextColor(this.mButtonTextColor);
                btn.setTextSize(0, (float)this.mButtonTextSize);
                btn.setBackground(this.mButtonBackground);
                btn.setOnClickListener(this.mRetryButtonClickListener);
            }
            if (this.mOnErrorInflateListener != null) {
                this.mOnErrorInflateListener.onInflate(layout2);
            }
        }
        return layout2;
    }

    private void text(int layoutId, int ctrlId, CharSequence value) {
        TextView view;
        if (this.mLayouts.containsKey(layoutId) && (view = (TextView)this.mLayouts.get(layoutId).findViewById(ctrlId)) != null) {
            view.setText(value);
        }
    }

    private void image(int layoutId, int ctrlId, int resId) {
        ImageView view;
        if (this.mLayouts.containsKey(layoutId) && (view = (ImageView)this.mLayouts.get(layoutId).findViewById(ctrlId)) != null) {
            view.setImageResource(resId);
        }
    }

    public static interface OnInflateListener {
        public void onInflate(View var1);
    }
}

