/*
 * Decompiled with CFR 0.152.
 */
package com.github.zlprogresshud;

import android.app.Activity;
import android.content.Context;
import android.os.Handler;
import android.os.Message;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.ViewGroup;
import android.view.animation.Animation;
import android.view.animation.AnimationUtils;
import android.widget.FrameLayout;
import com.github.zlprogresshud.R;
import com.github.zlprogresshud.ZLProgressHUDAnimateUtil;
import com.github.zlprogresshud.listener.OnDismissListener;
import com.github.zlprogresshud.view.ZLCircleProgressBar;
import com.github.zlprogresshud.view.ZLProgressDefaultView;
import java.lang.ref.WeakReference;

public class ZLProgressHUD {
    private WeakReference<Context> contextWeak;
    private static final long DISMISSDELAYED = 1000L;
    private SVProgressHUDMaskType mSVProgressHUDMaskType;
    private boolean isShowing;
    private boolean isDismissing;
    private final FrameLayout.LayoutParams params = new FrameLayout.LayoutParams(-1, -2, 80);
    private ViewGroup decorView;
    private ViewGroup rootView;
    private ZLProgressDefaultView mSharedView;
    private Animation outAnim;
    private Animation inAnim;
    private int gravity = 17;
    private OnDismissListener onDismissListener;
    private Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            super.handleMessage(msg);
            ZLProgressHUD.this.dismiss();
        }
    };
    private final View.OnTouchListener onCancelableTouchListener = new View.OnTouchListener(){

        public boolean onTouch(View v, MotionEvent event) {
            if (event.getAction() == 0) {
                ZLProgressHUD.this.dismiss();
                ZLProgressHUD.this.setCancelable(false);
            }
            return false;
        }
    };
    private Animation.AnimationListener outAnimListener = new Animation.AnimationListener(){

        public void onAnimationStart(Animation animation) {
        }

        public void onAnimationEnd(Animation animation) {
            ZLProgressHUD.this.dismissImmediately();
        }

        public void onAnimationRepeat(Animation animation) {
        }
    };

    public ZLProgressHUD(Context context) {
        this.contextWeak = new WeakReference<Context>(context);
        this.gravity = 17;
        this.initViews();
        this.initDefaultView();
        this.initAnimation();
    }

    protected void initViews() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        LayoutInflater layoutInflater = LayoutInflater.from((Context)context);
        this.decorView = (FrameLayout)((Activity)context).getWindow().getDecorView();
        this.rootView = (FrameLayout)layoutInflater.inflate(R.layout.layout_svprogresshud, null, false);
        this.rootView.setLayoutParams((ViewGroup.LayoutParams)new FrameLayout.LayoutParams(-1, -1));
    }

    protected void initDefaultView() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return;
        }
        this.mSharedView = new ZLProgressDefaultView(context);
        this.params.gravity = this.gravity;
        this.mSharedView.setLayoutParams((ViewGroup.LayoutParams)this.params);
    }

    protected void initAnimation() {
        if (this.inAnim == null) {
            this.inAnim = this.getInAnimation();
        }
        if (this.outAnim == null) {
            this.outAnim = this.getOutAnimation();
        }
    }

    private void onAttached() {
        this.isShowing = true;
        if (this.rootView.getParent() != null) {
            ((ViewGroup)this.rootView.getParent()).removeView((View)this.rootView);
        }
        this.decorView.addView((View)this.rootView);
        if (this.mSharedView.getParent() != null) {
            ((ViewGroup)this.mSharedView.getParent()).removeView((View)this.mSharedView);
        }
        this.rootView.addView((View)this.mSharedView);
    }

    private void svShow() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.onAttached();
        this.mSharedView.startAnimation(this.inAnim);
    }

    public void showWithMaskType(SVProgressHUDMaskType maskType, String string) {
        if (this.isShowing()) {
            this.setMaskType(maskType);
            this.mSharedView.showWithStatus(string);
        } else {
            this.setMaskType(maskType);
            this.mSharedView.showWithStatus(string);
            this.svShow();
        }
    }

    public void showWithStatus(String string) {
        if (this.isShowing()) {
            this.mSharedView.showWithStatus(string);
        } else {
            this.setMaskType(SVProgressHUDMaskType.Black);
            this.mSharedView.showWithStatus(string);
            this.svShow();
        }
    }

    public void showInfoWithStatus(String string) {
        this.mSharedView.showInfoWithStatus(string);
        if (!this.isShowing()) {
            this.setMaskType(SVProgressHUDMaskType.Black);
            this.svShow();
        }
        this.scheduleDismiss();
    }

    public void showInfoWithStatus(String string, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showInfoWithStatus(string);
        if (!this.isShowing()) {
            this.svShow();
        }
        this.scheduleDismiss();
    }

    public void showSuccessWithStatus(String string) {
        this.setMaskType(SVProgressHUDMaskType.Black);
        this.mSharedView.showSuccessWithStatus(string);
        if (!this.isShowing()) {
            this.svShow();
        }
        this.scheduleDismiss();
    }

    public void showSuccessWithStatus(String string, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showSuccessWithStatus(string);
        if (!this.isShowing()) {
            this.svShow();
        }
        this.scheduleDismiss();
    }

    public void showErrorWithStatus(String string) {
        this.setMaskType(SVProgressHUDMaskType.Black);
        this.mSharedView.showErrorWithStatus(string);
        if (!this.isShowing()) {
            this.svShow();
        }
        this.scheduleDismiss();
    }

    public void showErrorWithStatus(String string, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showErrorWithStatus(string);
        if (!this.isShowing()) {
            this.svShow();
        }
        this.scheduleDismiss();
    }

    public void showWithProgress(int progress) {
        this.showWithProgress("", progress);
    }

    public void showWithProgress(String string, int progress) {
        this.showWithProgress(string, progress, SVProgressHUDMaskType.Black);
    }

    public void showWithProgress(String string, int progress, SVProgressHUDMaskType maskType) {
        this.setMaskType(maskType);
        this.mSharedView.showWithProgress(string, progress);
        if (!this.isShowing()) {
            this.svShow();
        }
    }

    public ZLCircleProgressBar getProgressBar() {
        return this.mSharedView.getCircleProgressBar();
    }

    public void setText(String string) {
        this.mSharedView.setText(string);
    }

    private void setMaskType(SVProgressHUDMaskType maskType) {
        this.mSVProgressHUDMaskType = maskType;
        switch (this.mSVProgressHUDMaskType) {
            case None: {
                this.configMaskType(17170445, false, false);
                break;
            }
            case Clear: {
                this.configMaskType(17170445, true, false);
                break;
            }
            case ClearCancel: {
                this.configMaskType(17170445, true, true);
                break;
            }
            case Black: {
                this.configMaskType(R.color.bgColor_overlay, true, false);
                break;
            }
            case BlackCancel: {
                this.configMaskType(R.color.bgColor_overlay, true, true);
                break;
            }
            case Gradient: {
                this.configMaskType(R.drawable.bg_overlay_gradient, true, false);
                break;
            }
            case GradientCancel: {
                this.configMaskType(R.drawable.bg_overlay_gradient, true, true);
                break;
            }
        }
    }

    private void configMaskType(int bg, boolean clickable, boolean cancelable) {
        this.rootView.setBackgroundResource(bg);
        this.rootView.setClickable(clickable);
        this.setCancelable(cancelable);
    }

    public boolean isShowing() {
        return this.rootView.getParent() != null || this.isShowing;
    }

    public void dismiss() {
        if (this.isDismissing) {
            return;
        }
        this.isDismissing = true;
        this.outAnim.setAnimationListener(this.outAnimListener);
        this.mSharedView.dismiss();
        this.mSharedView.startAnimation(this.outAnim);
    }

    public void dismissImmediately() {
        Log.e((String)"czl", (String)Thread.currentThread().getName());
        this.rootView.removeView((View)this.mSharedView);
        this.decorView.post(new Runnable(){

            @Override
            public void run() {
                ZLProgressHUD.this.decorView.removeView((View)ZLProgressHUD.this.rootView);
            }
        });
        this.isShowing = false;
        this.isDismissing = false;
        if (this.onDismissListener != null) {
            this.onDismissListener.onDismiss(this);
        }
    }

    public Animation getInAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = ZLProgressHUDAnimateUtil.getAnimationResource(this.gravity, true);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    public Animation getOutAnimation() {
        Context context = (Context)this.contextWeak.get();
        if (context == null) {
            return null;
        }
        int res = ZLProgressHUDAnimateUtil.getAnimationResource(this.gravity, false);
        return AnimationUtils.loadAnimation((Context)context, (int)res);
    }

    private void setCancelable(boolean isCancelable) {
        View view = this.rootView.findViewById(R.id.sv_outmost_container);
        if (isCancelable) {
            view.setOnTouchListener(this.onCancelableTouchListener);
        } else {
            view.setOnTouchListener(null);
        }
    }

    private void scheduleDismiss() {
        this.mHandler.removeCallbacksAndMessages(null);
        this.mHandler.sendEmptyMessageDelayed(0, 1000L);
    }

    public void setOnDismissListener(OnDismissListener listener) {
        this.onDismissListener = listener;
    }

    public OnDismissListener getOnDismissListener() {
        return this.onDismissListener;
    }

    public static enum SVProgressHUDMaskType {
        None,
        Clear,
        Black,
        Gradient,
        ClearCancel,
        BlackCancel,
        GradientCancel;

    }
}

