/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.xml.generator;

import java.util.Hashtable;
import java.util.Stack;
import org.cyclades.xml.generator.XMLGen;
import org.cyclades.xml.generator.XMLGeneratorException;

public class XMLWriter {
    private Stack elementLevelStack = new Stack();
    private XMLGen root = null;
    public static final String ENCODING_SCHEME_UTF8 = "UTF-8";
    public static final String ENCODING_SCHEME_US_ASCII = "US-ASCII";

    public XMLWriter(String encoding, String docRoot) throws XMLGeneratorException {
        String eLabel = "XMLdoc.XMLWriter: ";
        try {
            if (docRoot == null) {
                throw new Exception("Must specify doc root name.");
            }
            this.root = new XMLGen(encoding, docRoot, null);
            this.elementLevelStack.push(this.root);
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLdoc.XMLWriter: " + e);
        }
    }

    public XMLWriter(String encoding, String docRoot, Hashtable attributes) throws XMLGeneratorException {
        String eLabel = "XMLdoc.XMLWriter: ";
        try {
            if (docRoot == null) {
                throw new Exception("Must specify doc root name.");
            }
            this.root = new XMLGen(encoding, docRoot, attributes);
            this.elementLevelStack.push(this.root);
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLdoc.XMLWriter: " + e);
        }
    }

    public void addNode(String elementName, Hashtable attributes) throws XMLGeneratorException {
        String eLabel = "XMLDoc.addNode: ";
        try {
            this.elementLevelStack.push(new XMLGen(null, elementName, attributes));
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLDoc.addNode: " + e);
        }
    }

    public void addLeafNode(String elementName, Hashtable attributes, String data, boolean cData) throws XMLGeneratorException {
        String eLabel = "XMLDoc.addLeafNode: ";
        try {
            XMLGen xml = (XMLGen)this.elementLevelStack.peek();
            xml.addElement(elementName, attributes, data, cData);
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLDoc.addLeafNode: " + e);
        }
    }

    public void addRaw(String data) throws XMLGeneratorException {
        String eLabel = "XMLDoc.addRaw: ";
        try {
            XMLGen xml = (XMLGen)this.elementLevelStack.peek();
            xml.addRaw(data);
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLDoc.addRaw: " + e);
        }
    }

    public void addXML(String data) throws XMLGeneratorException {
        this.addRaw(data);
    }

    public void commitCurrentNode() throws XMLGeneratorException {
        String eLabel = "XMLDoc.commitNode: ";
        try {
            if (this.elementLevelStack.size() <= 1) {
                throw new Exception("XMLDoc.commitNode: Error, already at root node.");
            }
            XMLGen xmlChild = (XMLGen)this.elementLevelStack.pop();
            XMLGen xmlParent = (XMLGen)this.elementLevelStack.peek();
            xmlChild.done();
            xmlParent.addRaw(xmlChild.toString());
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLDoc.commitNode: " + e);
        }
    }

    public void flush() throws XMLGeneratorException {
        String eLabel = "XMLWriter.flush: ";
        try {
            int size = this.elementLevelStack.size() - 1;
            for (int i = 0; i < size; ++i) {
                this.commitCurrentNode();
            }
            this.root.done();
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLWriter.flush: " + e);
        }
    }

    public void done() throws XMLGeneratorException {
        String eLabel = "XMLWriter.done: ";
        try {
            this.flush();
        }
        catch (Exception e) {
            throw new XMLGeneratorException("XMLWriter.done: " + e);
        }
    }

    public String toString() {
        return this.root.toString();
    }
}

