/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.xml.comparitor;

import java.io.File;
import java.io.StringReader;
import java.io.StringWriter;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.TransformerFactoryConfigurationError;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.cyclades.xml.comparitor.XMLComparitorException;
import org.cyclades.xml.parser.XMLParserException;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class XMLComparitor {
    private Element templateRootElement;
    private boolean mOmit;
    private static final String OMIT_FLAG = "omit";

    public XMLComparitor(String xmlToMatch) throws XMLParserException {
        String eLabel = "XMLComparitor.XMLComparitor: ";
        try {
            this.templateRootElement = XMLComparitor.parseXML(xmlToMatch);
            if (this.templateRootElement == null) {
                throw new Exception("XMLComparitor.XMLComparitor: Root element came back null!");
            }
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.XMLComparitor: " + e);
        }
    }

    public XMLComparitor(Element xmlToMatch) throws XMLParserException {
        String eLabel = "XMLComparitor.XMLComparitor: ";
        try {
            if (xmlToMatch == null) {
                throw new Exception("XMLComparitor.XMLComparitor: Root element sent in as null!");
            }
            this.templateRootElement = xmlToMatch;
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.XMLComparitor: " + e);
        }
    }

    public static Element parseXML(String xml) throws XMLParserException {
        String eLabel = "XMLComparitor.parseXML: ";
        if (xml == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(new InputSource(new StringReader(xml)));
            return dom.getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.parseXML: " + e);
        }
    }

    public static Element parseXML(File xmlFile) throws XMLParserException {
        String eLabel = "XMLComparitor.parseXML: ";
        if (xmlFile == null) {
            return null;
        }
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            DocumentBuilder db = dbf.newDocumentBuilder();
            Document dom = db.parse(xmlFile);
            return dom.getDocumentElement();
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.parseXML: " + e);
        }
    }

    public boolean isMatch(String xml) throws XMLParserException {
        String eLabel = "XMLComparitor.isMatch: ";
        try {
            Element rootElement = XMLComparitor.parseXML(xml);
            try {
                this.matchElement(this.templateRootElement, rootElement);
            }
            catch (Exception ex) {
                return false;
            }
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.isMatch: " + e);
        }
        return true;
    }

    public boolean isMatch(Element xml) throws XMLParserException {
        String eLabel = "XMLComparitor.isMatch: ";
        try {
            this.matchElement(this.templateRootElement, xml);
        }
        catch (Exception ex) {
            return false;
        }
        return true;
    }

    private void matchElement(Node comparitor, Node compared) throws XMLParserException, XMLComparitorException {
        String eLabel = "XMLComparitor.matchElement: ";
        boolean omit = false;
        try {
            NodeList nl = comparitor.getChildNodes();
            block10: for (int i = 0; i < nl.getLength(); ++i) {
                Vector<Node> list;
                boolean bl = omit = XMLComparitor.getAttribute(nl.item(i), OMIT_FLAG) != null;
                if (omit) {
                    this.mOmit = true;
                }
                if (!nl.item(i).hasChildNodes()) {
                    if (nl.item(i).getNodeValue() == null) {
                        list = XMLComparitor.getMatchingChildNodes(compared, nl.item(i).getNodeName());
                        if (list == null || list.size() < 1) {
                            throw new Exception("XMLComparitor.matchElement: Missing node. See node:[" + nl.item(i).getNodeName() + "]");
                        }
                        boolean failure = true;
                        for (int j = 0; j < list.size(); ++j) {
                            if (list.elementAt(j).getFirstChild() != null) continue;
                            try {
                                this.compareAttributes(nl.item(i), list.elementAt(j));
                                failure = false;
                                break;
                            }
                            catch (Exception e) {
                                if (j != list.size() - 1) continue;
                                throw new Exception("Exception checking empty nodes: " + e);
                            }
                        }
                        if (!failure) continue;
                        throw new Exception("XMLComparitor.matchElement: Nested node encountered in Compared where there is blank in Comparator. See node:[" + nl.item(i).getNodeName() + "]");
                    }
                    boolean match = false;
                    NodeList children = compared.getChildNodes();
                    for (int j = 0; j < children.getLength(); ++j) {
                        match = nl.item(i).getNodeValue().equals(children.item(j).getNodeValue());
                        if (!match) continue;
                        if (!this.mOmit) break;
                        throw new XMLComparitorException("Omit match found. Element:[" + comparitor.getNodeName() + "]");
                    }
                    if (match) continue;
                    throw new XMLParserException("XMLComparitor.matchElement: XML mismatch. Leaf match not found for: [" + comparitor.getNodeName() + "][" + nl.item(i).getNodeValue() + "]");
                }
                list = XMLComparitor.getMatchingChildNodes(compared, nl.item(i).getNodeName());
                if (list.size() < 1) {
                    throw new XMLParserException("XMLComparitor.matchElement: Node name:[" + nl.item(i).getNodeName() + "] does not exist");
                }
                for (int j = 0; j < list.size(); ++j) {
                    try {
                        this.compareAttributes(nl.item(i), list.elementAt(j));
                        try {
                            this.matchElement(nl.item(i), list.elementAt(j));
                            continue block10;
                        }
                        catch (XMLComparitorException ex) {
                            throw new XMLComparitorException("" + ex);
                        }
                        catch (Exception ex) {
                            throw new XMLParserException("" + ex);
                        }
                    }
                    catch (XMLParserException exception) {
                        if (j != list.size() - 1) continue;
                        if (omit) {
                            this.mOmit = false;
                            continue block10;
                        }
                        throw new Exception("XMLComparitor.matchElement: " + exception);
                    }
                }
            }
        }
        catch (XMLComparitorException e) {
            throw new XMLComparitorException("XMLComparitor.matchElement: " + e);
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.matchElement: " + e);
        }
    }

    private void compareAttributes(Node comparitor, Node compared) throws XMLParserException {
        String eLabel = "XMLComparitor.compareAttributes: ";
        try {
            NamedNodeMap comparitorMap = comparitor.getAttributes();
            NamedNodeMap comparedMap = compared.getAttributes();
            if (comparitorMap == null && comparedMap == null) {
                return;
            }
            for (int i = 0; i < comparitorMap.getLength(); ++i) {
                Node comparatorNode = comparitorMap.item(i);
                String key = comparatorNode.getNodeName();
                if (key.toUpperCase().equals(OMIT_FLAG.toUpperCase())) continue;
                String value = comparatorNode.getNodeValue();
                Node comparedNode = comparedMap.getNamedItem(key);
                if (comparedNode == null) {
                    throw new Exception("Attribute [" + key + "] not found in compared XML tag [" + comparitor.getNodeName() + "]");
                }
                String valueToCompare = comparedNode.getNodeValue();
                if (value.equals(valueToCompare)) continue;
                throw new Exception("Value of attribute [" + key + "] not equal in compared XML tag [" + comparitor.getNodeName() + "]");
            }
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.compareAttributes: " + e);
        }
    }

    public static String getAttributeOrError(Node node, String attrName) throws XMLParserException {
        String aValue = XMLComparitor.getAttribute(node, attrName);
        if (aValue == null || aValue.trim().equals("")) {
            throw new XMLParserException(attrName + " attribute must exist!");
        }
        return aValue.trim();
    }

    public static String getAttributeOrNull(Node node, String attrName) throws XMLParserException {
        String aValue = XMLComparitor.getAttribute(node, attrName);
        if (aValue == null || aValue.trim().equals("")) {
            return null;
        }
        return aValue.trim();
    }

    public static String getAttribute(Node node, String matchString) throws XMLParserException {
        String eLabel = "XMLComparitor.getAttribute: ";
        String returnString = null;
        try {
            NamedNodeMap map = node.getAttributes();
            if (map == null) {
                return null;
            }
            for (int i = 0; i < map.getLength(); ++i) {
                Node comparatorNode = map.item(i);
                String key = comparatorNode.getNodeName();
                if (!key.toUpperCase().equals(matchString.toUpperCase())) continue;
                returnString = comparatorNode.getNodeValue();
            }
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.getAttribute: " + e);
        }
        return returnString;
    }

    public static Vector<Node> getMatchingChildNodes(Node node, String name) throws XMLParserException {
        String eLabel = "XMLComparitor.getMatchingChildNodes: ";
        Vector<Node> nodeVector = new Vector<Node>();
        try {
            NodeList nl = node.getChildNodes();
            for (int i = 0; i < nl.getLength(); ++i) {
                if (!nl.item(i).getNodeName().equals(name)) continue;
                nodeVector.add(nl.item(i));
            }
        }
        catch (Exception e) {
            throw new XMLParserException("XMLComparitor.getMatchingChildNodes: " + e);
        }
        return nodeVector;
    }

    public static Node getLargestChildNodeLong(NodeList list, String attributeName) throws Exception {
        String eLabel = "XMLComparitor.getLargestChildNodeLong: ";
        try {
            Node highestNode = null;
            for (int i = 0; i < list.getLength(); ++i) {
                if (highestNode != null && Long.parseLong(XMLComparitor.getAttribute(list.item(i), attributeName)) <= Long.parseLong(XMLComparitor.getAttribute(highestNode, attributeName))) continue;
                highestNode = list.item(i);
            }
            return highestNode;
        }
        catch (Exception e) {
            throw new Exception("XMLComparitor.getLargestChildNodeLong: " + e);
        }
    }

    public static Node getLargestChildNodeFloat(NodeList list, String attributeName) throws Exception {
        String eLabel = "XMLComparitor.getLargestChildNodeFloat: ";
        try {
            Node highestNode = null;
            for (int i = 0; i < list.getLength(); ++i) {
                if (highestNode != null && !(Float.parseFloat(XMLComparitor.getAttribute(list.item(i), attributeName)) > Float.parseFloat(XMLComparitor.getAttribute(highestNode, attributeName)))) continue;
                highestNode = list.item(i);
            }
            return highestNode;
        }
        catch (Exception e) {
            throw new Exception("XMLComparitor.getLargestChildNodeFloat: " + e);
        }
    }

    public static Node getChildNode(Document doc, Node parentNode, String tagValue, boolean create, String attributeName) throws Exception {
        String eLabel = "XMLComparitor.getChildNode: ";
        try {
            Node child = null;
            NodeList list = parentNode.getChildNodes();
            for (int i = 0; i < list.getLength(); ++i) {
                if (!tagValue.equals(XMLComparitor.getAttribute(list.item(i), attributeName))) continue;
                return list.item(i);
            }
            if (create) {
                child = XMLComparitor.addNewChildNode(doc, parentNode, tagValue, attributeName);
            }
            return child;
        }
        catch (Exception e) {
            throw new Exception("XMLComparitor.getChildNode: " + e);
        }
    }

    public static Node addNewChildNode(Document doc, Node parentNode, String tagValue, String attributeName) throws Exception {
        String eLabel = "XMLComparitor.addNewChildNode: ";
        try {
            Element newChildNode = doc.createElement("node");
            NamedNodeMap childAtts = newChildNode.getAttributes();
            Attr tag = doc.createAttribute(attributeName);
            tag.setValue(tagValue);
            childAtts.setNamedItem(tag);
            parentNode.appendChild(newChildNode);
            return newChildNode;
        }
        catch (Exception e) {
            throw new Exception("XMLComparitor.addNewChildNode: " + e);
        }
    }

    public static void main(String[] args) {
        try {
            if (args.length != 2) {
                System.out.println("useage: cmd comparator compared");
                return;
            }
            File file1 = new File(args[0]);
            File file2 = new File(args[1]);
            XMLComparitor xmlc = new XMLComparitor(XMLComparitor.parseXML(file1));
            if (xmlc.isMatch(XMLComparitor.parseXML(file2))) {
                System.out.println("MATCH");
            } else {
                System.out.println("NON_MATCH");
            }
        }
        catch (Exception e) {
            System.out.println("" + e);
        }
    }

    public static String nodeToString(Node node, boolean XMLDeclaration, boolean indent) throws TransformerFactoryConfigurationError, TransformerException {
        StringWriter sw = new StringWriter();
        Transformer t = TransformerFactory.newInstance().newTransformer();
        t.setOutputProperty("omit-xml-declaration", XMLDeclaration ? "no" : "yes");
        t.setOutputProperty("indent", indent ? "yes" : "no");
        t.transform(new DOMSource(node), new StreamResult(sw));
        return sw.toString();
    }

    public Element getDomRootElement() {
        return this.templateRootElement;
    }
}

