/*
 * Decompiled with CFR 0.152.
 */
package org.cyclades.xml.comparitor;

import java.util.Enumeration;
import java.util.Hashtable;
import org.cyclades.xml.comparitor.Criterion;
import org.cyclades.xml.comparitor.XMLComparitor;
import org.cyclades.xml.comparitor.XMLComparitorException;
import org.cyclades.xml.generator.XMLGeneratorException;
import org.cyclades.xml.generator.XMLWriter;
import org.cyclades.xml.generator.api.XMLGeneratingObject;
import org.cyclades.xml.parser.XMLParserException;
import org.cyclades.xml.parser.api.XMLGeneratedObject;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;

public class Criteria
extends XMLGeneratedObject
implements XMLGeneratingObject {
    private Hashtable criterionHash = new Hashtable();

    public Criteria() throws Exception {
        super(null);
    }

    public Criteria(Hashtable criterionHash) throws Exception {
        super(null);
        this.criterionHash = criterionHash;
    }

    public Criteria(String xmlString) throws XMLParserException {
        super(xmlString);
        this.populate();
        this.cleanUp();
    }

    private void addCriterion(Object criterionName) throws XMLComparitorException {
        String eLabel = "Criteria.addCriterion: ";
        try {
            this.criterionHash.put(criterionName, new Criterion(criterionName));
        }
        catch (Exception e) {
            throw new XMLComparitorException("Criteria.addCriterion: " + e);
        }
    }

    private void removeCriterion(Object criterionName) throws XMLComparitorException {
        String eLabel = "Criteria.removeCriterion: ";
        try {
            this.criterionHash.remove(criterionName);
        }
        catch (Exception e) {
            throw new XMLComparitorException("Criteria.removeCriterion: " + e);
        }
    }

    public void addConstraint(Object criterionName, Object constraintValue) throws XMLComparitorException {
        this.addConstraint(criterionName, constraintValue, false);
    }

    public void addConstraint(Object criterionName, Object constraintValue, boolean omit) throws XMLComparitorException {
        String eLabel = "Criteria.addConstraint: ";
        try {
            Criterion criterion = (Criterion)this.criterionHash.get(criterionName);
            if (criterion == null) {
                this.addCriterion(criterionName);
                criterion = (Criterion)this.criterionHash.get(criterionName);
            }
            criterion.addConstraint(constraintValue, omit);
        }
        catch (Exception e) {
            throw new XMLComparitorException("Criteria.addConstraint: " + e);
        }
    }

    public void removeConstraint(Object criterionName, Object constraint) throws XMLComparitorException {
        String eLabel = "Criteria.removeConstraint: ";
        try {
            Criterion criterion = (Criterion)this.criterionHash.get(criterionName);
            if (criterion == null) {
                throw new Exception("Criterion " + criterionName + " does not exist!");
            }
            criterion.removeConstraint(constraint);
            if (criterion.size() < 1) {
                this.removeCriterion(criterionName);
            }
        }
        catch (Exception e) {
            throw new XMLComparitorException("Criteria.removeConstraint: " + e);
        }
    }

    public boolean constraintExists(Object criterionName, Object constraint) throws XMLComparitorException {
        String eLabel = "Criteria.constraintExists: ";
        try {
            Criterion criterion = (Criterion)this.criterionHash.get(criterionName);
            if (criterion == null) {
                return false;
            }
            return criterion.constraintExists(constraint);
        }
        catch (Exception e) {
            throw new XMLComparitorException("Criteria.constraintExists: " + e);
        }
    }

    @Override
    public String toXMLString() throws XMLGeneratorException {
        String eLabel = "Person.toXMLString: ";
        try {
            XMLWriter writer = new XMLWriter(null, "criteria");
            Enumeration hashEnum = this.criterionHash.keys();
            while (hashEnum.hasMoreElements()) {
                String key = (String)hashEnum.nextElement();
                Criterion criterion = (Criterion)this.criterionHash.get(key);
                writer.addXML(criterion.toXMLString());
            }
            writer.done();
            return writer.toString();
        }
        catch (Exception e) {
            throw new XMLGeneratorException("Person.toXMLString: " + e);
        }
    }

    public Element getXMLDOMRoot() throws XMLParserException, XMLGeneratorException {
        return XMLComparitor.parseXML(this.toXMLString());
    }

    public Hashtable getCriterionHashtable() {
        return this.criterionHash;
    }

    @Override
    public void populate() throws XMLParserException {
        String eLabel = "XMLParserExample.populate: ";
        try {
            Element rootElement = this.getRootElement();
            if (rootElement == null) {
                throw new Exception("Root element is null");
            }
            NodeList criterionList = rootElement.getChildNodes();
            for (int i = 0; i < criterionList.getLength(); ++i) {
                String name = XMLComparitor.getAttribute(criterionList.item(i), "name");
                boolean omit = XMLComparitor.getAttribute(criterionList.item(i), "omit") != null;
                NodeList constraintList = criterionList.item(i).getChildNodes();
                for (int j = 0; j < constraintList.getLength(); ++j) {
                    String constraint = constraintList.item(j).getFirstChild().getNodeValue();
                    if (constraint == null || constraint.equals("")) continue;
                    this.addConstraint(name, constraint, omit);
                }
            }
        }
        catch (Exception e) {
            throw new XMLParserException("XMLParserExample.populate: " + e);
        }
    }
}

